/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth.schemaregistry;

import io.confluent.common.security.auth.schemaregistry.SchemaRegistryClientAssertionConfig;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientConfig;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.CachedOauthTokenRetriever;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.OauthTokenCache;
import io.confluent.kafka.schemaregistry.client.ssl.HostSslSocketFactory;
import io.confluent.kafka.security.oauthbearer.HttpRequestFormatterFactory;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.ClientJwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpRequestFormatter;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;

public class OAuthClientAssertionCredentialProvider
implements BearerAuthCredentialProvider {
    private CachedOauthTokenRetriever cachedOauthTokenRetriever;
    private JwtRetriever jwtRetriever;
    Map<String, ?> config;

    public String alias() {
        return "OAUTHBEARER_CLIENTASSERTION";
    }

    public String getBearerToken(URL url) {
        return this.cachedOauthTokenRetriever.getToken();
    }

    public void configure(Map<String, ?> config) {
        this.config = config;
        ConfigurationUtils cu = new ConfigurationUtils(config);
        this.cachedOauthTokenRetriever = new CachedOauthTokenRetriever();
        this.jwtRetriever = this.getJwtRetriever(cu);
        this.cachedOauthTokenRetriever.configure(this.jwtRetriever, this.getJwtValidator(config), this.getOauthTokenCache(config));
    }

    private OauthTokenCache getOauthTokenCache(Map<String, ?> map) {
        short cacheExpiryBufferSeconds = SchemaRegistryClientConfig.getBearerAuthCacheExpiryBufferSeconds(map);
        return new OauthTokenCache(cacheExpiryBufferSeconds);
    }

    private JwtRetriever getJwtRetriever(ConfigurationUtils cu) {
        String clientId = cu.validateString("bearer.auth.client.id", false);
        String scope = cu.validateString("bearer.auth.scope", false);
        String clientAssertionIssuer = (String)cu.get("bearer.assertion.claim.iss");
        String clientAssertionLocation = (String)cu.get("bearer.assertion.file");
        if (clientAssertionLocation == null && clientAssertionIssuer == null) {
            throw new ConfigException("Either bearer.assertion.claim.iss or bearer.assertion.file must be set");
        }
        HttpRequestFormatter httpRequestFormatter = this.getHttpRequestFormatter(clientId);
        Long retryBackoffMs = 100L;
        Long retryBackoffMaxMs = 10000L;
        Integer loginConnectTimeoutMs = null;
        Integer loginReadTimeoutMs = null;
        JaasOptionsUtils jou = new JaasOptionsUtils(SchemaRegistryClientConfig.getClientSslConfig(this.config));
        HostSslSocketFactory sslSocketFactory = null;
        URL url = cu.validateUrl("bearer.auth.issuer.endpoint.url");
        if (jou.shouldCreateSSLSocketFactory(url)) {
            sslSocketFactory = new HostSslSocketFactory(jou.createSSLSocketFactory(), url.getHost());
        }
        return new HttpJwtRetriever(httpRequestFormatter, scope, (SSLSocketFactory)sslSocketFactory, url.toString(), retryBackoffMs.longValue(), retryBackoffMaxMs.longValue(), loginConnectTimeoutMs, loginReadTimeoutMs);
    }

    private HttpRequestFormatter getHttpRequestFormatter(String clientId) {
        SchemaRegistryClientAssertionConfig clientAssertionConfig = new SchemaRegistryClientAssertionConfig(this.config);
        ConfigurationUtils cu = new ConfigurationUtils(clientAssertionConfig.saslClientConfigs());
        HashMap<String, String> jouOptions = new HashMap<String, String>();
        jouOptions.put("clientId", clientId);
        JaasOptionsUtils jou = new JaasOptionsUtils(jouOptions);
        try {
            return HttpRequestFormatterFactory.create((ConfigurationUtils)cu, (JaasOptionsUtils)jou);
        }
        catch (ConfigException e) {
            String m = e.getMessage();
            String finalMessage = m.replaceFirst("sasl\\.oauth", "");
            throw new ConfigException(finalMessage);
        }
    }

    private JwtValidator getJwtValidator(Map<String, ?> configs) {
        String scopeClaimName = SchemaRegistryClientConfig.getBearerAuthScopeClaimName(configs);
        String subClaimName = SchemaRegistryClientConfig.getBearerAuthSubClaimName(configs);
        Map<String, String> saslConfigs = Map.of("sasl.oauthbearer.scope.claim.name", scopeClaimName, "sasl.oauthbearer.sub.claim.name", subClaimName);
        ClientJwtValidator validator = new ClientJwtValidator();
        validator.configure(saslConfigs, "OAUTHBEARER", List.of());
        return validator;
    }

    public void close() throws IOException {
        if (this.jwtRetriever != null) {
            this.jwtRetriever.close();
        }
    }
}

