/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeAuthenticator
extends LoginAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(CompositeAuthenticator.class);
    private final Authenticator http;
    private final Authenticator x509;
    private final boolean allowAnonymousUser;

    public CompositeAuthenticator(Authenticator http, Authenticator x509, boolean allowAnonymousUser) {
        this.http = http;
        this.x509 = x509;
        this.allowAnonymousUser = allowAnonymousUser;
    }

    public String getAuthenticationType() {
        return "BEARER+BASIC+X509";
    }

    public AuthenticationState validateRequest(Request request, Response response, Callback callback) throws ServerAuthException {
        log.debug("Processing composite authenticationState");
        if (request.getHeaders().get(HttpHeader.AUTHORIZATION) != null) {
            log.debug("AUTHORIZATION header present, processing HTTP authorization");
            return this.http.validateRequest(request, response, callback);
        }
        log.debug("Attempting to execute certificate authenticationState");
        AuthenticationState authenticationState = this.x509.validateRequest(request, response, Callback.NOOP);
        if (authenticationState != AuthenticationState.CHALLENGE) {
            log.debug("Valid certificate found, processing mTLS authorization");
            return authenticationState;
        }
        if (this.allowAnonymousUser) {
            log.debug("No authenticationState data provided, continuing as anonymous");
            return AuthenticationState.CHALLENGE;
        }
        log.debug("No certificate authorization, processing HTTP authorization");
        return this.http.validateRequest(request, response, callback);
    }

    public void setConfiguration(Authenticator.Configuration configuration) {
        super.setConfiguration(configuration);
        this.http.setConfiguration(configuration);
        this.x509.setConfiguration(configuration);
    }

    public boolean isAllowAnonymousUser() {
        return this.allowAnonymousUser;
    }
}

