/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.license;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.common.security.license.MultiLicenseBackgroundFetcher;
import io.confluent.common.security.license.MultiLicenseInitializer;
import io.confluent.license.kafka.BrokerDetectionException;
import io.confluent.license.kafka.BrokerDetector;
import io.confluent.license.kafka.BrokerType;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLicenseBrokerHandler
extends MultiLicenseBackgroundFetcher {
    private static final Logger log = LoggerFactory.getLogger(MultiLicenseBrokerHandler.class);
    private final Properties consumerProperties;
    private String licenseString;
    private volatile BrokerType brokerType = null;
    private volatile boolean brokerTypeInitialized = false;
    private volatile boolean initialLicenseChecksCompleted = false;
    @VisibleForTesting
    private BrokerDetector brokerDetector = BrokerDetector.create();

    public MultiLicenseBrokerHandler(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, String licenseString) {
        super(topic, producerConfig, consumerConfig, topicConfig);
        Properties props = new Properties();
        props.putAll(consumerConfig);
        this.consumerProperties = props;
        this.licenseString = licenseString;
    }

    @Override
    protected void runOneIteration() {
        log.info("run one handler iteration");
        try {
            if (!this.brokerTypeInitialized) {
                this.detectBrokerType();
            }
            if (this.brokerTypeInitialized && !this.initialLicenseChecksCompleted) {
                this.cacheLicenses.set(MultiLicenseInitializer.registerOrGenerateNewLicense(this, this.brokerType, this.licenseString));
                this.initialLicenseChecksCompleted = true;
            }
            if (this.brokerType == BrokerType.UNKNOWN) {
                this.brokerTypeInitialized = false;
            }
            if (this.initialLicenseChecksCompleted) {
                super.runOneIteration();
            }
        }
        catch (Exception e) {
            log.error("Error during license broker handler iteration", (Throwable)e);
        }
    }

    private synchronized void detectBrokerType() {
        if (this.brokerTypeInitialized) {
            return;
        }
        try {
            log.info("Detecting broker type...");
            this.brokerType = this.brokerDetector.determineBrokerType(this.consumerProperties);
            this.brokerTypeInitialized = true;
            log.info("Successfully detected broker type: {}", (Object)this.brokerType);
        }
        catch (BrokerDetectionException e) {
            log.error("Failed to detect broker type, will retry on next iteration", (Throwable)e);
        }
    }

    public BrokerType brokerType() {
        return this.brokerType;
    }

    @VisibleForTesting
    public synchronized void setBrokerDetector(BrokerDetector brokerDetector) {
        this.brokerDetector = brokerDetector;
    }

    @VisibleForTesting
    public void setBrokerType(BrokerType brokerType) {
        this.brokerType = brokerType;
        this.brokerTypeInitialized = true;
    }

    @VisibleForTesting
    public void resetInitialLicenseChecks() {
        this.initialLicenseChecksCompleted = false;
    }
}

