/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.server.storage.log.FetchPartitionStats;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;

public interface AbstractLogReadResult {
    public AbstractFetchDataInfo info();

    public Optional<FetchResponseData.EpochEndOffset> divergingEpoch();

    public long highWatermark();

    public long leaderLogStartOffset();

    public long leaderLogEndOffset();

    public long fetchTimeMs();

    public OptionalLong lastStableOffset();

    public Optional<Throwable> exception();

    public OptionalInt preferredReadReplica();

    public Records records();

    public long readLatencyNanos();

    default public Errors error() {
        return this.exception().map(Errors::forException).orElse(Errors.NONE);
    }

    default public FetchPartitionData toFetchPartitionData(boolean isReassignmentFetch) {
        return this.toFetchPartitionData(isReassignmentFetch, 0L, 0L);
    }

    default public FetchPartitionData toFetchPartitionData(boolean isReassignmentFetch, long extraReadLatencyNanos, long tierFetchTimeNanos) {
        return new FetchPartitionData(this.error(), this.highWatermark(), this.leaderLogStartOffset(), this.records(), this.divergingEpoch(), this.lastStableOffset(), this.info().abortedTransactions(), this.preferredReadReplica(), isReassignmentFetch, new FetchPartitionStats(this.readLatencyNanos() + extraReadLatencyNanos, tierFetchTimeNanos));
    }
}

