/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.Tenant;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.CellControllerMetrics;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.slf4j.Logger;

public final class CellControllerMetricsPublisher
implements MetadataPublisher {
    static final String PUBLISH_EVENT_NAME = "PublishEvent";
    private final Logger log;
    private final CellControllerMetrics metrics;
    private final Function<String, String> topicNameToTenant;
    private final Time time;
    private final EventQueue queue;
    private final long updatePeriodNs;
    private volatile MetadataImage latestImage;
    private volatile long numPublishes;

    public CellControllerMetricsPublisher(CellControllerMetrics metrics, Function<String, String> topicNameToTenant, Time time, int nodeId, long updatePeriodNs) {
        LogContext logContext = new LogContext("[CelltControllerMetricsPublisher id=" + nodeId + "] ");
        this.log = logContext.logger(CellControllerMetricsPublisher.class);
        this.metrics = metrics;
        this.topicNameToTenant = topicNameToTenant;
        this.time = time;
        this.queue = new KafkaEventQueue(time, logContext, String.format("cell-controller-metrics-publisher-%d", nodeId), (EventQueue.Event)new CleanupEvent());
        this.updatePeriodNs = updatePeriodNs;
        this.latestImage = MetadataImage.EMPTY;
        this.numPublishes = 0L;
        this.schedulePublishEvent(time.nanoseconds());
    }

    @Override
    public String name() {
        return "CellControllerMetadataMetricsPublisher";
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.latestImage = newImage;
    }

    /*
     * Could not resolve type clashes
     */
    public void publishImage(long startTimeNs, MetadataImage metadataImage) {
        if (metadataImage.cells().isEmpty()) {
            this.log.info("No cells found. Skipping cell metrics refresh.");
            return;
        }
        int readyCellCount = 0;
        int quarantinedCellCount = 0;
        int excludedCellCount = 0;
        int notTenantAssignableCellCount = 0;
        int totalPartitions = 0;
        HashMap registeredBrokers = new HashMap(metadataImage.cluster().brokers().size());
        HashMap<Integer, Integer> brokerToCell = new HashMap<Integer, Integer>(metadataImage.cluster().brokers().size());
        metadataImage.cluster().brokers().entrySet().forEach(entry -> registeredBrokers.put((Integer)entry.getKey(), !((BrokerRegistration)entry.getValue()).fenced()));
        HashMap<Integer, CellControllerMetrics.CellMetrics> newCellMetrics = new HashMap<Integer, CellControllerMetrics.CellMetrics>(metadataImage.cells().cellIdToCell().size());
        for (Tenant tenant : metadataImage.tenants().tenantIdToTenant().values()) {
            tenant.cellIds().forEach(cellId -> ++newCellMetrics.computeIfAbsent(cellId, (Function<Integer, CellControllerMetrics.CellMetrics>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$publishImage$2(java.lang.Integer ), (Ljava/lang/Integer;)Lorg/apache/kafka/controller/metrics/CellControllerMetrics$CellMetrics;)()).tenantCount);
        }
        for (Cell cell : metadataImage.cells().cellIdToCell().values()) {
            newCellMetrics.computeIfAbsent(Integer.valueOf((int)cell.cellId()), (Function<Integer, CellControllerMetrics.CellMetrics>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$publishImage$3(java.lang.Integer ), (Ljava/lang/Integer;)Lorg/apache/kafka/controller/metrics/CellControllerMetrics$CellMetrics;)()).brokerCount += cell.brokers().size();
            switch (cell.state()) {
                case READY: {
                    ++readyCellCount;
                    break;
                }
                case QUARANTINED: {
                    ++quarantinedCellCount;
                    break;
                }
                case EXCLUDED: {
                    ++excludedCellCount;
                    break;
                }
            }
            boolean foundUnfencedBrokerForCell = false;
            Iterator iterator = cell.brokers().iterator();
            while (iterator.hasNext()) {
                int brokerId = (Integer)iterator.next();
                Boolean fenceStatusForBroker = (Boolean)registeredBrokers.remove(brokerId);
                if (fenceStatusForBroker == null) {
                    this.log.warn("Broker {} is part of cell {} but not part of registered brokers {}", new Object[]{brokerId, cell, registeredBrokers});
                } else if (fenceStatusForBroker.booleanValue()) {
                    foundUnfencedBrokerForCell = true;
                }
                brokerToCell.put(brokerId, cell.cellId());
            }
            if (foundUnfencedBrokerForCell) continue;
            ++notTenantAssignableCellCount;
        }
        for (TopicImage topicImage : metadataImage.topics().topicsById().values()) {
            Tenant tenant;
            String tenantName = this.topicNameToTenant.apply(topicImage.name());
            if (tenantName == null || (tenant = metadataImage.tenants().tenantIdToTenant().get(tenantName)) == null) continue;
            HashMap<Integer, Integer> cellToNumReplicas = new HashMap<Integer, Integer>();
            for (PartitionRegistration partition : topicImage.partitions().values()) {
                for (int brokerId : partition.replicas) {
                    Integer cellId2 = (Integer)brokerToCell.get(brokerId);
                    if (cellId2 == null) {
                        this.log.warn("For tenant {}, Broker {} has its replicas, but does not have a cell id set", (Object)tenantName, (Object)brokerId);
                        continue;
                    }
                    cellToNumReplicas.put(cellId2, cellToNumReplicas.getOrDefault(cellId2, 0) + 1);
                }
                ++totalPartitions;
            }
            for (Map.Entry entry2 : cellToNumReplicas.entrySet()) {
                int cellId3 = (Integer)entry2.getKey();
                int numReplicas = (Integer)entry2.getValue();
                CellControllerMetrics.CellMetrics cellMetrics = newCellMetrics.computeIfAbsent(cellId3, __ -> new CellControllerMetrics.CellMetrics());
                cellMetrics.replicaCount += numReplicas;
                if (tenant.cellIds().contains(cellId3)) continue;
                this.log.debug("Tenant {} has replicas on non-host cell {} for topic {}. Adding it to outgoing tenants", new Object[]{tenantName, topicImage.name(), cellId3});
                cellMetrics.outgoingTenants.add(tenantName);
                this.addIncomingTenantMetricForAllTenantCells(newCellMetrics, tenant.cellIds(), tenantName);
            }
            Iterator<Object> iterator = tenant.cellIds().iterator();
            while (iterator.hasNext()) {
                int cellId4 = (Integer)iterator.next();
                if (cellToNumReplicas.containsKey(cellId4) || topicImage.partitions().size() <= 1) continue;
                this.log.debug("Tenant {} has no replicas on cell {}. Adding it to incoming tenants", (Object)tenantName, (Object)cellId4);
                newCellMetrics.computeIfAbsent((Integer)Integer.valueOf((int)cellId4), (Function<Integer, CellControllerMetrics.CellMetrics>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$publishImage$5(java.lang.Integer ), (Ljava/lang/Integer;)Lorg/apache/kafka/controller/metrics/CellControllerMetrics$CellMetrics;)()).incomingTenants.add(tenantName);
            }
        }
        this.metrics.setReadyCellCount(readyCellCount);
        this.metrics.setQuarantinedCellCount(quarantinedCellCount);
        this.metrics.setExcludedCellCount(excludedCellCount);
        this.metrics.setNotTenantAssignableCellCount(notTenantAssignableCellCount);
        this.metrics.setStrayBrokerCount(registeredBrokers.size());
        this.metrics.setCellMigrationState(metadataImage.cells().cellMigrationState());
        this.metrics.setCellMetrics(newCellMetrics);
        this.metrics.createCellMetricsIfNeeded();
        ++this.numPublishes;
        long endTimNs = this.time.nanoseconds();
        this.log.info("Refreshed cell metrics for {} cells, {} tenants, {} partitions in {} ms", new Object[]{metadataImage.cells().cellIdToCell().size(), metadataImage.tenants().tenantIdToTenant().size(), totalPartitions, TimeUnit.NANOSECONDS.toMillis(endTimNs - startTimeNs)});
    }

    void addIncomingTenantMetricForAllTenantCells(Map<Integer, CellControllerMetrics.CellMetrics> cellMetrics, List<Integer> cellIds, String tenantName) {
        for (Integer cellId : cellIds) {
            CellControllerMetrics.CellMetrics targetCellMetrics = cellMetrics.computeIfAbsent(cellId, __ -> new CellControllerMetrics.CellMetrics());
            targetCellMetrics.incomingTenants.add(tenantName);
        }
    }

    void schedulePublishEvent(long startTimeNs) {
        long delayNs = startTimeNs + this.updatePeriodNs;
        this.queue.scheduleDeferred(PUBLISH_EVENT_NAME, (UnaryOperator)new EventQueue.EarliestDeadlineFunction(delayNs), (EventQueue.Event)new PublishEvent());
    }

    long numPublishes() {
        return this.numPublishes;
    }

    @Override
    public void close() throws InterruptedException {
        this.queue.cancelDeferred(PUBLISH_EVENT_NAME);
        this.queue.close();
    }

    private static /* synthetic */ CellControllerMetrics.CellMetrics lambda$publishImage$5(Integer __) {
        return new CellControllerMetrics.CellMetrics();
    }

    private static /* synthetic */ CellControllerMetrics.CellMetrics lambda$publishImage$3(Integer __) {
        return new CellControllerMetrics.CellMetrics();
    }

    private static /* synthetic */ CellControllerMetrics.CellMetrics lambda$publishImage$2(Integer __) {
        return new CellControllerMetrics.CellMetrics();
    }

    class CleanupEvent
    implements EventQueue.Event {
        CleanupEvent() {
        }

        public void run() throws Exception {
            try {
                CellControllerMetricsPublisher.this.metrics.close();
            }
            catch (Exception e) {
                CellControllerMetricsPublisher.this.log.error("error closing metrics", (Throwable)e);
            }
        }
    }

    class PublishEvent
    implements EventQueue.Event {
        PublishEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Exception {
            long startTimeNs = CellControllerMetricsPublisher.this.time.nanoseconds();
            try {
                CellControllerMetricsPublisher.this.publishImage(startTimeNs, CellControllerMetricsPublisher.this.latestImage);
            }
            catch (Exception e) {
                CellControllerMetricsPublisher.this.log.error("error publishing cell metrics", (Throwable)e);
            }
            finally {
                CellControllerMetricsPublisher.this.schedulePublishEvent(startTimeNs);
            }
        }
    }
}

