/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.fault.FaultHandler;

class ConfluentControllerMetricsCache {
    private final FaultHandler faultHandler;
    private final Function<String, String> topicNameToTenant;
    private final String nodeIdString;
    private final int staticDefaultMinIsr;
    private boolean firstPublish;
    private MetadataImage prevImage;
    private OptionalInt clusterLevelMinIsrConfig;
    private OptionalInt nodeLevelMinIsrConfig;
    private Map<String, Integer> topicToMinIsr;

    ConfluentControllerMetricsCache(FaultHandler faultHandler, Function<String, String> topicNameToTenant, int nodeId, int staticDefaultMinIsr) {
        this.faultHandler = faultHandler;
        this.topicNameToTenant = topicNameToTenant;
        this.nodeIdString = "" + nodeId;
        this.staticDefaultMinIsr = staticDefaultMinIsr;
        this.clear();
    }

    void clear() {
        this.firstPublish = true;
        this.prevImage = MetadataImage.EMPTY;
        this.clusterLevelMinIsrConfig = OptionalInt.empty();
        this.nodeLevelMinIsrConfig = OptionalInt.empty();
        this.topicToMinIsr = new HashMap<String, Integer>();
    }

    boolean firstPublish() {
        return this.firstPublish;
    }

    void setFirstPublish(boolean firstPublish) {
        this.firstPublish = firstPublish;
    }

    FaultHandler faultHandler() {
        return this.faultHandler;
    }

    String topicNameToTenant(String topicName) {
        return this.topicNameToTenant.apply(topicName);
    }

    String nodeIdString() {
        return this.nodeIdString;
    }

    int minIsrForTopic(String topicName) {
        Integer topicLevelMinIsr = this.topicToMinIsr.get(topicName);
        if (topicLevelMinIsr != null) {
            return topicLevelMinIsr;
        }
        if (this.nodeLevelMinIsrConfig.isPresent()) {
            return this.nodeLevelMinIsrConfig.getAsInt();
        }
        if (this.clusterLevelMinIsrConfig.isPresent()) {
            return this.clusterLevelMinIsrConfig.getAsInt();
        }
        return this.staticDefaultMinIsr;
    }

    int minIsrForTopic(String topicName, Map<String, OptionalInt> topicToMinIsrChanges) {
        OptionalInt changeTopicLevelMinIsr = topicToMinIsrChanges.get(topicName);
        if (changeTopicLevelMinIsr != null) {
            if (changeTopicLevelMinIsr.isPresent()) {
                return changeTopicLevelMinIsr.getAsInt();
            }
        } else {
            Integer topicLevelMinIsr = this.topicToMinIsr.get(topicName);
            if (topicLevelMinIsr != null) {
                return topicLevelMinIsr;
            }
        }
        if (this.nodeLevelMinIsrConfig.isPresent()) {
            return this.nodeLevelMinIsrConfig.getAsInt();
        }
        if (this.clusterLevelMinIsrConfig.isPresent()) {
            return this.clusterLevelMinIsrConfig.getAsInt();
        }
        return this.staticDefaultMinIsr;
    }

    void setClusterLevelMinIsrConfig(OptionalInt clusterLevelMinIsrConfig) {
        this.clusterLevelMinIsrConfig = clusterLevelMinIsrConfig;
    }

    void setNodeLevelMinIsrConfig(OptionalInt nodeLevelMinIsrConfig) {
        this.nodeLevelMinIsrConfig = nodeLevelMinIsrConfig;
    }

    void setPerTopicMinIsrConfig(String topicName, OptionalInt minIsr) {
        if (minIsr.isPresent()) {
            this.topicToMinIsr.put(topicName, minIsr.getAsInt());
        } else {
            this.topicToMinIsr.remove(topicName);
        }
    }

    MetadataImage prevImage() {
        return this.prevImage;
    }

    void setPrevImage(MetadataImage nextImage) {
        this.prevImage = nextImage;
    }
}

