/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.image.node.ClusterLinksImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.ClusterLink;

public class ClusterLinksImage {
    public static final short CLUSTER_LINK_RECORD_VERSION = 1;
    public static final ClusterLinksImage EMPTY = new ClusterLinksImage(Map.of(), Map.of(), Map.of());
    private final Map<Uuid, ClusterLink> linksById;
    private final Map<String, ClusterLink> linksByName;
    private final Map<String, Set<String>> linkNamesByTenant;

    public ClusterLinksImage(Map<Uuid, ClusterLink> linksById, Map<String, ClusterLink> linksByName, Map<String, Set<String>> linkNamesByTenant) {
        this.linksById = Collections.unmodifiableMap(linksById);
        this.linksByName = Collections.unmodifiableMap(linksByName);
        this.linkNamesByTenant = Collections.unmodifiableMap(linkNamesByTenant);
    }

    public boolean isEmpty() {
        return this.linksById.isEmpty() && this.linksByName.isEmpty();
    }

    public Map<Uuid, ClusterLink> linksById() {
        return this.linksById;
    }

    public Map<String, ClusterLink> linksByName() {
        return this.linksByName;
    }

    public Optional<ClusterLink> clusterLink(String linkName) {
        return Optional.ofNullable(this.linksByName.get(linkName));
    }

    public Optional<ClusterLink> clusterLink(Uuid linkId) {
        return Optional.ofNullable(this.linksById.get(linkId));
    }

    public Optional<Uuid> clusterLinkId(String linkName) {
        return Optional.ofNullable(this.linksByName.get(linkName)).map(ClusterLink::linkId);
    }

    public Set<String> linksForTenant(String tenant) {
        return this.linkNamesByTenant.getOrDefault(tenant, Set.of());
    }

    public Map<String, Set<String>> linkNamesByTenant() {
        return this.linkNamesByTenant;
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        for (ClusterLink link : this.linksById.values()) {
            String mode;
            ClusterLinkRecord record = new ClusterLinkRecord().setClusterLinkName(link.linkName()).setClusterLinkId(link.linkId()).setTenantPrefix(link.tenantPrefix().orElse(null)).setRemoteClusterId(link.remoteClusterId());
            if (link.switchoverMetadata().isPresent()) {
                record.setSwitchoverMetadata(link.switchoverMetadata().get().toRecord());
            }
            if (!(mode = link.linkMode().toString()).equals(record.linkMode())) {
                record.setLinkMode(mode);
            }
            writer.write(1, record);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterLinksImage)) {
            return false;
        }
        ClusterLinksImage other = (ClusterLinksImage)o;
        return this.linksById.equals(other.linksById) && this.linksByName.equals(other.linksByName) && this.linkNamesByTenant.equals(other.linkNamesByTenant);
    }

    public int hashCode() {
        return Objects.hash(this.linksById, this.linksByName, this.linkNamesByTenant);
    }

    public String toString() {
        return new ClusterLinksImageNode(this).stringify();
    }
}

