/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.image.node.TopicImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.TopicType;

public final class TopicImage {
    private final String name;
    private final Uuid id;
    private final byte topicType;
    private final Map<Integer, PartitionRegistration> partitions;
    private final MirrorTopic mirrorTopic;

    public TopicImage(String name, Uuid id, Map<Integer, PartitionRegistration> partitions, MirrorTopic mirrorTopic) {
        this(name, id, TopicType.STANDARD.id(), partitions, mirrorTopic);
    }

    public TopicImage(String name, Uuid id, byte topicType, Map<Integer, PartitionRegistration> partitions, MirrorTopic mirrorTopic) {
        this.name = name;
        this.id = id;
        this.topicType = topicType;
        this.partitions = partitions;
        this.mirrorTopic = mirrorTopic;
    }

    public String name() {
        return this.name;
    }

    public Uuid id() {
        return this.id;
    }

    public byte topicType() {
        return this.topicType;
    }

    public Map<Integer, PartitionRegistration> partitions() {
        return this.partitions;
    }

    public Optional<MirrorTopic> mirrorTopic() {
        return Optional.ofNullable(this.mirrorTopic);
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        writer.write(0, new TopicRecord().setName(this.name).setTopicId(this.id).setTopicType(this.topicType));
        if (this.mirrorTopic != null) {
            short recordVersion = (short)(options.metadataVersion().isClusterLinkingFailbackSupported() ? 1 : 0);
            writer.write(recordVersion, MirrorTopic.toSnapshotRecord(this.mirrorTopic, this.name));
        }
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitions.entrySet()) {
            int partitionId = entry.getKey();
            PartitionRegistration partition = entry.getValue();
            writer.write(partition.toRecord(this.id, partitionId, options));
        }
    }

    public boolean equals(Object o) {
        boolean otherMirrorTopicStateNull;
        if (!(o instanceof TopicImage)) {
            return false;
        }
        TopicImage other = (TopicImage)o;
        boolean mirrorTopicStateNull = this.mirrorTopic == null;
        boolean bl = otherMirrorTopicStateNull = other.mirrorTopic == null;
        boolean mirrorTopicStateEquals = mirrorTopicStateNull && otherMirrorTopicStateNull ? true : (mirrorTopicStateNull ^ otherMirrorTopicStateNull ? false : this.mirrorTopic.equals(other.mirrorTopic));
        return this.name.equals(other.name) && this.id.equals((Object)other.id) && this.topicType == other.topicType && this.partitions.equals(other.partitions) && mirrorTopicStateEquals;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.topicType, this.partitions, this.mirrorTopic);
    }

    public String toString() {
        return new TopicImageNode(this).stringify();
    }
}

