/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.metadata.authorizer.AclsBuilder;
import org.apache.kafka.metadata.authorizer.PrefixNode;
import org.apache.kafka.metadata.authorizer.ResourceAcls;
import org.apache.kafka.metadata.authorizer.ResourceAclsBuilder;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.server.immutable.ImmutableNavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PrefixTreeBuilder
implements AclsBuilder<PrefixNode> {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixTreeBuilder.class);
    private final TreeMap<String, ResourceAclsBuilder> changes = new TreeMap();

    PrefixTreeBuilder() {
    }

    @Override
    public void newAddition(StandardAcl acl) {
        this.changes.computeIfAbsent(acl.resourceNameForPrefixNode(), __ -> new ResourceAclsBuilder()).newAddition(acl);
    }

    @Override
    public void newRemoval(StandardAcl acl) {
        this.changes.computeIfAbsent(acl.resourceNameForPrefixNode(), __ -> new ResourceAclsBuilder()).newRemoval(acl);
    }

    public PrefixNode build(PrefixNode oldRoot) {
        PrefixNode newRoot = oldRoot;
        for (Map.Entry<String, ResourceAclsBuilder> changeEntry : this.changes.entrySet()) {
            newRoot = this.buildNode(newRoot, changeEntry);
        }
        return newRoot;
    }

    PrefixNode buildNode(PrefixNode oldNode, Map.Entry<String, ResourceAclsBuilder> changeEntry) {
        ImmutableNavigableMap<String, PrefixNode> newChildren;
        ResourceAcls newResourceAcls;
        ResourceAclsBuilder nodeChanges = changeEntry.getValue();
        if (changeEntry.getKey().equals(oldNode.name())) {
            LOG.trace("Updating PrefixNode={} with changes={}", (Object)oldNode.name(), (Object)nodeChanges);
            newResourceAcls = oldNode.resourceAcls().copyWithChanges(nodeChanges);
            newChildren = oldNode.children();
        } else {
            newResourceAcls = oldNode.resourceAcls();
            newChildren = this.buildNewChildren(oldNode, changeEntry);
        }
        if (!oldNode.isRoot() && newResourceAcls.isEmpty() && newChildren.size() == 1) {
            PrefixNode child = (PrefixNode)newChildren.values().iterator().next();
            LOG.trace("Replacing empty node={} with the only child={}", (Object)oldNode.name(), (Object)child);
            return child;
        }
        return new PrefixNode(newChildren, oldNode.name(), newResourceAcls);
    }

    ImmutableNavigableMap<String, PrefixNode> buildNewChildren(PrefixNode parent, Map.Entry<String, ResourceAclsBuilder> changeEntry) {
        ImmutableNavigableMap newChildren = parent.children();
        String newResourceName = changeEntry.getKey();
        String floorKey = (String)newChildren.floorKey((Object)newResourceName);
        String ceilingKey = (String)newChildren.ceilingKey((Object)newResourceName);
        ChildrenUpdate childrenUpdate = ChildrenUpdate.create(parent, newResourceName, floorKey, ceilingKey);
        if (LOG.isTraceEnabled()) {
            LOG.trace("For parent node=(name={}, children={}) and childEntry={}, childrenUpdate={}", new Object[]{parent.name(), parent.children().keySet(), changeEntry, childrenUpdate});
        }
        switch (childrenUpdate.ordinal()) {
            case 0: {
                PrefixNode updatedChild = this.buildNode((PrefixNode)newChildren.get((Object)floorKey), changeEntry);
                if (!updatedChild.isEmpty()) {
                    if (updatedChild.name().equals(floorKey)) {
                        newChildren = newChildren.updated((Object)floorKey, (Object)updatedChild);
                        break;
                    }
                    newChildren = newChildren.removed((Object)floorKey).updated((Object)updatedChild.name(), (Object)updatedChild);
                    break;
                }
                newChildren = newChildren.removed((Object)floorKey);
                break;
            }
            case 1: {
                int keyMatchesUpto;
                String existingChildKey;
                int floorMatchesUpto = PrefixTreeBuilder.matchesUpTo(newResourceName, floorKey);
                int ceilingMatchesUpto = PrefixTreeBuilder.matchesUpTo(newResourceName, ceilingKey);
                if (floorMatchesUpto > 0 && floorMatchesUpto >= ceilingMatchesUpto) {
                    existingChildKey = floorKey;
                    keyMatchesUpto = floorMatchesUpto;
                } else {
                    existingChildKey = ceilingKey;
                    keyMatchesUpto = ceilingMatchesUpto;
                }
                String newChildResourceName = newResourceName.substring(0, keyMatchesUpto);
                PrefixNode grandChild1 = this.buildNode(new PrefixNode(newResourceName, ResourceAcls.EMPTY, new PrefixNode[0]), changeEntry);
                ImmutableNavigableMap grandChildren = ImmutableNavigableMap.singleton((Comparable)((Object)newResourceName), (Object)grandChild1);
                PrefixNode grandChild2 = (PrefixNode)newChildren.get((Object)existingChildKey);
                grandChildren = grandChildren.updated((Object)existingChildKey, (Object)grandChild2);
                PrefixNode newChild = new PrefixNode((ImmutableNavigableMap<String, PrefixNode>)grandChildren, newChildResourceName, ResourceAcls.EMPTY);
                newChildren = newChildren.removed((Object)existingChildKey).updated((Object)newChildResourceName, (Object)newChild);
                break;
            }
            case 2: {
                ImmutableNavigableMap grandChildren = ImmutableNavigableMap.singleton((Comparable)((Object)ceilingKey), (Object)((PrefixNode)newChildren.get((Object)ceilingKey)));
                PrefixNode newChild = this.buildNode(new PrefixNode((ImmutableNavigableMap<String, PrefixNode>)grandChildren, newResourceName, ResourceAcls.EMPTY), changeEntry);
                newChildren = newChildren.removed((Object)ceilingKey).updated((Object)newResourceName, (Object)newChild);
                break;
            }
            case 3: {
                PrefixNode newChild = this.buildNode(new PrefixNode(newResourceName, ResourceAcls.EMPTY, new PrefixNode[0]), changeEntry);
                newChildren = newChildren.updated((Object)newResourceName, (Object)newChild);
                break;
            }
        }
        return newChildren;
    }

    static int matchesUpTo(String resource, String pattern) {
        int i;
        if (resource == null || pattern == null) {
            return 0;
        }
        for (i = 0; resource.length() != i && pattern.length() != i && resource.charAt(i) == pattern.charAt(i); ++i) {
        }
        return i;
    }

    static enum ChildrenUpdate {
        CHANGE_AFFECTS_CHILD_OR_GRANDCHILD,
        CREATE_A_COMMON_PARENT,
        INSERT_BEFORE_A_CHILD,
        ADD_AS_CHILD;


        static ChildrenUpdate create(PrefixNode parent, String changeResourceName, String floorKey, String ceilingKey) {
            String parentResourceName = parent.name();
            if (!changeResourceName.startsWith(parentResourceName)) {
                throw new RuntimeException("Changed resource name should start with parent resource name");
            }
            int floorMatchesUpto = PrefixTreeBuilder.matchesUpTo(changeResourceName, floorKey);
            int ceilingMatchesUpto = PrefixTreeBuilder.matchesUpTo(changeResourceName, ceilingKey);
            if (floorMatchesUpto > 0 && floorMatchesUpto >= ceilingMatchesUpto) {
                if (floorMatchesUpto == floorKey.length()) {
                    return CHANGE_AFFECTS_CHILD_OR_GRANDCHILD;
                }
                if (parentResourceName.equals(floorKey.substring(0, floorMatchesUpto))) {
                    return ADD_AS_CHILD;
                }
                return CREATE_A_COMMON_PARENT;
            }
            if (ceilingMatchesUpto > 0) {
                if (ceilingMatchesUpto == changeResourceName.length()) {
                    return INSERT_BEFORE_A_CHILD;
                }
                if (parentResourceName.equals(ceilingKey.substring(0, ceilingMatchesUpto))) {
                    return ADD_AS_CHILD;
                }
                return CREATE_A_COMMON_PARENT;
            }
            return ADD_AS_CHILD;
        }
    }
}

