/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.ingester;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.metadata.InternalTopicType;
import org.apache.kafka.metadata.ingester.IngesterRecord;
import org.apache.kafka.metadata.ingester.IngestionHandler;
import org.apache.kafka.metadata.ingester.IngestionWorker;
import org.apache.kafka.metadata.ingester.IngestionWorkerFactory;
import org.apache.kafka.metadata.ingester.IngestionWorkerManager;
import org.apache.kafka.metadata.ingester.IngestionWorkerMetrics;
import org.slf4j.Logger;

public final class Ingester
implements AutoCloseable {
    private final LogContext logContext;
    private final Logger log;
    private final IngestionWorkerFactory workerFactory;
    private final IngestionHandler handler;
    private final int maxOutstandingRecords;
    private final Map<Long, IngestionWorker> unclosedWorkers;
    private final Map<Long, IngestionWorkerMetrics> unclosedWorkerMetric;
    private boolean closed;
    private volatile WorkerManager workerManager;
    private Metrics metrics;
    private InternalTopicType type;

    static String offsetsToString(Map<TopicPartition, Optional<Long>> offsets) {
        TreeMap<TopicPartition, Optional<Long>> sortedOffsets = new TreeMap<TopicPartition, Optional<Long>>((a, b) -> {
            int result = a.topic().compareTo(b.topic());
            if (result != 0) {
                return result;
            }
            return Integer.compare(a.partition(), b.partition());
        });
        sortedOffsets.putAll(offsets);
        StringBuilder bld = new StringBuilder("[");
        String prefix = "";
        for (Map.Entry entry : sortedOffsets.entrySet()) {
            bld.append(prefix);
            prefix = ", ";
            bld.append(entry.getKey()).append(": ").append(entry.getValue());
        }
        bld.append("]");
        return bld.toString();
    }

    static Collection<String> findUniqueTopicNames(Collection<TopicPartition> partitions) {
        HashSet<String> topicNames = new HashSet<String>();
        partitions.forEach(partition -> topicNames.add(partition.topic()));
        return topicNames;
    }

    private boolean isCurrentWorker(WorkerManager state) {
        return this.workerManager == state;
    }

    private synchronized void handleWorkerShutdownComplete(WorkerManager state) {
        this.unclosedWorkers.remove(state.epoch, state);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ingester(LogContext logContext, IngestionWorkerFactory workerFactory, IngestionHandler handler, int maxOutstandingRecords, Metrics metrics, InternalTopicType type) {
        this.logContext = logContext;
        this.log = logContext.logger(Ingester.class);
        this.workerFactory = workerFactory;
        this.handler = handler;
        this.maxOutstandingRecords = maxOutstandingRecords;
        this.metrics = metrics;
        this.type = type;
        Ingester ingester = this;
        synchronized (ingester) {
            this.log.info("starting ingester");
            this.unclosedWorkers = new HashMap<Long, IngestionWorker>();
            this.unclosedWorkerMetric = new HashMap<Long, IngestionWorkerMetrics>();
            this.closed = false;
            this.workerManager = null;
        }
    }

    @Override
    public synchronized void close() throws InterruptedException {
        this.log.info("shutting down ingester. state: " + this.closed);
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.maybeBeginWorkerShutdown("we are closing the ingester");
        while (!this.unclosedWorkers.isEmpty()) {
            this.wait(500L);
        }
    }

    public synchronized void start(long epoch, Map<TopicPartition, Optional<Long>> offsets) {
        this.log.info("try to start ingester, epoch: " + epoch + " offsets:" + String.valueOf(offsets));
        if (this.closed) {
            throw new RuntimeException("Cannot start a new ingestion epoch, because the ingester is closed.");
        }
        if (this.workerManager != null && this.workerManager.epoch == epoch) {
            throw new RuntimeException("Cannot start a new epoch " + epoch + " because that is the same as the current epoch.");
        }
        this.maybeBeginWorkerShutdown("we are starting epoch " + epoch);
        WorkerManager newWorkerManager = new WorkerManager(epoch);
        IngestionWorker worker = this.workerFactory.create(newWorkerManager, offsets);
        IngestionWorkerMetrics workerMetrics = new IngestionWorkerMetrics(this.metrics, this.type, worker);
        this.unclosedWorkers.put(epoch, worker);
        this.unclosedWorkerMetric.put(epoch, workerMetrics);
        this.workerManager = newWorkerManager;
        this.log.info("start ingestion worker at epoch {} with offsets {}", (Object)epoch, (Object)Ingester.offsetsToString(offsets));
    }

    private synchronized void maybeBeginWorkerShutdown(String reason) {
        if (this.workerManager != null) {
            IngestionWorker worker = this.unclosedWorkers.get(this.workerManager.epoch);
            IngestionWorkerMetrics workerMetric = this.unclosedWorkerMetric.get(this.workerManager.epoch);
            if (worker != null) {
                this.log.info("Stopping ingestion worker at epoch {} because {}.", (Object)this.workerManager.epoch, (Object)reason);
                worker.beginShutdown();
            } else {
                this.log.info("Found no ingestion worker to stop at epoch {} because {}.", (Object)this.workerManager.epoch, (Object)reason);
            }
            if (workerMetric != null) {
                workerMetric.close();
            }
            this.workerManager = null;
        } else {
            this.log.debug("No need to stop because {}. There is no current ingestion worker.", (Object)reason);
        }
    }

    class WorkerManager
    implements IngestionWorkerManager {
        final long epoch;
        final AtomicInteger outstandingRecords;

        WorkerManager(long epoch) {
            this.epoch = epoch;
            this.outstandingRecords = new AtomicInteger(0);
        }

        @Override
        public LogContext logContext() {
            return Ingester.this.logContext;
        }

        @Override
        public long epoch() {
            return this.epoch;
        }

        @Override
        public boolean handleRecords(List<IngesterRecord> records) {
            if (!this.isCurrentWorker()) {
                Ingester.this.log.debug("Ignoring {} records from previous epoch {}.", (Object)records.size(), (Object)this.epoch);
                return false;
            }
            CompletableFuture<Void> future = Ingester.this.handler.handle(this.epoch, records);
            future.whenComplete((BiConsumer)new IngestionCompletionHandler(this, records.size()));
            return this.outstandingRecords.get() < Ingester.this.maxOutstandingRecords;
        }

        @Override
        public void handleWorkerShutdownComplete(Throwable e) {
            Ingester.this.handleWorkerShutdownComplete(this);
        }

        private boolean isCurrentWorker() {
            return Ingester.this.isCurrentWorker(this);
        }
    }

    static class IngestionCompletionHandler
    implements BiConsumer<Void, Throwable> {
        private final WorkerManager workerManager;
        private final int numRecords;

        IngestionCompletionHandler(WorkerManager workerManager, int numRecords) {
            this.workerManager = workerManager;
            this.numRecords = numRecords;
            workerManager.outstandingRecords.getAndAdd(numRecords);
        }

        @Override
        public void accept(Void v, Throwable t) {
            this.workerManager.outstandingRecords.getAndAdd(-this.numRecords);
        }
    }

    public static class Builder {
        private LogContext logContext = null;
        private IngestionWorkerFactory workerFactory = null;
        private IngestionHandler handler = null;
        private int maxOutstandingRecords = 1000;
        private Metrics metrics = null;
        private InternalTopicType type = null;

        public Builder setMetrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder setInternalTopicType(InternalTopicType type) {
            this.type = type;
            return this;
        }

        public Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        public Builder setWorkerFactory(IngestionWorkerFactory workerFactory) {
            this.workerFactory = workerFactory;
            return this;
        }

        public Builder setHandler(IngestionHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder setMaxOutstandingRecords(int maxOutstandingRecords) {
            this.maxOutstandingRecords = maxOutstandingRecords;
            return this;
        }

        public Ingester build() {
            if (this.logContext == null) {
                this.logContext = new LogContext("[Ingester] ");
            }
            if (this.workerFactory == null) {
                throw new RuntimeException("You must set the IngestionWorkerFactory.");
            }
            if (this.handler == null) {
                throw new RuntimeException("You must set the IngestionHandler.");
            }
            if (this.metrics == null) {
                throw new RuntimeException("You must set the metrics.");
            }
            if (this.type == null) {
                throw new RuntimeException("You must set the internal topic type.");
            }
            return new Ingester(this.logContext, this.workerFactory, this.handler, this.maxOutstandingRecords, this.metrics, this.type);
        }
    }
}

