/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.TopicPlacement;

@InterfaceStability.Unstable
public class PlacementSpec {
    private final int startPartition;
    private final int numPartitions;
    private final short numReplicas;
    private final String topicName;
    private final KafkaPrincipal principal;
    private final Set<Integer> excludedBrokerIds;
    private final PartitionPlacementStrategy partitionPlacementStrategy;
    Optional<TopicPlacement> topicPlacement;

    public PlacementSpec(int startPartition, int numPartitions, short numReplicas, String topicName, KafkaPrincipal principal, Set<Integer> excludedBrokerIds, PartitionPlacementStrategy partitionPlacementStrategy, Optional<TopicPlacement> topicPlacement) {
        this.startPartition = startPartition;
        this.numPartitions = numPartitions;
        this.numReplicas = numReplicas;
        this.topicName = topicName;
        this.principal = principal;
        this.excludedBrokerIds = excludedBrokerIds;
        this.partitionPlacementStrategy = partitionPlacementStrategy;
        this.topicPlacement = topicPlacement;
    }

    public int startPartition() {
        return this.startPartition;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public short numReplicas() {
        return this.numReplicas;
    }

    public String topicName() {
        return this.topicName;
    }

    public KafkaPrincipal principal() {
        return this.principal;
    }

    public Set<Integer> excludedBrokerIds() {
        return this.excludedBrokerIds;
    }

    public PartitionPlacementStrategy partitionPlacementStrategy() {
        return this.partitionPlacementStrategy;
    }

    public Optional<TopicPlacement> topicPlacement() {
        return this.topicPlacement;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(PlacementSpec.class)) {
            return false;
        }
        PlacementSpec other = (PlacementSpec)o;
        return this.startPartition == other.startPartition && this.numPartitions == other.numPartitions && this.numReplicas == other.numReplicas && this.topicName.equals(other.topicName) && this.principal.equals((Object)other.principal) && this.excludedBrokerIds.equals(other.excludedBrokerIds) && this.partitionPlacementStrategy.equals((Object)other.partitionPlacementStrategy()) && this.topicPlacement.equals(other.topicPlacement);
    }

    public int hashCode() {
        return Objects.hash(this.startPartition, this.numPartitions, this.numReplicas, this.topicName, this.principal, this.excludedBrokerIds, this.partitionPlacementStrategy, this.topicPlacement);
    }

    public String toString() {
        return "PlacementSpec(startPartition=" + this.startPartition + ", numPartitions=" + this.numPartitions + ", numReplicas=" + this.numReplicas + ", topicName=" + this.topicName + ", principal=" + String.valueOf(this.principal) + ", excludedBrokerIds=" + String.valueOf(this.excludedBrokerIds) + ", partitionPlacementStrategy=" + this.partitionPlacementStrategy.name() + ", topicPlacement=" + String.valueOf(this.topicPlacement) + ")";
    }
}

