/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.BeginShutdownControllerHandle;
import io.confluent.rest.BeginShutdownControllerStatus;
import io.confluent.rest.ControllerInternalRestServer;
import io.confluent.rest.ResponseContainer;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerRollHandler
extends Handler.Abstract {
    private static final Logger log = LoggerFactory.getLogger(ControllerInternalRestServer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final BeginShutdownControllerHandle beginShutdownControllerHandle;

    public ControllerRollHandler(BeginShutdownControllerHandle beginShutdownControllerHandle) {
        this.beginShutdownControllerHandle = beginShutdownControllerHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        AtomicReference<Callback> callbackReference = new AtomicReference<Callback>(callback);
        try {
            String target = request.getHttpURI().getPath();
            if (target.endsWith("/status")) {
                log.debug("Handling roll status query");
                this.handleRollableQuery(response, callbackReference);
            }
        }
        finally {
            Optional.ofNullable(callbackReference.getAndSet(null)).ifPresent(Callback::succeeded);
        }
        return true;
    }

    private void handleRollableQuery(Response response, AtomicReference<Callback> callback) throws IOException {
        try {
            BeginShutdownControllerStatus status = this.beginShutdownControllerHandle.generateRollableStatus();
            ResponseContainer.dataResponse(status).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            String failureMessage = "Failed to retrieve and write controller rollable information";
            log.error(failureMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = ControllerRollHandler.genericErrorResponse(failureMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
            Optional.ofNullable(callback.getAndSet(null)).ifPresent(c -> c.failed((Throwable)e));
        }
    }

    private static ResponseContainer.ErrorResponse genericErrorResponse(String message) {
        return new ResponseContainer.ErrorResponse(0, 500, message);
    }
}

