/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.connect.json.JsonSchemaDataConfig;
import io.confluent.connect.schema.ConnectUnion;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.json.DecimalFormat;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonSchemaData {
    public static final String NAMESPACE = "io.confluent.connect.json";
    public static final String KEY_FIELD = "key";
    public static final String VALUE_FIELD = "value";
    public static final String CONNECT_TYPE_PROP = "connect.type";
    public static final String CONNECT_VERSION_PROP = "connect.version";
    public static final String CONNECT_PARAMETERS_PROP = "connect.parameters";
    public static final String CONNECT_INDEX_PROP = "connect.index";
    public static final String CONNECT_TYPE_INT8 = "int8";
    public static final String CONNECT_TYPE_INT16 = "int16";
    public static final String CONNECT_TYPE_INT32 = "int32";
    public static final String CONNECT_TYPE_INT64 = "int64";
    public static final String CONNECT_TYPE_FLOAT32 = "float32";
    public static final String CONNECT_TYPE_FLOAT64 = "float64";
    public static final String CONNECT_TYPE_BYTES = "bytes";
    public static final String CONNECT_TYPE_MAP = "map";
    public static final String DEFAULT_ID_PREFIX = "#id";
    public static final String JSON_ID_PROP = "io.confluent.connect.json.Id";
    public static final String JSON_TYPE_ENUM = "io.confluent.connect.json.Enum";
    public static final String JSON_TYPE_ONE_OF = "io.confluent.connect.json.OneOf";
    public static final String GENERALIZED_TYPE_UNION = "org.apache.kafka.connect.data.Union";
    public static final String GENERALIZED_TYPE_ENUM = "org.apache.kafka.connect.data.Enum";
    public static final String GENERALIZED_TYPE_UNION_PREFIX = "connect_union_";
    public static final String GENERALIZED_TYPE_UNION_FIELD_PREFIX = "connect_union_field_";
    public static final String NULL_MARKER = "<NULL>";
    private static final JsonNodeFactory JSON_NODE_FACTORY = JsonNodeFactory.withExactBigDecimals((boolean)true);
    private static final ObjectMapper OBJECT_MAPPER = Jackson.newObjectMapper();
    private static final Map<Schema.Type, JsonToConnectTypeConverter> TO_CONNECT_CONVERTERS = new EnumMap<Schema.Type, JsonToConnectTypeConverter>(Schema.Type.class);
    private static final HashMap<String, JsonToConnectLogicalTypeConverter> TO_CONNECT_LOGICAL_CONVERTERS;
    private static final HashMap<String, ConnectToJsonLogicalTypeConverter> TO_JSON_LOGICAL_CONVERTERS;
    private final JsonSchemaDataConfig config;
    private final Map<org.apache.kafka.connect.data.Schema, JsonSchema> fromConnectSchemaCache;
    private final Map<JsonSchema, org.apache.kafka.connect.data.Schema> toConnectSchemaCache;
    private final boolean generalizedSumTypeSupport;
    private final boolean flattenSingletonUnions;
    private static final Object NONE_MARKER;

    private static boolean isInstanceOfSchemaTypeForSimpleSchema(org.apache.kafka.connect.data.Schema fieldSchema, JsonNode value) {
        switch (fieldSchema.type()) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: {
                return value.isIntegralNumber();
            }
            case FLOAT32: 
            case FLOAT64: {
                return value.isNumber();
            }
            case BOOLEAN: {
                return value.isBoolean();
            }
            case STRING: {
                return value.isTextual();
            }
            case BYTES: {
                return value.isBinary() || value.isBigDecimal();
            }
            case ARRAY: {
                return value.isArray();
            }
            case MAP: {
                return value.isObject() || value.isArray();
            }
            case STRUCT: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(fieldSchema.type()));
    }

    private static int matchStructSchema(org.apache.kafka.connect.data.Schema fieldSchema, JsonNode value) {
        if (fieldSchema.type() != Schema.Type.STRUCT || !value.isObject()) {
            return 0;
        }
        Set schemaFields = fieldSchema.fields().stream().map(Field::name).collect(Collectors.toSet());
        HashSet<String> objectFields = new HashSet<String>();
        Iterator iter = value.fields();
        while (iter.hasNext()) {
            objectFields.add((String)((Map.Entry)iter.next()).getKey());
        }
        HashSet intersectSet = new HashSet(schemaFields);
        intersectSet.retainAll(objectFields);
        int childrenMatchFactor = 0;
        for (String intersectedElement : intersectSet) {
            org.apache.kafka.connect.data.Schema childSchema = fieldSchema.field(intersectedElement).schema();
            JsonNode childValue = value.get(intersectedElement);
            childrenMatchFactor += JsonSchemaData.matchStructSchema(childSchema, childValue);
        }
        return intersectSet.size() + childrenMatchFactor;
    }

    public JsonSchemaData() {
        this(new JsonSchemaDataConfig.Builder().with("schemas.cache.config", 1000).build());
    }

    public JsonSchemaData(JsonSchemaDataConfig jsonSchemaDataConfig) {
        this.config = jsonSchemaDataConfig;
        this.fromConnectSchemaCache = new BoundedConcurrentHashMap(jsonSchemaDataConfig.schemaCacheSize());
        this.toConnectSchemaCache = new BoundedConcurrentHashMap(jsonSchemaDataConfig.schemaCacheSize());
        this.generalizedSumTypeSupport = jsonSchemaDataConfig.isGeneralizedSumTypeSupport();
        this.flattenSingletonUnions = jsonSchemaDataConfig.isFlattenSingletonUnions();
    }

    /*
     * Unable to fully structure code
     */
    public JsonNode fromConnectData(org.apache.kafka.connect.data.Schema schema, Object logicalValue) {
        if (logicalValue == null) {
            if (schema == null) {
                return null;
            }
            if (schema.defaultValue() != null && !this.config.ignoreDefaultForNullables()) {
                return this.fromConnectData(schema, schema.defaultValue());
            }
            if (schema.isOptional()) {
                return JsonSchemaData.JSON_NODE_FACTORY.nullNode();
            }
            return null;
        }
        value = logicalValue;
        if (schema != null && schema.name() != null && (logicalConverter = JsonSchemaData.TO_JSON_LOGICAL_CONVERTERS.get(schema.name())) != null) {
            return logicalConverter.convert(schema, logicalValue, this.config);
        }
        try {
            if (schema == null) {
                schemaType = ConnectSchema.schemaType(value.getClass());
                if (schemaType == null) {
                    throw new DataException("Java class " + String.valueOf(value.getClass()) + " does not have corresponding schema type.");
                }
            } else {
                schemaType = schema.type();
            }
            switch (1.$SwitchMap$org$apache$kafka$connect$data$Schema$Type[schemaType.ordinal()]) {
                case 1: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode(((Byte)value).shortValue());
                }
                case 2: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode((Short)value);
                }
                case 3: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode((Integer)value);
                }
                case 4: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode((Long)value);
                }
                case 5: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode((Float)value);
                }
                case 6: {
                    return JsonSchemaData.JSON_NODE_FACTORY.numberNode((Double)value);
                }
                case 7: {
                    return JsonSchemaData.JSON_NODE_FACTORY.booleanNode(((Boolean)value).booleanValue());
                }
                case 8: {
                    charSeq = (CharSequence)value;
                    return JsonSchemaData.JSON_NODE_FACTORY.textNode(charSeq.toString());
                }
                case 9: {
                    if (value instanceof byte[]) {
                        return JsonSchemaData.JSON_NODE_FACTORY.binaryNode((byte[])value);
                    }
                    if (value instanceof ByteBuffer) {
                        return JsonSchemaData.JSON_NODE_FACTORY.binaryNode(((ByteBuffer)value).array());
                    }
                    if (value instanceof BigDecimal) {
                        return JsonSchemaData.JSON_NODE_FACTORY.numberNode((BigDecimal)value);
                    }
                    throw new DataException("Invalid type for bytes type: " + String.valueOf(value.getClass()));
                }
                case 10: {
                    collection = (Collection)value;
                    list = JsonSchemaData.JSON_NODE_FACTORY.arrayNode();
                    for (E elem : collection) {
                        valueSchema = schema == null ? null : schema.valueSchema();
                        fieldValue = this.fromConnectData(valueSchema, elem);
                        list.add(fieldValue);
                    }
                    return list;
                }
                case 11: {
                    map = (Map)value;
                    if (schema != null) ** GOTO lbl64
                    objectMode = true;
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        if (entry.getKey() instanceof String) continue;
                        objectMode = false;
                        ** GOTO lbl65
                    }
                    ** GOTO lbl65
lbl64:
                    // 1 sources

                    objectMode = schema.keySchema().type() == Schema.Type.STRING && schema.keySchema().isOptional() == false;
lbl65:
                    // 3 sources

                    obj = null;
                    list = null;
                    if (objectMode) {
                        obj = JsonSchemaData.JSON_NODE_FACTORY.objectNode();
                    } else {
                        list = JsonSchemaData.JSON_NODE_FACTORY.arrayNode();
                    }
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        keySchema = schema == null ? null : schema.keySchema();
                        valueSchema = schema == null ? null : schema.valueSchema();
                        mapKey = this.fromConnectData(keySchema, entry.getKey());
                        mapValue = this.fromConnectData(valueSchema, entry.getValue());
                        if (objectMode) {
                            obj.set(mapKey.asText(), mapValue);
                            continue;
                        }
                        o = JsonSchemaData.JSON_NODE_FACTORY.objectNode();
                        o.set("key", mapKey);
                        o.set("value", mapValue);
                        list.add((JsonNode)o);
                    }
                    return objectMode != false ? obj : list;
                }
                case 12: {
                    struct = (Struct)value;
                    if (!struct.schema().equals(schema)) {
                        throw new DataException("Mismatching schema.");
                    }
                    if (JsonSchemaData.isUnionSchema(schema)) {
                        for (Field field : schema.fields()) {
                            object = this.config.ignoreDefaultForNullables() != false ? struct.getWithoutDefault(field.name()) : struct.get(field);
                            if (object == null) continue;
                            return this.fromConnectData(field.schema(), object);
                        }
                        return this.fromConnectData(schema, null);
                    }
                    obj = JsonSchemaData.JSON_NODE_FACTORY.objectNode();
                    for (Field field : schema.fields()) {
                        v0 = fieldValue = this.config.ignoreDefaultForNullables() != false ? struct.getWithoutDefault(field.name()) : struct.get(field);
                        jsonNode = this.fromConnectData(field.schema(), fieldValue);
                        if (jsonNode == null) continue;
                        obj.set(field.name(), jsonNode);
                    }
                    return obj;
                }
            }
            throw new DataException("Couldn't convert value to JSON.");
        }
        catch (ClassCastException e) {
            schemaTypeStr = schema != null ? schema.type().toString() : "unknown schema";
            throw new DataException("Invalid type for " + schemaTypeStr + ": " + String.valueOf(value.getClass()));
        }
    }

    public Object toConnectData(org.apache.kafka.connect.data.Schema schema, JsonNode jsonValue) {
        JsonToConnectLogicalTypeConverter logicalConverter;
        JsonToConnectTypeConverter typeConverter;
        Schema.Type schemaType;
        if (schema != null) {
            schemaType = schema.type();
            if (jsonValue == null || jsonValue.isNull()) {
                if (schema.defaultValue() != null) {
                    return schema.defaultValue();
                }
                if (jsonValue == null || schema.isOptional()) {
                    return null;
                }
                throw new DataException("Invalid null value for required " + String.valueOf(schemaType) + " field");
            }
        } else {
            if (jsonValue == null) {
                return null;
            }
            switch (jsonValue.getNodeType()) {
                case NULL: {
                    return null;
                }
                case BOOLEAN: {
                    schemaType = Schema.Type.BOOLEAN;
                    break;
                }
                case NUMBER: {
                    if (jsonValue.isIntegralNumber()) {
                        schemaType = Schema.Type.INT64;
                        break;
                    }
                    schemaType = Schema.Type.FLOAT64;
                    break;
                }
                case ARRAY: {
                    schemaType = Schema.Type.ARRAY;
                    break;
                }
                case OBJECT: {
                    schemaType = Schema.Type.MAP;
                    break;
                }
                case STRING: {
                    schemaType = Schema.Type.STRING;
                    break;
                }
                default: {
                    schemaType = null;
                }
            }
        }
        if ((typeConverter = TO_CONNECT_CONVERTERS.get(schemaType)) == null) {
            throw new DataException("Unknown schema type: " + String.valueOf(schemaType));
        }
        if (schema != null && schema.name() != null && (logicalConverter = TO_CONNECT_LOGICAL_CONVERTERS.get(schema.name())) != null) {
            return logicalConverter.convert(schema, jsonValue);
        }
        return typeConverter.convert(this, schema, jsonValue);
    }

    public JsonSchema fromConnectSchema(org.apache.kafka.connect.data.Schema schema) {
        if (schema == null) {
            return null;
        }
        JsonSchema cachedSchema = this.fromConnectSchemaCache.get(schema);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        FromConnectContext ctx = new FromConnectContext();
        JsonSchema resultSchema = new JsonSchema(this.rawSchemaFromConnectSchema(ctx, schema));
        this.fromConnectSchemaCache.put(schema, resultSchema);
        return resultSchema;
    }

    private Schema rawSchemaFromConnectSchema(FromConnectContext ctx, org.apache.kafka.connect.data.Schema schema) {
        return this.rawSchemaFromConnectSchema(ctx, schema, null);
    }

    private Schema rawSchemaFromConnectSchema(FromConnectContext ctx, org.apache.kafka.connect.data.Schema schema, Integer index) {
        return this.rawSchemaFromConnectSchema(ctx, schema, index, false);
    }

    private Schema rawSchemaFromConnectSchema(FromConnectContext ctx, org.apache.kafka.connect.data.Schema schema, Integer index, boolean ignoreOptional) {
        BooleanSchema.Builder builder;
        if (schema == null) {
            return null;
        }
        String id = null;
        if (schema.parameters() != null && schema.parameters().containsKey(JSON_ID_PROP)) {
            id = (String)schema.parameters().get(JSON_ID_PROP);
            ctx.add(id);
        }
        HashMap<String, Object> unprocessedProps = new HashMap<String, Object>();
        switch (schema.type()) {
            case INT8: {
                builder = NumberSchema.builder().requiresInteger(true);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_INT8);
                break;
            }
            case INT16: {
                builder = NumberSchema.builder().requiresInteger(true);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_INT16);
                break;
            }
            case INT32: {
                builder = NumberSchema.builder().requiresInteger(true);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_INT32);
                break;
            }
            case INT64: {
                builder = NumberSchema.builder().requiresInteger(true);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_INT64);
                break;
            }
            case FLOAT32: {
                builder = NumberSchema.builder().requiresInteger(false);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_FLOAT32);
                break;
            }
            case FLOAT64: {
                builder = NumberSchema.builder().requiresInteger(false);
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_FLOAT64);
                break;
            }
            case BOOLEAN: {
                builder = BooleanSchema.builder();
                break;
            }
            case STRING: {
                if (schema.parameters() != null && (schema.parameters().containsKey(GENERALIZED_TYPE_ENUM) || schema.parameters().containsKey(JSON_TYPE_ENUM))) {
                    EnumSchema.Builder enumBuilder = EnumSchema.builder();
                    String paramName = this.generalizedSumTypeSupport ? GENERALIZED_TYPE_ENUM : JSON_TYPE_ENUM;
                    for (Map.Entry entry : schema.parameters().entrySet()) {
                        if (!((String)entry.getKey()).startsWith(paramName + ".")) continue;
                        String enumSymbol = ((String)entry.getKey()).substring(paramName.length() + 1);
                        if (enumSymbol.equals(NULL_MARKER)) {
                            enumSymbol = null;
                        }
                        enumBuilder.possibleValue((Object)enumSymbol);
                    }
                    builder = enumBuilder;
                    break;
                }
                builder = StringSchema.builder();
                break;
            }
            case BYTES: {
                builder = "org.apache.kafka.connect.data.Decimal".equals(schema.name()) && this.config.decimalFormat() == DecimalFormat.NUMERIC ? NumberSchema.builder() : StringSchema.builder();
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_BYTES);
                break;
            }
            case ARRAY: {
                org.apache.kafka.connect.data.Schema arrayValueSchema = schema.valueSchema();
                String refId = null;
                if (arrayValueSchema.parameters() != null && arrayValueSchema.parameters().containsKey(JSON_ID_PROP)) {
                    refId = (String)arrayValueSchema.parameters().get(JSON_ID_PROP);
                }
                Object itemsSchema = ctx.contains(refId) ? ReferenceSchema.builder().refValue(refId).build() : this.rawSchemaFromConnectSchema(ctx, arrayValueSchema);
                builder = ArraySchema.builder().allItemSchema((Schema)itemsSchema);
                break;
            }
            case MAP: {
                if (schema.keySchema().type() == Schema.Type.STRING && !schema.keySchema().isOptional()) {
                    Schema valueSchema = this.rawSchemaFromConnectSchema(ctx, schema.valueSchema());
                    builder = ObjectSchema.builder().schemaOfAdditionalProperties(valueSchema);
                    unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_MAP);
                    break;
                }
                ObjectSchema.Builder entryBuilder = ObjectSchema.builder();
                Schema keySchema = this.rawSchemaFromConnectSchema(ctx, schema.keySchema(), 0);
                Schema valueSchema = this.rawSchemaFromConnectSchema(ctx, schema.valueSchema(), 1);
                entryBuilder.addPropertySchema(KEY_FIELD, keySchema);
                entryBuilder.addPropertySchema(VALUE_FIELD, valueSchema);
                builder = ArraySchema.builder().allItemSchema((Schema)entryBuilder.build());
                unprocessedProps.put(CONNECT_TYPE_PROP, CONNECT_TYPE_MAP);
                break;
            }
            case STRUCT: {
                if (JsonSchemaData.isUnionSchema(schema)) {
                    CombinedSchema.Builder combinedBuilder = CombinedSchema.builder();
                    combinedBuilder.criterion(CombinedSchema.ONE_CRITERION);
                    if (schema.isOptional()) {
                        combinedBuilder.subschema((Schema)NullSchema.INSTANCE);
                    }
                    for (Field field : schema.fields()) {
                        combinedBuilder.subschema(this.rawSchemaFromConnectSchema(ctx, JsonSchemaData.nonOptional(field.schema()), field.index(), true));
                    }
                    builder = combinedBuilder;
                    break;
                }
                if (schema.isOptional()) {
                    CombinedSchema.Builder combinedBuilder = CombinedSchema.builder();
                    combinedBuilder.criterion(CombinedSchema.ONE_CRITERION);
                    combinedBuilder.subschema((Schema)NullSchema.INSTANCE);
                    combinedBuilder.subschema(this.rawSchemaFromConnectSchema(ctx, JsonSchemaData.nonOptional(schema)));
                    builder = combinedBuilder;
                    break;
                }
                ObjectSchema.Builder objectBuilder = ObjectSchema.builder();
                for (Field field : schema.fields()) {
                    org.apache.kafka.connect.data.Schema fieldSchema = field.schema();
                    String fieldRefId = null;
                    if (fieldSchema.parameters() != null && fieldSchema.parameters().containsKey(JSON_ID_PROP)) {
                        fieldRefId = (String)fieldSchema.parameters().get(JSON_ID_PROP);
                    }
                    Object jsonSchema = ctx.contains(fieldRefId) ? ReferenceSchema.builder().refValue(fieldRefId).build() : this.rawSchemaFromConnectSchema(ctx, fieldSchema, field.index());
                    objectBuilder.addPropertySchema(field.name(), (Schema)jsonSchema);
                }
                if (!this.config.allowAdditionalProperties()) {
                    objectBuilder.additionalProperties(false);
                }
                builder = objectBuilder;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type " + String.valueOf(schema.type()));
            }
        }
        if (!(builder instanceof CombinedSchema.Builder)) {
            Map<String, String> parameters;
            if (schema.name() != null) {
                builder.title(schema.name());
            }
            if (schema.version() != null) {
                unprocessedProps.put(CONNECT_VERSION_PROP, schema.version());
            }
            if (schema.doc() != null) {
                builder.description(schema.doc());
            }
            if (schema.parameters() != null && (parameters = schema.parameters().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith(NAMESPACE)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).size() > 0) {
                unprocessedProps.put(CONNECT_PARAMETERS_PROP, parameters);
            }
            if (schema.defaultValue() != null) {
                builder.defaultValue(JsonSchemaData.toJsonSchemaValue(this.fromConnectData(schema, schema.defaultValue())));
            }
            if (!ignoreOptional && schema.isOptional()) {
                CombinedSchema.Builder combinedBuilder = CombinedSchema.builder();
                combinedBuilder.criterion(CombinedSchema.ONE_CRITERION);
                combinedBuilder.subschema((Schema)NullSchema.INSTANCE);
                combinedBuilder.subschema(builder.unprocessedProperties(unprocessedProps).build());
                if (index != null) {
                    combinedBuilder.unprocessedProperties(Collections.singletonMap(CONNECT_INDEX_PROP, index));
                }
                builder = combinedBuilder;
                unprocessedProps = new HashMap();
            }
        }
        if (id != null) {
            builder.id(id);
        }
        if (index != null) {
            unprocessedProps.put(CONNECT_INDEX_PROP, index);
        }
        return builder.unprocessedProperties(unprocessedProps).build();
    }

    private static Object toJsonSchemaValue(Object value) {
        try {
            Object primitiveValue = NONE_MARKER;
            if (value instanceof BinaryNode) {
                primitiveValue = ((BinaryNode)value).asText();
            } else if (value instanceof BooleanNode) {
                primitiveValue = ((BooleanNode)value).asBoolean();
            } else if (value instanceof NullNode) {
                primitiveValue = null;
            } else if (value instanceof NumericNode) {
                primitiveValue = ((NumericNode)value).numberValue();
            } else if (value instanceof TextNode) {
                primitiveValue = ((TextNode)value).asText();
            }
            if (primitiveValue != NONE_MARKER) {
                return primitiveValue;
            }
            Object jsonObject = value instanceof ArrayNode ? OBJECT_MAPPER.treeToValue((TreeNode)((ArrayNode)value), JSONArray.class) : (value instanceof JsonNode ? OBJECT_MAPPER.treeToValue((TreeNode)((JsonNode)value), JSONObject.class) : (value.getClass().isArray() ? OBJECT_MAPPER.convertValue(value, JSONArray.class) : OBJECT_MAPPER.convertValue(value, JSONObject.class)));
            return jsonObject;
        }
        catch (JsonProcessingException e) {
            throw new DataException("Invalid default value", (Throwable)e);
        }
    }

    private static org.apache.kafka.connect.data.Schema nonOptional(org.apache.kafka.connect.data.Schema schema) {
        return new ConnectSchema(schema.type(), false, schema.defaultValue(), schema.name(), schema.version(), schema.doc(), schema.parameters(), JsonSchemaData.fields(schema), JsonSchemaData.keySchema(schema), JsonSchemaData.valueSchema(schema));
    }

    private static List<Field> fields(org.apache.kafka.connect.data.Schema schema) {
        Schema.Type type = schema.type();
        if (Schema.Type.STRUCT.equals((Object)type)) {
            return schema.fields();
        }
        return null;
    }

    private static org.apache.kafka.connect.data.Schema keySchema(org.apache.kafka.connect.data.Schema schema) {
        Schema.Type type = schema.type();
        if (Schema.Type.MAP.equals((Object)type)) {
            return schema.keySchema();
        }
        return null;
    }

    private static org.apache.kafka.connect.data.Schema valueSchema(org.apache.kafka.connect.data.Schema schema) {
        Schema.Type type = schema.type();
        if (Schema.Type.MAP.equals((Object)type) || Schema.Type.ARRAY.equals((Object)type)) {
            return schema.valueSchema();
        }
        return null;
    }

    public org.apache.kafka.connect.data.Schema toConnectSchema(JsonSchema schema) {
        org.apache.kafka.connect.data.Schema cachedSchema;
        if (schema == null) {
            return null;
        }
        if (this.config.ignoreModernDialects()) {
            schema = schema.copyIgnoringModernDialects();
        }
        if ((cachedSchema = this.toConnectSchemaCache.get(schema)) != null) {
            return cachedSchema;
        }
        ToConnectContext ctx = new ToConnectContext();
        org.apache.kafka.connect.data.Schema resultSchema = this.toConnectSchema(ctx, schema.rawSchema(), schema.version(), false);
        this.toConnectSchemaCache.put(schema, resultSchema);
        return resultSchema;
    }

    @VisibleForTesting
    protected org.apache.kafka.connect.data.Schema toConnectSchema(Schema jsonSchema) {
        ToConnectContext ctx = new ToConnectContext();
        return this.toConnectSchema(ctx, jsonSchema, null);
    }

    private org.apache.kafka.connect.data.Schema toConnectSchema(ToConnectContext ctx, Schema jsonSchema) {
        return this.toConnectSchema(ctx, jsonSchema, null);
    }

    private org.apache.kafka.connect.data.Schema toConnectSchema(ToConnectContext ctx, Schema jsonSchema, Integer version) {
        return this.toConnectSchema(ctx, jsonSchema, version, false);
    }

    private org.apache.kafka.connect.data.Schema toConnectSchema(ToConnectContext ctx, Schema jsonSchema, Integer version, boolean forceOptional) {
        Map parameters;
        Integer connectVersion;
        SchemaBuilder builder;
        if (jsonSchema == null) {
            return null;
        }
        if (jsonSchema instanceof BooleanSchema) {
            builder = SchemaBuilder.bool();
        } else if (jsonSchema instanceof NumberSchema) {
            NumberSchema numberSchema = (NumberSchema)jsonSchema;
            type = (String)numberSchema.getUnprocessedProperties().get(CONNECT_TYPE_PROP);
            if (type == null) {
                builder = numberSchema.requiresInteger() ? SchemaBuilder.int64() : SchemaBuilder.float64();
            } else {
                switch (type) {
                    case "int8": {
                        builder = SchemaBuilder.int8();
                        break;
                    }
                    case "int16": {
                        builder = SchemaBuilder.int16();
                        break;
                    }
                    case "int32": {
                        builder = SchemaBuilder.int32();
                        break;
                    }
                    case "int64": {
                        builder = SchemaBuilder.int64();
                        break;
                    }
                    case "float32": {
                        builder = SchemaBuilder.float32();
                        break;
                    }
                    case "float64": {
                        builder = SchemaBuilder.float64();
                        break;
                    }
                    case "bytes": {
                        builder = SchemaBuilder.bytes();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type " + type);
                    }
                }
            }
        } else if (jsonSchema instanceof StringSchema) {
            String type = (String)jsonSchema.getUnprocessedProperties().get(CONNECT_TYPE_PROP);
            builder = CONNECT_TYPE_BYTES.equals(type) ? SchemaBuilder.bytes() : SchemaBuilder.string();
        } else if (jsonSchema instanceof ConstSchema) {
            ConstSchema constSchema = (ConstSchema)jsonSchema;
            possibleValues = ImmutableList.of((Object)constSchema.getPermittedValue());
            builder = this.toConnectEnums((List<Object>)possibleValues);
        } else if (jsonSchema instanceof EnumSchema) {
            EnumSchema enumSchema = (EnumSchema)jsonSchema;
            possibleValues = enumSchema.getPossibleValuesAsList();
            builder = this.toConnectEnums((List<Object>)possibleValues);
        } else if (jsonSchema instanceof CombinedSchema) {
            Object name;
            CombinedSchema combinedSchema = (CombinedSchema)jsonSchema;
            if (combinedSchema.getSubschemas().size() == 1 && this.flattenSingletonUnions) {
                return this.toConnectSchema(ctx, (Schema)combinedSchema.getSubschemas().iterator().next());
            }
            CombinedSchema.ValidationCriterion criterion = combinedSchema.getCriterion();
            if (criterion == CombinedSchema.ONE_CRITERION || criterion == CombinedSchema.ANY_CRITERION) {
                name = this.generalizedSumTypeSupport ? GENERALIZED_TYPE_UNION_PREFIX + ctx.getAndIncrementUnionIndex() : JSON_TYPE_ONE_OF;
            } else {
                if (criterion == CombinedSchema.ALL_CRITERION) {
                    return this.allOfToConnectSchema(ctx, combinedSchema, version, forceOptional);
                }
                throw new IllegalArgumentException("Unsupported criterion: " + String.valueOf(criterion));
            }
            if (combinedSchema.getSubschemas().size() == 2) {
                boolean foundNullSchema = false;
                Schema nonNullSchema = null;
                for (Schema subSchema : combinedSchema.getSubschemas()) {
                    if (subSchema instanceof NullSchema) {
                        foundNullSchema = true;
                        continue;
                    }
                    nonNullSchema = subSchema;
                }
                if (foundNullSchema) {
                    return this.toConnectSchema(ctx, nonNullSchema, version, true);
                }
            }
            int index = 0;
            builder = SchemaBuilder.struct().name((String)name);
            if (this.generalizedSumTypeSupport) {
                builder.parameter(GENERALIZED_TYPE_UNION, (String)name);
            }
            for (Schema schema : combinedSchema.getSubschemas()) {
                if (schema instanceof NullSchema) {
                    builder.optional();
                    continue;
                }
                String subFieldName = this.generalizedSumTypeSupport ? GENERALIZED_TYPE_UNION_FIELD_PREFIX + index : (String)name + ".field." + index;
                builder.field(subFieldName, this.toConnectSchema(ctx, schema, null, true));
                ++index;
            }
        } else if (jsonSchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)jsonSchema;
            Schema itemsSchema = arraySchema.getAllItemSchema();
            if (itemsSchema == null) {
                throw new DataException("Array schema did not specify the items type");
            }
            String type = (String)arraySchema.getUnprocessedProperties().get(CONNECT_TYPE_PROP);
            if (CONNECT_TYPE_MAP.equals(type) && itemsSchema instanceof ObjectSchema) {
                ObjectSchema objectSchema = (ObjectSchema)itemsSchema;
                builder = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)this.toConnectSchema(ctx, (Schema)objectSchema.getPropertySchemas().get(KEY_FIELD)), (org.apache.kafka.connect.data.Schema)this.toConnectSchema(ctx, (Schema)objectSchema.getPropertySchemas().get(VALUE_FIELD)));
            } else {
                builder = SchemaBuilder.array((org.apache.kafka.connect.data.Schema)this.toConnectSchema(ctx, itemsSchema));
            }
        } else if (jsonSchema instanceof ObjectSchema) {
            ObjectSchema objectSchema = (ObjectSchema)jsonSchema;
            type = (String)objectSchema.getUnprocessedProperties().get(CONNECT_TYPE_PROP);
            if (CONNECT_TYPE_MAP.equals(type)) {
                builder = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)this.toConnectSchema(ctx, objectSchema.getSchemaOfAdditionalProperties()));
            } else {
                builder = SchemaBuilder.struct();
                ctx.put((Schema)objectSchema, builder);
                Map properties = objectSchema.getPropertySchemas();
                TreeMap sortedMap = new TreeMap();
                for (Map.Entry entry : properties.entrySet()) {
                    Schema subSchema = (Schema)entry.getValue();
                    Integer index = (Integer)subSchema.getUnprocessedProperties().get(CONNECT_INDEX_PROP);
                    if (index == null) {
                        index = sortedMap.size();
                    }
                    sortedMap.put(index, entry);
                }
                for (Map.Entry entry : sortedMap.values()) {
                    String subFieldName = (String)entry.getKey();
                    Schema subSchema = (Schema)entry.getValue();
                    boolean isFieldOptional = this.config.useOptionalForNonRequiredProperties() && !objectSchema.getRequiredProperties().contains(subFieldName);
                    builder.field(subFieldName, this.toConnectSchema(ctx, subSchema, null, isFieldOptional));
                }
            }
        } else {
            if (jsonSchema instanceof ReferenceSchema) {
                ReferenceSchema refSchema = (ReferenceSchema)jsonSchema;
                SchemaBuilder refBuilder = ctx.get(refSchema.getReferredSchema());
                if (refBuilder != null) {
                    refBuilder.parameter(JSON_ID_PROP, DEFAULT_ID_PREFIX + ctx.incrementAndGetIdIndex());
                    return new SchemaWrapper(refBuilder, forceOptional);
                }
                return this.toConnectSchema(ctx, refSchema.getReferredSchema(), version, forceOptional);
            }
            throw new DataException("Unsupported schema type " + jsonSchema.getClass().getName());
        }
        String title = jsonSchema.getTitle();
        if (title != null && builder.name() == null) {
            builder.name(title);
        }
        if ((connectVersion = (Integer)jsonSchema.getUnprocessedProperties().get(CONNECT_VERSION_PROP)) != null) {
            builder.version(connectVersion);
        } else if (version != null) {
            builder.version(version);
        }
        String description = jsonSchema.getDescription();
        if (description != null) {
            builder.doc(description);
        }
        if ((parameters = (Map)jsonSchema.getUnprocessedProperties().get(CONNECT_PARAMETERS_PROP)) != null) {
            builder.parameters(parameters);
        }
        if (jsonSchema.hasDefaultValue()) {
            Object defaultVal = jsonSchema.getDefaultValue();
            NullNode nullNode = defaultVal == JSONObject.NULL ? NullNode.getInstance() : (JsonNode)OBJECT_MAPPER.convertValue(defaultVal, JsonNode.class);
            builder.defaultValue(this.toConnectData((org.apache.kafka.connect.data.Schema)builder, (JsonNode)nullNode));
        }
        if (forceOptional) {
            builder.optional();
        }
        org.apache.kafka.connect.data.Schema result = builder.build();
        return result;
    }

    private SchemaBuilder toConnectEnums(List<Object> possibleValues) {
        SchemaBuilder builder = SchemaBuilder.string();
        String paramName = this.generalizedSumTypeSupport ? GENERALIZED_TYPE_ENUM : JSON_TYPE_ENUM;
        builder.parameter(paramName, "");
        int symbolIndex = 0;
        for (Object enumObj : possibleValues) {
            String enumSymbol;
            String string = enumSymbol = enumObj != null ? enumObj.toString() : NULL_MARKER;
            if (this.generalizedSumTypeSupport) {
                builder.parameter(paramName + "." + enumSymbol, String.valueOf(symbolIndex));
            } else {
                builder.parameter(paramName + "." + enumSymbol, enumSymbol);
            }
            ++symbolIndex;
        }
        return builder;
    }

    private org.apache.kafka.connect.data.Schema allOfToConnectSchema(ToConnectContext ctx, CombinedSchema combinedSchema, Integer version, boolean forceOptional) {
        ConstSchema constSchema = null;
        EnumSchema enumSchema = null;
        NumberSchema numberSchema = null;
        StringSchema stringSchema = null;
        CombinedSchema combinedSubschema = null;
        ReferenceSchema referenceSchema = null;
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        HashMap<String, Boolean> required = new HashMap<String, Boolean>();
        for (Schema subSchema : combinedSchema.getSubschemas()) {
            if (subSchema instanceof ConstSchema) {
                constSchema = (ConstSchema)subSchema;
            } else if (subSchema instanceof EnumSchema) {
                enumSchema = (EnumSchema)subSchema;
            } else if (subSchema instanceof NumberSchema) {
                numberSchema = (NumberSchema)subSchema;
            } else if (subSchema instanceof StringSchema) {
                stringSchema = (StringSchema)subSchema;
            } else if (subSchema instanceof CombinedSchema) {
                combinedSubschema = (CombinedSchema)subSchema;
            } else if (subSchema instanceof ReferenceSchema) {
                referenceSchema = (ReferenceSchema)subSchema;
            }
            this.collectPropertySchemas(subSchema, properties, required, new HashSet<JsonSchema>());
        }
        if (!properties.isEmpty()) {
            SchemaBuilder builder = SchemaBuilder.struct();
            ctx.put((Schema)combinedSchema, builder);
            for (Map.Entry property : properties.entrySet()) {
                String subFieldName = (String)property.getKey();
                Schema subSchema = (Schema)property.getValue();
                boolean isFieldOptional = this.config.useOptionalForNonRequiredProperties() && (Boolean)required.get(subFieldName) == false;
                builder.field(subFieldName, this.toConnectSchema(ctx, subSchema, null, isFieldOptional));
            }
            if (forceOptional) {
                builder.optional();
            }
            return builder.build();
        }
        if (combinedSubschema != null) {
            return this.toConnectSchema(ctx, (Schema)combinedSubschema, version, forceOptional);
        }
        if (constSchema != null) {
            if (stringSchema != null) {
                return this.toConnectSchema(ctx, (Schema)stringSchema, version, forceOptional);
            }
            if (numberSchema != null) {
                return this.toConnectSchema(ctx, (Schema)numberSchema, version, forceOptional);
            }
        } else if (enumSchema != null) {
            if (stringSchema != null) {
                return this.toConnectSchema(ctx, (Schema)enumSchema, version, forceOptional);
            }
            if (numberSchema != null) {
                return this.toConnectSchema(ctx, (Schema)numberSchema, version, forceOptional);
            }
        } else {
            if (stringSchema != null && stringSchema.getFormatValidator() != null) {
                if (numberSchema != null) {
                    return this.toConnectSchema(ctx, (Schema)numberSchema, version, forceOptional);
                }
                return this.toConnectSchema(ctx, (Schema)stringSchema, version, forceOptional);
            }
            if (referenceSchema != null) {
                SchemaBuilder refBuilder = ctx.get(referenceSchema.getReferredSchema());
                if (refBuilder != null) {
                    refBuilder.parameter(JSON_ID_PROP, DEFAULT_ID_PREFIX + ctx.incrementAndGetIdIndex());
                    return new SchemaWrapper(refBuilder, forceOptional);
                }
                return this.toConnectSchema(ctx, referenceSchema.getReferredSchema(), version, forceOptional);
            }
        }
        throw new IllegalArgumentException("Unsupported criterion " + String.valueOf(combinedSchema.getCriterion()) + " for " + String.valueOf(combinedSchema));
    }

    private void collectPropertySchemas(Schema schema, Map<String, Schema> properties, Map<String, Boolean> required, Set<JsonSchema> visited) {
        JsonSchema jsonSchema = new JsonSchema(schema);
        if (visited.contains(jsonSchema)) {
            return;
        }
        visited.add(jsonSchema);
        if (schema instanceof CombinedSchema) {
            CombinedSchema combinedSchema = (CombinedSchema)schema;
            if (combinedSchema.getCriterion() == CombinedSchema.ALL_CRITERION) {
                for (Schema subSchema : combinedSchema.getSubschemas()) {
                    this.collectPropertySchemas(subSchema, properties, required, visited);
                }
            }
        } else if (schema instanceof ObjectSchema) {
            ObjectSchema objectSchema = (ObjectSchema)schema;
            for (Map.Entry entry : objectSchema.getPropertySchemas().entrySet()) {
                String fieldName = (String)entry.getKey();
                properties.put(fieldName, (Schema)entry.getValue());
                required.put(fieldName, objectSchema.getRequiredProperties().contains(fieldName));
            }
        } else if (schema instanceof ReferenceSchema) {
            ReferenceSchema refSchema = (ReferenceSchema)schema;
            this.collectPropertySchemas(refSchema.getReferredSchema(), properties, required, visited);
        }
    }

    private static boolean isUnionSchema(org.apache.kafka.connect.data.Schema schema) {
        return JSON_TYPE_ONE_OF.equals(schema.name()) || ConnectUnion.isUnion((org.apache.kafka.connect.data.Schema)schema);
    }

    static {
        TO_CONNECT_CONVERTERS.put(Schema.Type.BOOLEAN, (data, schema, value) -> value.booleanValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT8, (data, schema, value) -> (byte)value.shortValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT16, (data, schema, value) -> value.shortValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT32, (data, schema, value) -> value.intValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT64, (data, schema, value) -> value.longValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.FLOAT32, (data, schema, value) -> Float.valueOf(value.floatValue()));
        TO_CONNECT_CONVERTERS.put(Schema.Type.FLOAT64, (data, schema, value) -> value.doubleValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.BYTES, (data, schema, value) -> {
            try {
                Object o = value.binaryValue();
                if (o == null) {
                    o = value.decimalValue();
                }
                return o;
            }
            catch (IOException e) {
                throw new DataException("Invalid bytes field", (Throwable)e);
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.STRING, (data, schema, value) -> value.textValue());
        TO_CONNECT_CONVERTERS.put(Schema.Type.ARRAY, (data, schema, value) -> {
            org.apache.kafka.connect.data.Schema elemSchema = schema == null ? null : schema.valueSchema();
            ArrayList<Object> result = new ArrayList<Object>();
            for (JsonNode elem : value) {
                result.add(data.toConnectData(elemSchema, elem));
            }
            return result;
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.MAP, (data, schema, value) -> {
            org.apache.kafka.connect.data.Schema keySchema = schema == null ? null : schema.keySchema();
            org.apache.kafka.connect.data.Schema valueSchema = schema == null ? null : schema.valueSchema();
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            if (schema == null || keySchema.type() == Schema.Type.STRING && !keySchema.isOptional()) {
                if (!value.isObject()) {
                    throw new DataException("Maps with string fields should be encoded as JSON objects, but found " + String.valueOf(value.getNodeType()));
                }
                Iterator fieldIt = value.fields();
                while (fieldIt.hasNext()) {
                    Map.Entry entry = (Map.Entry)fieldIt.next();
                    result.put(entry.getKey(), data.toConnectData(valueSchema, (JsonNode)entry.getValue()));
                }
            } else {
                if (!value.isArray()) {
                    throw new DataException("Maps with non-string fields should be encoded as JSON array of objects, but found " + String.valueOf(value.getNodeType()));
                }
                for (JsonNode entry : value) {
                    if (!entry.isObject()) {
                        throw new DataException("Found invalid map entry instead of object: " + String.valueOf(entry.getNodeType()));
                    }
                    if (entry.size() != 2) {
                        throw new DataException("Found invalid map entry, expected length 2 but found :" + entry.size());
                    }
                    result.put(data.toConnectData(keySchema, entry.get(KEY_FIELD)), data.toConnectData(valueSchema, entry.get(VALUE_FIELD)));
                }
            }
            return result;
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.STRUCT, (data, schema, value) -> {
            if (JsonSchemaData.isUnionSchema(schema)) {
                boolean generalizedSumTypeSupport = ConnectUnion.isUnion((org.apache.kafka.connect.data.Schema)schema);
                String fieldNamePrefix = generalizedSumTypeSupport ? GENERALIZED_TYPE_UNION_FIELD_PREFIX : "io.confluent.connect.json.OneOf.field.";
                int numMatchingProperties = 0;
                Field matchingField = null;
                for (Field field : schema.fields()) {
                    org.apache.kafka.connect.data.Schema fieldSchema = field.schema();
                    if (JsonSchemaData.isInstanceOfSchemaTypeForSimpleSchema(fieldSchema, value)) {
                        return new Struct(schema.schema()).put(fieldNamePrefix + field.index(), data.toConnectData(fieldSchema, value));
                    }
                    int matching = JsonSchemaData.matchStructSchema(fieldSchema, value);
                    if (matching <= numMatchingProperties) continue;
                    numMatchingProperties = matching;
                    matchingField = field;
                }
                if (matchingField != null) {
                    return new Struct(schema.schema()).put(fieldNamePrefix + matchingField.index(), data.toConnectData(matchingField.schema(), value));
                }
                throw new DataException("Did not find matching oneof field for data");
            }
            if (!value.isObject()) {
                throw new DataException("Structs should be encoded as JSON objects, but found " + String.valueOf(value.getNodeType()));
            }
            Struct result = new Struct(schema.schema());
            for (Field field : schema.fields()) {
                Object fieldValue = data.toConnectData(field.schema(), value.get(field.name()));
                if (fieldValue == null) continue;
                result.put(field, fieldValue);
            }
            return result;
        });
        TO_CONNECT_LOGICAL_CONVERTERS = new HashMap();
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Decimal", (schema, value) -> {
            if (value.isNumber()) {
                return value.decimalValue();
            }
            if (value.isBinary() || value.isTextual()) {
                try {
                    return Decimal.toLogical((org.apache.kafka.connect.data.Schema)schema, (byte[])value.binaryValue());
                }
                catch (Exception e) {
                    throw new DataException("Invalid bytes for Decimal field", (Throwable)e);
                }
            }
            throw new DataException("Invalid type for Decimal, underlying representation should be numeric or bytes but was " + String.valueOf(value.getNodeType()));
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Date", (schema, value) -> {
            if (!value.isInt()) {
                throw new DataException("Invalid type for Date, underlying representation should be integer but was " + String.valueOf(value.getNodeType()));
            }
            return Date.toLogical((org.apache.kafka.connect.data.Schema)schema, (int)value.intValue());
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Time", (schema, value) -> {
            if (!value.isInt()) {
                throw new DataException("Invalid type for Time, underlying representation should be integer but was " + String.valueOf(value.getNodeType()));
            }
            return Time.toLogical((org.apache.kafka.connect.data.Schema)schema, (int)value.intValue());
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Timestamp", (schema, value) -> {
            if (!value.isIntegralNumber()) {
                throw new DataException("Invalid type for Timestamp, underlying representation should be integral but was " + String.valueOf(value.getNodeType()));
            }
            return Timestamp.toLogical((org.apache.kafka.connect.data.Schema)schema, (long)value.longValue());
        });
        TO_JSON_LOGICAL_CONVERTERS = new HashMap();
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Decimal", (schema, value, config) -> {
            if (!(value instanceof BigDecimal)) {
                throw new DataException("Invalid type for Decimal, expected BigDecimal but was " + String.valueOf(value.getClass()));
            }
            BigDecimal decimal = (BigDecimal)value;
            switch (config.decimalFormat()) {
                case NUMERIC: {
                    return JSON_NODE_FACTORY.numberNode(decimal);
                }
                case BASE64: {
                    return JSON_NODE_FACTORY.binaryNode(Decimal.fromLogical((org.apache.kafka.connect.data.Schema)schema, (BigDecimal)decimal));
                }
            }
            throw new DataException("Unexpected decimal.format: " + String.valueOf(config.decimalFormat()));
        });
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Date", (schema, value, config) -> {
            if (!(value instanceof java.util.Date)) {
                throw new DataException("Invalid type for Date, expected Date but was " + String.valueOf(value.getClass()));
            }
            return JSON_NODE_FACTORY.numberNode(Date.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)value)));
        });
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Time", (schema, value, config) -> {
            if (!(value instanceof java.util.Date)) {
                throw new DataException("Invalid type for Time, expected Date but was " + String.valueOf(value.getClass()));
            }
            return JSON_NODE_FACTORY.numberNode(Time.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)value)));
        });
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Timestamp", (schema, value, config) -> {
            if (!(value instanceof java.util.Date)) {
                throw new DataException("Invalid type for Timestamp, expected Date but was " + String.valueOf(value.getClass()));
            }
            return JSON_NODE_FACTORY.numberNode(Timestamp.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)value)));
        });
        NONE_MARKER = new Object();
    }

    private static interface ConnectToJsonLogicalTypeConverter {
        public JsonNode convert(org.apache.kafka.connect.data.Schema var1, Object var2, JsonSchemaDataConfig var3);
    }

    private static interface JsonToConnectTypeConverter {
        public Object convert(JsonSchemaData var1, org.apache.kafka.connect.data.Schema var2, JsonNode var3);
    }

    private static interface JsonToConnectLogicalTypeConverter {
        public Object convert(org.apache.kafka.connect.data.Schema var1, JsonNode var2);
    }

    private static class FromConnectContext {
        private final Set<String> ids = new HashSet<String>();

        public boolean contains(String id) {
            return id != null && this.ids.contains(id);
        }

        public void add(String id) {
            if (id != null) {
                this.ids.add(id);
            }
        }
    }

    private static class ToConnectContext {
        private final Map<Schema, SchemaBuilder> schemaToStructMap = new IdentityHashMap<Schema, SchemaBuilder>();
        private int idIndex = 0;
        private int unionIndex = 0;

        public SchemaBuilder get(Schema schema) {
            return this.schemaToStructMap.get(schema);
        }

        public void put(Schema schema, SchemaBuilder builder) {
            this.schemaToStructMap.put(schema, builder);
        }

        public int incrementAndGetIdIndex() {
            return ++this.idIndex;
        }

        public int getAndIncrementUnionIndex() {
            return this.unionIndex++;
        }
    }

    static class SchemaWrapper
    extends SchemaBuilder {
        private final SchemaBuilder builder;
        private boolean optional;
        private final Map<String, String> parameters;

        public SchemaWrapper(SchemaBuilder builder, boolean optional) {
            super(Schema.Type.STRUCT);
            this.builder = builder;
            this.optional = optional;
            this.parameters = new LinkedHashMap<String, String>();
        }

        public boolean isOptional() {
            return this.optional;
        }

        public SchemaBuilder optional() {
            this.optional = true;
            return this;
        }

        public SchemaBuilder required() {
            this.optional = false;
            return this;
        }

        public Object defaultValue() {
            return this.builder.defaultValue();
        }

        public SchemaBuilder defaultValue(Object value) {
            this.builder.defaultValue(value);
            return this;
        }

        public String name() {
            return this.builder.name();
        }

        public SchemaBuilder name(String name) {
            this.builder.name(name);
            return this;
        }

        public Integer version() {
            return this.builder.version();
        }

        public SchemaBuilder version(Integer version) {
            this.builder.version(version);
            return this;
        }

        public String doc() {
            return this.builder.doc();
        }

        public SchemaBuilder doc(String doc) {
            this.builder.doc(doc);
            return this;
        }

        public Map<String, String> parameters() {
            HashMap<String, String> allParameters = new HashMap<String, String>();
            if (this.builder.parameters() != null) {
                allParameters.putAll(this.builder.parameters());
            }
            allParameters.putAll(this.parameters);
            return allParameters;
        }

        public SchemaBuilder parameters(Map<String, String> props) {
            this.parameters.putAll(props);
            return this;
        }

        public SchemaBuilder parameter(String propertyName, String propertyValue) {
            this.parameters.put(propertyName, propertyValue);
            return this;
        }

        public Schema.Type type() {
            return this.builder.type();
        }

        public List<Field> fields() {
            return this.builder.fields();
        }

        public Field field(String fieldName) {
            return this.builder.field(fieldName);
        }

        public SchemaBuilder field(String fieldName, org.apache.kafka.connect.data.Schema fieldSchema) {
            this.builder.field(fieldName, fieldSchema);
            return this;
        }

        public org.apache.kafka.connect.data.Schema keySchema() {
            return this.builder.keySchema();
        }

        public org.apache.kafka.connect.data.Schema valueSchema() {
            return this.builder.valueSchema();
        }

        public org.apache.kafka.connect.data.Schema build() {
            return this;
        }

        public org.apache.kafka.connect.data.Schema schema() {
            return this;
        }
    }
}

