/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetireGrantRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, RetireGrantRequest> {
    private static final SdkField<String> GRANT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantToken").getter(RetireGrantRequest.getter(RetireGrantRequest::grantToken)).setter(RetireGrantRequest.setter(Builder::grantToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantToken").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(RetireGrantRequest.getter(RetireGrantRequest::keyId)).setter(RetireGrantRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> GRANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantId").getter(RetireGrantRequest.getter(RetireGrantRequest::grantId)).setter(RetireGrantRequest.setter(Builder::grantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(RetireGrantRequest.getter(RetireGrantRequest::dryRun)).setter(RetireGrantRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANT_TOKEN_FIELD, KEY_ID_FIELD, GRANT_ID_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetireGrantRequest.memberNameToFieldInitializer();
    private final String grantToken;
    private final String keyId;
    private final String grantId;
    private final Boolean dryRun;

    private RetireGrantRequest(BuilderImpl builder) {
        super(builder);
        this.grantToken = builder.grantToken;
        this.keyId = builder.keyId;
        this.grantId = builder.grantId;
        this.dryRun = builder.dryRun;
    }

    public final String grantToken() {
        return this.grantToken;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final String grantId() {
        return this.grantId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.grantToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetireGrantRequest)) {
            return false;
        }
        RetireGrantRequest other = (RetireGrantRequest)((Object)obj);
        return Objects.equals(this.grantToken(), other.grantToken()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.grantId(), other.grantId()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"RetireGrantRequest").add("GrantToken", (Object)this.grantToken()).add("KeyId", (Object)this.keyId()).add("GrantId", (Object)this.grantId()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrantToken": {
                return Optional.ofNullable(clazz.cast(this.grantToken()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "GrantId": {
                return Optional.ofNullable(clazz.cast(this.grantId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GrantToken", GRANT_TOKEN_FIELD);
        map.put("KeyId", KEY_ID_FIELD);
        map.put("GrantId", GRANT_ID_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetireGrantRequest, T> g) {
        return obj -> g.apply((RetireGrantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String grantToken;
        private String keyId;
        private String grantId;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(RetireGrantRequest model) {
            super(model);
            this.grantToken(model.grantToken);
            this.keyId(model.keyId);
            this.grantId(model.grantId);
            this.dryRun(model.dryRun);
        }

        public final String getGrantToken() {
            return this.grantToken;
        }

        public final void setGrantToken(String grantToken) {
            this.grantToken = grantToken;
        }

        @Override
        public final Builder grantToken(String grantToken) {
            this.grantToken = grantToken;
            return this;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getGrantId() {
            return this.grantId;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetireGrantRequest build() {
            return new RetireGrantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetireGrantRequest> {
        public Builder grantToken(String var1);

        public Builder keyId(String var1);

        public Builder grantId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

