/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.CryptographyAsyncClient;
import com.azure.security.keyvault.keys.implementation.KeyClientImpl;
import com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import com.azure.security.keyvault.keys.implementation.models.BackupKeyResult;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyBundle;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyItem;
import com.azure.security.keyvault.keys.implementation.models.KeyBundle;
import com.azure.security.keyvault.keys.implementation.models.KeyItem;
import com.azure.security.keyvault.keys.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.keys.implementation.models.KeyVaultKeysModelsUtils;
import com.azure.security.keyvault.keys.implementation.models.RandomBytes;
import com.azure.security.keyvault.keys.models.CreateEcKeyOptions;
import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.CreateOctKeyOptions;
import com.azure.security.keyvault.keys.models.CreateRsaKeyOptions;
import com.azure.security.keyvault.keys.models.DeletedKey;
import com.azure.security.keyvault.keys.models.ImportKeyOptions;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyExportEncryptionAlgorithm;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyRotationPolicy;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.azure.security.keyvault.keys.models.ReleaseKeyOptions;
import com.azure.security.keyvault.keys.models.ReleaseKeyResult;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=KeyClientBuilder.class, isAsync=true, serviceInterfaces={KeyClientImpl.KeyClientService.class})
public final class KeyAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyAsyncClient.class);
    private final KeyClientImpl implClient;
    private final String vaultUrl;
    private final KeyServiceVersion serviceVersion;

    KeyAsyncClient(KeyClientImpl implClient, String vaultUrl, KeyServiceVersion keyServiceVersion) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
        this.serviceVersion = keyServiceVersion;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.implClient.getHttpPipeline();
    }

    public CryptographyAsyncClient getCryptographyAsyncClient(String keyName) {
        return this.getCryptographyAsyncClient(keyName, null);
    }

    public CryptographyAsyncClient getCryptographyAsyncClient(String keyName, String keyVersion) {
        return KeyVaultKeysUtils.getCryptographyClientBuilder(keyName, keyVersion, this.vaultUrl, this.getHttpPipeline(), this.serviceVersion).buildAsyncClient();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createKey(String name, KeyType keyType) {
        return this.createKeyWithResponse(new CreateKeyOptions(name, keyType)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createKeyWithResponse(CreateKeyOptions createKeyOptions) {
        try {
            if (createKeyOptions == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'createKeyOptions' cannot be null."));
            }
            return this.implClient.createKeyWithResponseAsync(this.vaultUrl, createKeyOptions.getName(), createKeyOptions.getKeyType(), null, null, createKeyOptions.getKeyOperations(), KeyVaultKeysModelsUtils.createKeyAttributes(createKeyOptions), createKeyOptions.getTags(), null, KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createKeyOptions.getReleasePolicy())).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapCreateKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapCreateKeyException(KeyVaultErrorException exception) {
        return exception.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(exception.getMessage(), exception.getResponse(), (Object)exception.getValue()) : exception;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createKey(CreateKeyOptions createKeyOptions) {
        return this.createKeyWithResponse(createKeyOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createRsaKey(CreateRsaKeyOptions createRsaKeyOptions) {
        return this.createRsaKeyWithResponse(createRsaKeyOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createRsaKeyWithResponse(CreateRsaKeyOptions createRsaKeyOptions) {
        try {
            if (createRsaKeyOptions == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'createRsaKeyOptions' cannot be null."));
            }
            return this.implClient.createKeyWithResponseAsync(this.vaultUrl, createRsaKeyOptions.getName(), createRsaKeyOptions.getKeyType(), createRsaKeyOptions.getKeySize(), createRsaKeyOptions.getPublicExponent(), createRsaKeyOptions.getKeyOperations(), KeyVaultKeysModelsUtils.createKeyAttributes(createRsaKeyOptions), createRsaKeyOptions.getTags(), null, KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createRsaKeyOptions.getReleasePolicy())).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapCreateKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createEcKey(CreateEcKeyOptions createEcKeyOptions) {
        return this.createEcKeyWithResponse(createEcKeyOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createEcKeyWithResponse(CreateEcKeyOptions createEcKeyOptions) {
        try {
            if (createEcKeyOptions == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'createEcKeyOptions' cannot be null."));
            }
            return this.implClient.createKeyWithResponseAsync(this.vaultUrl, createEcKeyOptions.getName(), createEcKeyOptions.getKeyType(), null, null, createEcKeyOptions.getKeyOperations(), KeyVaultKeysModelsUtils.createKeyAttributes(createEcKeyOptions), createEcKeyOptions.getTags(), createEcKeyOptions.getCurveName(), KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createEcKeyOptions.getReleasePolicy())).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapCreateKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createOctKey(CreateOctKeyOptions createOctKeyOptions) {
        return this.createOctKeyWithResponse(createOctKeyOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createOctKeyWithResponse(CreateOctKeyOptions createOctKeyOptions) {
        try {
            if (createOctKeyOptions == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'createOctKeyOptions' cannot be null."));
            }
            return this.implClient.createKeyWithResponseAsync(this.vaultUrl, createOctKeyOptions.getName(), createOctKeyOptions.getKeyType(), createOctKeyOptions.getKeySize(), null, createOctKeyOptions.getKeyOperations(), KeyVaultKeysModelsUtils.createKeyAttributes(createOctKeyOptions), createOctKeyOptions.getTags(), null, KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createOctKeyOptions.getReleasePolicy())).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapCreateKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> importKey(String name, JsonWebKey keyMaterial) {
        return this.importKeyWithResponse(new ImportKeyOptions(name, keyMaterial)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> importKey(ImportKeyOptions importKeyOptions) {
        return this.importKeyWithResponse(importKeyOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> importKeyWithResponse(ImportKeyOptions importKeyOptions) {
        try {
            if (importKeyOptions == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new RuntimeException("'importKeyOptions' cannot be null."));
            }
            return this.implClient.importKeyWithResponseAsync(this.vaultUrl, importKeyOptions.getName(), KeyVaultKeysModelsUtils.mapJsonWebKey(importKeyOptions.getKey()), importKeyOptions.isHardwareProtected(), KeyVaultKeysModelsUtils.createKeyAttributes(importKeyOptions), importKeyOptions.getTags(), KeyVaultKeysModelsUtils.mapKeyReleasePolicy(importKeyOptions.getReleasePolicy())).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> getKey(String name, String version) {
        return this.getKeyWithResponse(name, version).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> getKeyWithResponse(String name, String version) {
        try {
            return this.implClient.getKeyWithResponseAsync(this.vaultUrl, name, version).onErrorMap(KeyVaultErrorException.class, KeyVaultKeysUtils::mapGetKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> getKey(String name) {
        return this.getKeyWithResponse(name, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> updateKeyPropertiesWithResponse(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        try {
            if (keyProperties == null) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'keyProperties' cannot be null."));
            }
            return this.implClient.updateKeyWithResponseAsync(this.vaultUrl, keyProperties.getName(), keyProperties.getVersion(), keyOperations == null ? null : Arrays.asList(keyOperations), KeyVaultKeysModelsUtils.createKeyAttributes(keyProperties), keyProperties.getTags(), KeyVaultKeysModelsUtils.mapKeyReleasePolicy(keyProperties.getReleasePolicy())).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> updateKeyProperties(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        return this.updateKeyPropertiesWithResponse(keyProperties, keyOperations).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DeletedKey, Void> beginDeleteKey(String name) {
        return new PollerFlux(Duration.ofSeconds(1L), this.deleteActivationOperation(name), this.deletePollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<DeletedKey>, Mono<DeletedKey>> deleteActivationOperation(String name) {
        return pollingContext -> this.implClient.deleteKeyAsync(this.vaultUrl, name).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapDeleteKeyException).map(KeyVaultKeysModelsUtils::createDeletedKey);
    }

    static HttpResponseException mapDeleteKeyException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    private Function<PollingContext<DeletedKey>, Mono<PollResponse<DeletedKey>>> deletePollOperation(String name) {
        return pollingContext -> this.implClient.getDeletedKeyAsync(this.vaultUrl, name).map(bundle -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)KeyVaultKeysModelsUtils.createDeletedKey(bundle))).onErrorResume(HttpResponseException.class, ex -> {
            if (ex.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedKey> getDeletedKey(String name) {
        return this.getDeletedKeyWithResponse(name).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedKey>> getDeletedKeyWithResponse(String name) {
        try {
            return this.implClient.getDeletedKeyWithResponseAsync(this.vaultUrl, name).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapGetDeletedKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createDeletedKey((DeletedKeyBundle)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapGetDeletedKeyException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedKey(String name) {
        return this.purgeDeletedKeyWithResponse(name).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedKeyWithResponse(String name) {
        try {
            return this.implClient.purgeDeletedKeyWithResponseAsync(this.vaultUrl, name).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapPurgeDeletedKeyException);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapPurgeDeletedKeyException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultKey, Void> beginRecoverDeletedKey(String name) {
        return new PollerFlux(Duration.ofSeconds(1L), this.recoverActivationOperation(name), this.recoverPollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<KeyVaultKey>, Mono<KeyVaultKey>> recoverActivationOperation(String name) {
        return pollingContext -> this.implClient.recoverDeletedKeyAsync(this.vaultUrl, name).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapRecoverDeletedKeyException).map(KeyVaultKeysModelsUtils::createKeyVaultKey);
    }

    static HttpResponseException mapRecoverDeletedKeyException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    private Function<PollingContext<KeyVaultKey>, Mono<PollResponse<KeyVaultKey>>> recoverPollOperation(String keyName) {
        return pollingContext -> this.implClient.getKeyAsync(this.vaultUrl, keyName, null).map(keyResponse -> new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey(keyResponse))).onErrorResume(KeyVaultErrorException.class, ex -> {
            if (ex.getResponse().getStatusCode() == 404) {
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue())));
            }
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue())));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> backupKey(String name) {
        return this.backupKeyWithResponse(name).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> backupKeyWithResponse(String name) {
        try {
            return this.implClient.backupKeyWithResponseAsync(this.vaultUrl, name).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapBackupKeyException).map(response -> new SimpleResponse(response, (Object)((BackupKeyResult)response.getValue()).getValue()));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapBackupKeyException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> restoreKeyBackup(byte[] backup) {
        return this.restoreKeyBackupWithResponse(backup).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> restoreKeyBackupWithResponse(byte[] backup) {
        try {
            return this.implClient.restoreKeyWithResponseAsync(this.vaultUrl, backup).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapRestoreKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapRestoreKeyException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 400 ? new ResourceModifiedException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyProperties> listPropertiesOfKeys() {
        return new PagedFlux(maxResults -> this.implClient.getKeysSinglePageAsync(this.vaultUrl, (Integer)maxResults).map(KeyAsyncClient::mapKeyItemPagedResponse), (continuationToken, maxResults) -> this.implClient.getKeysNextSinglePageAsync((String)continuationToken, this.vaultUrl).map(KeyAsyncClient::mapKeyItemPagedResponse));
    }

    static PagedResponse<KeyProperties> mapKeyItemPagedResponse(PagedResponse<KeyItem> page) {
        ArrayList<KeyProperties> properties = new ArrayList<KeyProperties>(page.getValue().size());
        for (KeyItem keyItem : page.getValue()) {
            properties.add(KeyVaultKeysModelsUtils.createKeyProperties(keyItem));
        }
        return new PagedResponseBase(page.getRequest(), page.getStatusCode(), page.getHeaders(), properties, (String)page.getContinuationToken(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedKey> listDeletedKeys() {
        return new PagedFlux(maxResults -> this.implClient.getDeletedKeysSinglePageAsync(this.vaultUrl, (Integer)maxResults).map(KeyAsyncClient::mapDeletedKeyItemPagedResponse), (continuationToken, maxResults) -> this.implClient.getDeletedKeysNextSinglePageAsync((String)continuationToken, this.vaultUrl).map(KeyAsyncClient::mapDeletedKeyItemPagedResponse));
    }

    static PagedResponse<DeletedKey> mapDeletedKeyItemPagedResponse(PagedResponse<DeletedKeyItem> page) {
        ArrayList<DeletedKey> properties = new ArrayList<DeletedKey>(page.getValue().size());
        for (DeletedKeyItem keyItem : page.getValue()) {
            properties.add(KeyVaultKeysModelsUtils.createDeletedKey(keyItem));
        }
        return new PagedResponseBase(page.getRequest(), page.getStatusCode(), page.getHeaders(), properties, (String)page.getContinuationToken(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyProperties> listPropertiesOfKeyVersions(String name) {
        return new PagedFlux(maxResults -> this.implClient.getKeyVersionsSinglePageAsync(this.vaultUrl, name, (Integer)maxResults).map(KeyAsyncClient::mapKeyItemPagedResponse), (continuationToken, maxResults) -> this.implClient.getKeyVersionsNextSinglePageAsync((String)continuationToken, this.vaultUrl).map(KeyAsyncClient::mapKeyItemPagedResponse));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> getRandomBytes(int count) {
        return this.getRandomBytesWithResponse(count).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> getRandomBytesWithResponse(int count) {
        try {
            return FluxUtil.withContext(context -> this.implClient.getRandomBytesWithResponseAsync(this.vaultUrl, count)).map(response -> new SimpleResponse(response, (Object)((RandomBytes)response.getValue()).getValue()));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReleaseKeyResult> releaseKey(String name, String targetAttestationToken) {
        return this.releaseKeyWithResponse(name, null, targetAttestationToken, new ReleaseKeyOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReleaseKeyResult> releaseKey(String name, String version, String targetAttestationToken) {
        return this.releaseKeyWithResponse(name, version, targetAttestationToken, new ReleaseKeyOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ReleaseKeyResult>> releaseKeyWithResponse(String name, String version, String targetAttestationToken, ReleaseKeyOptions releaseKeyOptions) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)name) || CoreUtils.isNullOrEmpty((CharSequence)targetAttestationToken)) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'name' or 'targetAttestationToken' cannot be null or empty."));
            }
            String nonce = releaseKeyOptions == null ? null : releaseKeyOptions.getNonce();
            KeyExportEncryptionAlgorithm algorithm = releaseKeyOptions == null ? null : releaseKeyOptions.getAlgorithm();
            return this.implClient.releaseWithResponseAsync(this.vaultUrl, name, version, targetAttestationToken, nonce, algorithm).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapReleaseKeyException);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapReleaseKeyException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> rotateKey(String name) {
        return this.rotateKeyWithResponse(name).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> rotateKeyWithResponse(String name) {
        try {
            return this.implClient.rotateKeyWithResponseAsync(this.vaultUrl, name).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapRotateKeyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapRotateKeyException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> getKeyRotationPolicy(String keyName) {
        return this.getKeyRotationPolicyWithResponse(keyName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> getKeyRotationPolicyWithResponse(String keyName) {
        try {
            return this.implClient.getKeyRotationPolicyWithResponseAsync(this.vaultUrl, keyName).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapGetKeyRotationPolicyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.mapKeyRotationPolicyImpl((com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapGetKeyRotationPolicyException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> updateKeyRotationPolicy(String keyName, KeyRotationPolicy keyRotationPolicy) {
        return this.updateKeyRotationPolicyWithResponse(keyName, keyRotationPolicy).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicyWithResponse(String keyName, KeyRotationPolicy keyRotationPolicy) {
        try {
            return this.implClient.updateKeyRotationPolicyWithResponseAsync(this.vaultUrl, keyName, KeyVaultKeysModelsUtils.mapKeyRotationPolicy(keyRotationPolicy)).onErrorMap(KeyVaultErrorException.class, KeyAsyncClient::mapUpdateKeyRotationPolicyException).map(response -> new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.mapKeyRotationPolicyImpl((com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static HttpResponseException mapUpdateKeyRotationPolicyException(KeyVaultErrorException ex) {
        return ex.getResponse().getStatusCode() == 404 ? new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), (Object)ex.getValue()) : ex;
    }
}

