/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKeyEncryptionAlgorithm;
import java.io.IOException;
import java.util.Objects;

public final class KeyOperationsParameters
implements JsonSerializable<KeyOperationsParameters> {
    private JsonWebKeyEncryptionAlgorithm algorithm;
    private Base64Url value;
    private Base64Url iv;
    private Base64Url aad;
    private Base64Url tag;

    public JsonWebKeyEncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public KeyOperationsParameters setAlgorithm(JsonWebKeyEncryptionAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.decodedBytes();
    }

    public KeyOperationsParameters setValue(byte[] value) {
        this.value = value == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])value));
        return this;
    }

    public byte[] getIv() {
        if (this.iv == null) {
            return null;
        }
        return this.iv.decodedBytes();
    }

    public KeyOperationsParameters setIv(byte[] iv) {
        this.iv = iv == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])iv));
        return this;
    }

    public byte[] getAad() {
        if (this.aad == null) {
            return null;
        }
        return this.aad.decodedBytes();
    }

    public KeyOperationsParameters setAad(byte[] aad) {
        this.aad = aad == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])aad));
        return this;
    }

    public byte[] getTag() {
        if (this.tag == null) {
            return null;
        }
        return this.tag.decodedBytes();
    }

    public KeyOperationsParameters setTag(byte[] tag) {
        this.tag = tag == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])tag));
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alg", this.algorithm == null ? null : this.algorithm.toString());
        jsonWriter.writeStringField("value", Objects.toString(this.value, null));
        jsonWriter.writeStringField("iv", Objects.toString(this.iv, null));
        jsonWriter.writeStringField("aad", Objects.toString(this.aad, null));
        jsonWriter.writeStringField("tag", Objects.toString(this.tag, null));
        return jsonWriter.writeEndObject();
    }

    public static KeyOperationsParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KeyOperationsParameters)jsonReader.readObject(reader -> {
            KeyOperationsParameters deserializedKeyOperationsParameters = new KeyOperationsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("alg".equals(fieldName)) {
                    deserializedKeyOperationsParameters.algorithm = JsonWebKeyEncryptionAlgorithm.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedKeyOperationsParameters.value = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("iv".equals(fieldName)) {
                    deserializedKeyOperationsParameters.iv = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("aad".equals(fieldName)) {
                    deserializedKeyOperationsParameters.aad = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("tag".equals(fieldName)) {
                    deserializedKeyOperationsParameters.tag = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyOperationsParameters;
        });
    }
}

