/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.netty.handler.address;

import io.confluent.shaded.io.netty.channel.ChannelHandler;
import io.confluent.shaded.io.netty.channel.ChannelHandlerContext;
import io.confluent.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.confluent.shaded.io.netty.channel.ChannelPromise;
import io.confluent.shaded.io.netty.resolver.AddressResolver;
import io.confluent.shaded.io.netty.resolver.AddressResolverGroup;
import io.confluent.shaded.io.netty.util.concurrent.Future;
import io.confluent.shaded.io.netty.util.concurrent.FutureListener;
import io.confluent.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.confluent.shaded.io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;

@ChannelHandler.Sharable
public class ResolveAddressHandler
extends ChannelOutboundHandlerAdapter {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> resolverGroup) {
        this.resolverGroup = ObjectUtil.checkNotNull(resolverGroup, "resolverGroup");
    }

    @Override
    public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        AddressResolver<? extends SocketAddress> resolver = this.resolverGroup.getResolver(ctx.executor());
        if (resolver.isSupported(remoteAddress) && !resolver.isResolved(remoteAddress)) {
            resolver.resolve(remoteAddress).addListener((GenericFutureListener<Future<? extends SocketAddress>>)new FutureListener<SocketAddress>(){

                @Override
                public void operationComplete(Future<SocketAddress> future) {
                    Throwable cause = future.cause();
                    if (cause != null) {
                        promise.setFailure(cause);
                    } else {
                        ctx.connect(future.getNow(), localAddress, promise);
                    }
                    ctx.pipeline().remove(ResolveAddressHandler.this);
                }
            });
        } else {
            ctx.connect(remoteAddress, localAddress, promise);
            ctx.pipeline().remove(this);
        }
    }
}

