/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.completable;

import io.confluent.shaded.io.reactivex.Completable;
import io.confluent.shaded.io.reactivex.CompletableObserver;
import io.confluent.shaded.io.reactivex.CompletableOperator;
import io.confluent.shaded.io.reactivex.CompletableSource;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;

public final class CompletableLift
extends Completable {
    final CompletableSource source;
    final CompletableOperator onLift;

    public CompletableLift(CompletableSource source, CompletableOperator onLift) {
        this.source = source;
        this.onLift = onLift;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        try {
            CompletableObserver sw = this.onLift.apply(observer);
            this.source.subscribe(sw);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(ex);
        }
    }
}

