/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.request.body.generator;

import io.confluent.shaded.io.netty.buffer.ByteBuf;
import io.confluent.shaded.org.asynchttpclient.request.body.Body;
import io.confluent.shaded.org.asynchttpclient.request.body.generator.BodyChunk;
import io.confluent.shaded.org.asynchttpclient.request.body.generator.FeedListener;
import io.confluent.shaded.org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import io.confluent.shaded.org.asynchttpclient.request.body.generator.PushBody;
import java.util.Queue;

public abstract class QueueBasedFeedableBodyGenerator<T extends Queue<BodyChunk>>
implements FeedableBodyGenerator {
    protected final T queue;
    private FeedListener listener;

    public QueueBasedFeedableBodyGenerator(T queue) {
        this.queue = queue;
    }

    @Override
    public Body createBody() {
        return new PushBody((Queue<BodyChunk>)this.queue);
    }

    protected abstract boolean offer(BodyChunk var1) throws Exception;

    @Override
    public boolean feed(ByteBuf buffer, boolean isLast) throws Exception {
        boolean offered = this.offer(new BodyChunk(buffer, isLast));
        if (offered && this.listener != null) {
            this.listener.onContentAdded();
        }
        return offered;
    }

    @Override
    public void setListener(FeedListener listener) {
        this.listener = listener;
    }
}

