/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.request.body.multipart.part;

import io.confluent.shaded.io.netty.buffer.ByteBuf;
import io.confluent.shaded.org.asynchttpclient.request.body.multipart.InputStreamPart;
import io.confluent.shaded.org.asynchttpclient.request.body.multipart.part.FileLikeMultipartPart;
import io.confluent.shaded.org.asynchttpclient.request.body.multipart.part.MultipartState;
import io.confluent.shaded.org.asynchttpclient.util.MiscUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class InputStreamMultipartPart
extends FileLikeMultipartPart<InputStreamPart> {
    private long position = 0L;
    private ByteBuffer buffer;
    private ReadableByteChannel channel;

    public InputStreamMultipartPart(InputStreamPart part, byte[] boundary) {
        super(part, boundary);
    }

    private ByteBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocateDirect(8192);
        }
        return this.buffer;
    }

    private ReadableByteChannel getChannel() {
        if (this.channel == null) {
            this.channel = Channels.newChannel(((InputStreamPart)this.part).getInputStream());
        }
        return this.channel;
    }

    @Override
    protected long getContentLength() {
        return ((InputStreamPart)this.part).getContentLength();
    }

    @Override
    protected long transferContentTo(ByteBuf target) throws IOException {
        InputStream inputStream = ((InputStreamPart)this.part).getInputStream();
        int transferred = target.writeBytes(inputStream, target.writableBytes());
        if (transferred > 0) {
            this.position += (long)transferred;
        }
        if (this.position == this.getContentLength() || transferred < 0) {
            this.state = MultipartState.POST_CONTENT;
            inputStream.close();
        }
        return transferred;
    }

    @Override
    protected long transferContentTo(WritableByteChannel target) throws IOException {
        ReadableByteChannel channel = this.getChannel();
        ByteBuffer buffer = this.getBuffer();
        int transferred = 0;
        int read = channel.read(buffer);
        if (read > 0) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                transferred += target.write(buffer);
            }
            buffer.compact();
            this.position += (long)transferred;
        }
        if (this.position == this.getContentLength() || read < 0) {
            this.state = MultipartState.POST_CONTENT;
            if (channel.isOpen()) {
                channel.close();
            }
        }
        return transferred;
    }

    @Override
    public void close() {
        super.close();
        MiscUtils.closeSilently(((InputStreamPart)this.part).getInputStream());
        MiscUtils.closeSilently(this.channel);
    }
}

