/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.provider;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.validator.CloudEventValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;

public class CloudEventValidatorProvider {
    private static final CloudEventValidatorProvider cloudEventValidatorProvider = new CloudEventValidatorProvider();
    private final Collection<CloudEventValidator> validators;

    private CloudEventValidatorProvider() {
        ServiceLoader<CloudEventValidator> loader = ServiceLoader.load(CloudEventValidator.class);
        this.validators = new ArrayList<CloudEventValidator>(2);
        for (CloudEventValidator cloudEventValidator : loader) {
            this.validators.add(cloudEventValidator);
        }
    }

    public static CloudEventValidatorProvider getInstance() {
        return cloudEventValidatorProvider;
    }

    public void validate(CloudEvent cloudEvent) {
        for (CloudEventValidator validator : this.validators) {
            validator.validate(cloudEvent);
        }
    }
}

