/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.metrics.stats;

import io.confluent.common.metrics.MeasurableStat;
import io.confluent.common.metrics.MetricConfig;
import io.confluent.common.metrics.stats.SampledStat;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Rate
implements MeasurableStat {
    private final TimeUnit unit;
    private final SampledStat stat;

    public Rate() {
        this(TimeUnit.SECONDS);
    }

    public Rate(TimeUnit unit) {
        this(unit, new SampledTotal());
    }

    public Rate(SampledStat stat) {
        this(TimeUnit.SECONDS, stat);
    }

    public Rate(TimeUnit unit, SampledStat stat) {
        this.stat = stat;
        this.unit = unit;
    }

    public String unitName() {
        return this.unit.name().substring(0, this.unit.name().length() - 2).toLowerCase();
    }

    @Override
    public void record(MetricConfig config, double value, long timeMs) {
        this.stat.record(config, value, timeMs);
    }

    @Override
    public double measure(MetricConfig config, long now) {
        double value = this.stat.measure(config, now);
        double elapsed = this.convert(now - this.stat.oldest((long)now).lastWindowMs);
        return value / elapsed;
    }

    private double convert(long time) {
        switch (this.unit) {
            case NANOSECONDS: {
                return (double)time * 1000.0 * 1000.0;
            }
            case MICROSECONDS: {
                return (double)time * 1000.0;
            }
            case MILLISECONDS: {
                return time;
            }
            case SECONDS: {
                return (double)time / 1000.0;
            }
            case MINUTES: {
                return (double)time / 60000.0;
            }
            case HOURS: {
                return (double)time / 3600000.0;
            }
            case DAYS: {
                return (double)time / 8.64E7;
            }
        }
        throw new IllegalStateException("Unknown unit: " + String.valueOf((Object)this.unit));
    }

    public static class SampledTotal
    extends SampledStat {
        public SampledTotal() {
            super(0.0);
        }

        @Override
        protected void update(SampledStat.Sample sample, MetricConfig config, double value, long timeMs) {
            sample.value += value;
        }

        @Override
        public double combine(List<SampledStat.Sample> samples, MetricConfig config, long now) {
            double total = 0.0;
            for (int i = 0; i < samples.size(); ++i) {
                total += samples.get((int)i).value;
            }
            return total;
        }
    }
}

