/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.AutoCloseableIterator;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.internals.RecordsIterator;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;

public class CheckpointIterator
implements AutoCloseableIterator<Batch<ApiMessageAndVersion>> {
    private final RecordsIterator<ApiMessageAndVersion> recordsIterator;
    private final FileRecords fileRecords;

    public CheckpointIterator(Path path) {
        try {
            this.fileRecords = FileRecords.open((File)path.toFile(), (boolean)false, (boolean)true, (int)0, (boolean)false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("unable to open checkpoint file (%s)", path), e);
        }
        this.recordsIterator = new RecordsIterator((Records)this.fileRecords, (RecordSerde)MetadataRecordSerde.INSTANCE, BufferSupplier.create(), 0x800000, true, new LogContext());
    }

    @Override
    public boolean hasNext() {
        return this.recordsIterator.hasNext();
    }

    @Override
    public Batch<ApiMessageAndVersion> next() {
        return this.recordsIterator.next();
    }

    @Override
    public void close() {
        Utils.closeQuietly(this.recordsIterator, (String)"records iterator");
        Utils.closeQuietly((AutoCloseable)this.fileRecords, (String)"file records");
    }
}

