/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.raft.KRaftSnapshotObjectUtils;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.metadata.KRaftSnapshotMetadata;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.snapshot.Snapshots;

public class CheckpointRemoteCommand {
    static final String COMMAND = "remote";
    private static final String OPTION_POSITIONAL = "option";
    private static final String OPTION_LIST = "list";
    private static final String OPTION_DOWNLOAD = "download";
    private static final String OBJECT_STORE_CONFIG_OPTION = "--object-store-config";
    private static final String LIST_SHOW_VERSIONS_OPTION = "--show-versions";
    private static final String CLUSTER_ID_OPTION = "--cluster-id";
    private static final String REPLICA_ID_OPTION = "--replica-id";
    private static final String TIMESTAMP_OPTION = "--timestamp";
    private static final String END_OFFSET_OPTION = "--end-offset";
    private static final String EPOCH_OPTION = "--epoch";
    private static final String VERSION_OPTION = "--version";
    private static final String OUT_DIRECTORY_OPTION = "--out-directory";

    static void addCommand(Subparser remote) {
        Subparsers remoteSubparsers = remote.addSubparsers().dest(OPTION_POSITIONAL).help("valid subcommands: list, download");
        Subparser listParser = remoteSubparsers.addParser(OPTION_LIST).help("List all checkpoints in object store");
        listParser.addArgument(new String[]{OBJECT_STORE_CONFIG_OPTION}).dest(OBJECT_STORE_CONFIG_OPTION).metavar(new String[]{"<object-store-config>"}).help("the path to object store config file").type((ArgumentType)Arguments.fileType().verifyCanRead()).required(true);
        listParser.addArgument(new String[]{LIST_SHOW_VERSIONS_OPTION}).dest(LIST_SHOW_VERSIONS_OPTION).metavar(new String[]{"<show-versions>"}).help("display version information for each checkpoint").type(Boolean.class).required(false).action((ArgumentAction)Arguments.storeTrue());
        Subparser getParser = remoteSubparsers.addParser(OPTION_DOWNLOAD).help("Download a checkpoint from object store");
        getParser.addArgument(new String[]{OBJECT_STORE_CONFIG_OPTION}).dest(OBJECT_STORE_CONFIG_OPTION).metavar(new String[]{"<object-store-config>"}).help("the path to object store config file").type((ArgumentType)Arguments.fileType().verifyCanRead()).required(true);
        getParser.addArgument(new String[]{CLUSTER_ID_OPTION}).dest(CLUSTER_ID_OPTION).metavar(new String[]{"<cluster-id>"}).help("the cluster id for the checkpoint").type(String.class).required(true);
        getParser.addArgument(new String[]{REPLICA_ID_OPTION}).dest(REPLICA_ID_OPTION).metavar(new String[]{"<replica-id>"}).help("the replica id for the checkpoint").type(Integer.class).required(true);
        getParser.addArgument(new String[]{END_OFFSET_OPTION}).dest(END_OFFSET_OPTION).metavar(new String[]{"<end-offset>"}).help("the end offset for the checkpoint").type(Long.class).required(true);
        getParser.addArgument(new String[]{EPOCH_OPTION}).dest(EPOCH_OPTION).metavar(new String[]{"<epoch>"}).help("the epoch for the checkpoint").type(Integer.class).required(true);
        getParser.addArgument(new String[]{TIMESTAMP_OPTION}).dest(TIMESTAMP_OPTION).metavar(new String[]{"<timestamp>"}).help("the timestamp for the checkpoint").type(Long.class).required(true);
        getParser.addArgument(new String[]{VERSION_OPTION}).dest(VERSION_OPTION).metavar(new String[]{"<version>"}).help("the version information for the checkpoint").type(String.class).required(false);
        getParser.addArgument(new String[]{OUT_DIRECTORY_OPTION}).dest(OUT_DIRECTORY_OPTION).metavar(new String[]{"<out-directory>"}).help("the path the directory where the checkpoint file will be downloaded").type((ArgumentType)Arguments.fileType().verifyIsDirectory().verifyCanWrite()).required(true);
    }

    static int execute(Namespace namespace) {
        switch (namespace.getString(OPTION_POSITIONAL)) {
            case "list": {
                return CheckpointRemoteCommand.listObjects(namespace.getString(OBJECT_STORE_CONFIG_OPTION), namespace.getBoolean(LIST_SHOW_VERSIONS_OPTION));
            }
            case "download": {
                return CheckpointRemoteCommand.getObject(namespace.getString(OBJECT_STORE_CONFIG_OPTION), namespace.getString(CLUSTER_ID_OPTION), namespace.getInt(REPLICA_ID_OPTION), namespace.getLong(TIMESTAMP_OPTION), new OffsetAndEpoch(namespace.getLong(END_OFFSET_OPTION).longValue(), namespace.getInt(EPOCH_OPTION).intValue()), namespace.getString(VERSION_OPTION) == null ? null : new VersionInformation(namespace.getString(VERSION_OPTION)), namespace.getString(OUT_DIRECTORY_OPTION));
            }
        }
        throw new IllegalArgumentException(String.format("unknown command: %s", namespace));
    }

    private static int listObjects(String objectStorePath, boolean versionInfo) {
        TierObjectStore tierObjectStore;
        try {
            tierObjectStore = TierObjectStoreUtils.objectStore((String)objectStorePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Map listOutput = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)tierObjectStore, (boolean)versionInfo, (String)tierObjectStore.keyPrefix());
        Object header = "cluster-id\treplica-id\tepoch\tend-offset\ttimestamp";
        if (versionInfo) {
            header = (String)header + "\tversion";
        }
        System.out.println((String)header);
        for (Map.Entry entry : listOutput.entrySet()) {
            if (versionInfo) {
                for (VersionInformation version : (List)entry.getValue()) {
                    System.out.printf("%s\t%d\t%d\t%d\t%d\t%s%n", ((KRaftSnapshotObject)entry.getKey()).clusterId(), ((KRaftSnapshotObject)entry.getKey()).nodeId(), ((KRaftSnapshotObject)entry.getKey()).snapshotId().epoch(), ((KRaftSnapshotObject)entry.getKey()).snapshotId().offset(), ((KRaftSnapshotObject)entry.getKey()).appendTimeStampMs(), version.getVersionId());
                }
                continue;
            }
            System.out.printf("%s\t%d\t%d\t%d\t%d%n", ((KRaftSnapshotObject)entry.getKey()).clusterId(), ((KRaftSnapshotObject)entry.getKey()).nodeId(), ((KRaftSnapshotObject)entry.getKey()).snapshotId().epoch(), ((KRaftSnapshotObject)entry.getKey()).snapshotId().offset(), ((KRaftSnapshotObject)entry.getKey()).appendTimeStampMs());
        }
        return 0;
    }

    private static int getObject(String objectStorePath, String clusterId, int nodeId, long appendTimestampMs, OffsetAndEpoch snapshotId, VersionInformation versionInfo, String outDir) {
        int n;
        block10: {
            TierObjectStore tierObjectStore;
            try {
                tierObjectStore = TierObjectStoreUtils.objectStore((String)objectStorePath);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            KRaftSnapshotMetadata metadata = new KRaftSnapshotMetadata(new KRaftSnapshotObject(Uuid.METADATA_TOPIC_ID, Topic.CLUSTER_METADATA_TOPIC_PARTITION.partition(), clusterId, nodeId, appendTimestampMs, snapshotId));
            TierObjectStoreResponse response = KRaftSnapshotObjectUtils.getObject((TierObjectStore)tierObjectStore, (KRaftSnapshotMetadata)metadata, (VersionInformation)versionInfo);
            try {
                InputStream stream = response.getInputStream();
                Path filePath = Snapshots.snapshotPath((Path)Paths.get(outDir, new String[0]), (OffsetAndEpoch)snapshotId);
                Files.copy(stream, filePath, new CopyOption[0]);
                n = 0;
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            response.close();
        }
        return n;
    }
}

