/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.Appender;
import io.confluent.kafka.tools.recovery.MetadataRecoveryPartition;
import io.confluent.kafka.tools.recovery.MetadataRecoveryState;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class DisplayCommand {
    static final String COMMAND = "display";

    static void addCommand(Subparsers subparsers) {
        Subparser display = subparsers.addParser(COMMAND).help("display the state of the log for the metadata recovery session");
        MetadataRecoveryUtils.addRecoveryDirectoryOption(display);
    }

    static int execute(Namespace namespace) {
        Path logDir = MetadataRecoveryUtils.recoveryLogDirectory(namespace);
        try (MetadataRecoveryPartition recoveryPartition = MetadataRecoveryPartition.open(logDir, new Metrics(), Time.SYSTEM);){
            MetadataEncryptorFactory encryptorFactory = MetadataEncryptorFactory.fromProperties((Properties)MetadataRecoveryUtils.loadRecoveryConfig(namespace));
            MetadataRecoveryState metadataRecoveryState = new MetadataRecoveryState(recoveryPartition, encryptorFactory);
            metadataRecoveryState.load();
            try (Iterator iterator = recoveryPartition.iterator();
                 Appender<ApiMessageAndVersion> sink = MetadataRecoveryUtils.jsonAppender(System.out);){
                while (iterator.hasNext()) {
                    Batch batch = (Batch)iterator.next();
                    if (batch.records().isEmpty()) continue;
                    sink.append(batch.records());
                }
            }
        }
        return 0;
    }
}

