/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.tools.recovery.AutoCloseableIterator;
import io.confluent.kafka.tools.recovery.CheckpointRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.kafka.common.message.KRaftVersionRecordJsonConverter;
import org.apache.kafka.common.message.SnapshotFooterRecordJsonConverter;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecordJsonConverter;
import org.apache.kafka.common.message.VotersRecordJsonConverter;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.ControlRecord;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class JsonIterator
implements AutoCloseableIterator<Batch<ApiMessageAndVersion>> {
    ObjectMapper mapper;
    JsonFactory factory;
    final JsonParser parser;
    private Optional<Batch<ApiMessageAndVersion>> nextValue = Optional.empty();

    public JsonIterator(Optional<Path> path, Optional<InputStream> stream) {
        this.mapper = new ObjectMapper();
        this.factory = this.mapper.getFactory();
        try {
            if (path.isPresent()) {
                this.parser = this.factory.createParser(path.get().toFile());
            } else if (stream.isPresent()) {
                this.parser = this.factory.createParser(stream.get());
            } else {
                throw new IllegalStateException("path or stream should have been set");
            }
            if (!JsonToken.START_ARRAY.equals((Object)this.parser.nextToken())) {
                throw new IllegalStateException(String.format("expected %s but got %s at %s", JsonToken.START_ARRAY, this.parser.currentToken(), this.parser.currentLocation()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("error in json parser", e);
        }
    }

    private Optional<Batch<ApiMessageAndVersion>> nextValue() {
        try {
            if (JsonToken.END_ARRAY.equals((Object)this.parser.currentToken())) {
                return Optional.empty();
            }
            JsonToken token = this.parser.nextToken();
            if (JsonToken.START_OBJECT.equals((Object)token)) {
                CheckpointRecord record = (CheckpointRecord)this.mapper.readValue(this.parser, CheckpointRecord.class);
                if (record.isControl()) {
                    return Optional.of(JsonIterator.createControlBatch(record));
                }
                return Optional.of(JsonIterator.createDataBatch(record));
            }
            if (JsonToken.END_ARRAY.equals((Object)token)) {
                return Optional.empty();
            }
            throw new IllegalStateException(String.format("found unknown token %s at %s", this.parser.currentToken(), this.parser.currentLocation()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("error in json parser at %s", this.parser.currentLocation()), e);
        }
    }

    private static Batch<ApiMessageAndVersion> createDataBatch(CheckpointRecord record) {
        List<ApiMessageAndVersion> data = Collections.singletonList(new ApiMessageAndVersion(MetadataJsonConverters.readJson((JsonNode)record.message(), (short)record.apiKey(), (short)record.version()), record.version()));
        return Batch.data((long)0L, (int)0, (long)0L, (int)0, data);
    }

    private static Batch<ApiMessageAndVersion> createControlBatch(CheckpointRecord record) {
        SnapshotHeaderRecord message;
        ControlRecordType recordType = ControlRecordType.fromTypeId((short)record.apiKey());
        if (recordType == ControlRecordType.SNAPSHOT_HEADER) {
            message = SnapshotHeaderRecordJsonConverter.read((JsonNode)record.message(), (short)record.version());
        } else if (recordType == ControlRecordType.SNAPSHOT_FOOTER) {
            message = SnapshotFooterRecordJsonConverter.read((JsonNode)record.message(), (short)record.version());
        } else if (recordType == ControlRecordType.KRAFT_VOTERS) {
            message = VotersRecordJsonConverter.read((JsonNode)record.message(), (short)record.version());
        } else if (recordType == ControlRecordType.KRAFT_VERSION) {
            message = KRaftVersionRecordJsonConverter.read((JsonNode)record.message(), (short)record.version());
        } else {
            throw new IllegalArgumentException(String.format("control record type is unknown: %s", recordType));
        }
        List<ControlRecord> controlRecords = Collections.singletonList(ControlRecord.of((ApiMessage)message));
        return Batch.control((long)0L, (int)0, (long)0L, (int)0, controlRecords);
    }

    @Override
    public boolean hasNext() {
        if (!this.nextValue.isPresent()) {
            this.nextValue = this.nextValue();
        }
        return this.nextValue.isPresent();
    }

    @Override
    public Batch<ApiMessageAndVersion> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("json iterator doesn't have any more elements");
        }
        Batch<ApiMessageAndVersion> value = this.nextValue.get();
        this.nextValue = Optional.empty();
        return value;
    }

    @Override
    public void close() {
        Utils.closeQuietly((AutoCloseable)this.parser, (String)"json parser");
    }
}

