/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.MetadataRecoveryPartition;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Supplier;
import kafka.raft.KafkaMetadataLog;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.MetadataLogConfig;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;

public class LockedMetadataLog
implements ReplicatedLog,
AutoCloseable {
    private final ReplicatedLog log;
    private final FileLock lock;
    private final Scheduler scheduler;

    private LockedMetadataLog(ReplicatedLog log, FileLock lock, Scheduler scheduler) {
        this.log = log;
        this.lock = lock;
        this.scheduler = scheduler;
    }

    public LogAppendInfo appendAsLeader(Records records, int epoch) {
        return this.log.appendAsLeader(records, epoch);
    }

    public LogAppendInfo appendAsFollower(Records records, int epoch) {
        return this.log.appendAsFollower(records, epoch);
    }

    public LogFetchInfo read(long startOffsetInclusive, Isolation isolation) {
        return this.log.read(startOffsetInclusive, isolation);
    }

    public int lastFetchedEpoch() {
        return this.log.lastFetchedEpoch();
    }

    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        return this.log.endOffsetForEpoch(epoch);
    }

    public LogOffsetMetadata endOffset() {
        return this.log.endOffset();
    }

    public LogOffsetMetadata highWatermark() {
        return this.log.highWatermark();
    }

    public long startOffset() {
        return this.log.startOffset();
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log.initializeLeaderEpoch(epoch);
    }

    public void truncateTo(long offset) {
        this.log.truncateTo(offset);
    }

    public boolean truncateToLatestSnapshot() {
        return this.log.truncateToLatestSnapshot();
    }

    public void updateHighWatermark(LogOffsetMetadata offsetMetadata) {
        this.log.updateHighWatermark(offsetMetadata);
    }

    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        return this.log.deleteBeforeSnapshot(snapshotId);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.log.flush(forceFlushActiveSegment);
    }

    public boolean maybeClean() {
        return this.log.maybeClean();
    }

    public TopicPartition topicPartition() {
        return this.log.topicPartition();
    }

    public Uuid topicId() {
        return this.log.topicId();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        return this.log.createNewSnapshot(snapshotId);
    }

    public Optional<RawSnapshotWriter> createNewSnapshotUnchecked(OffsetAndEpoch snapshotId) {
        return this.log.createNewSnapshotUnchecked(snapshotId);
    }

    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        return this.log.readSnapshot(snapshotId);
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        return this.log.latestSnapshot();
    }

    public Optional<RawSnapshotReader> latestSnapshotAtOrBelow(long maxOffset) {
        return this.log.latestSnapshotAtOrBelow(maxOffset);
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        return this.log.latestSnapshotId();
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        return this.log.earliestSnapshotId();
    }

    public SortedSet<OffsetAndEpoch> snapshotIds() {
        return this.log.snapshotIds();
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        this.log.onSnapshotFrozen(snapshotId);
    }

    @Override
    public void close() {
        try {
            this.log.close();
            this.lock.unlock();
            this.scheduler.shutdown();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Supplier<Map<Integer, Long>> leaderEpochChainSupplier() {
        return null;
    }

    public static LockedMetadataLog openMetadataLog(Path metadataLogDir) {
        Path clusterMetadataPartition = metadataLogDir.resolve(MetadataRecoveryUtils.LOG_DIR);
        if (!Files.exists(clusterMetadataPartition, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Directory %s doesn't exist", clusterMetadataPartition));
        }
        FileLock lock = MetadataRecoveryUtils.setupLogDirFileLock(metadataLogDir);
        KafkaScheduler scheduler = new KafkaScheduler(1, true, "open-metadata-log-scheduler", false);
        KafkaMetadataLog log = KafkaMetadataLog.apply((TopicPartition)Topic.CLUSTER_METADATA_TOPIC_PARTITION, (Uuid)Uuid.METADATA_TOPIC_ID, (File)clusterMetadataPartition.toFile(), (Time)Time.SYSTEM, (Metrics)new Metrics(), (Scheduler)scheduler, (MetadataLogConfig)MetadataRecoveryPartition.metadataLogConfig(), ignore -> {}, ignore -> {}, (int)-1);
        return new LockedMetadataLog((ReplicatedLog)log, lock, (Scheduler)scheduler);
    }
}

