/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.CheckpointIterator;
import io.confluent.kafka.tools.recovery.LockedMetadataLog;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import io.confluent.kafka.tools.recovery.OffboardTranslator;
import io.confluent.kafka.tools.recovery.OffboardTranslatorVersions;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.ControlRecord;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.MergedLogUtils;

public final class OffboardCommand {
    static long LAST_TIMESTAMP_NS = Time.SYSTEM.nanoseconds();
    static final String COMMAND = "offboard";
    private static final String OUTPUT_DIR_OPTION = "--output-dir";
    private static final String DRY_RUN_OPTION = "--dry-run";
    private static final String CHECKPOINT_OPTION = "--checkpoint";
    private static final String GET_LATEST_OPTION = "--get-latest";

    static void addCommand(Subparsers subparsers) {
        Subparser offboardCmd = subparsers.addParser(COMMAND).help("Offboard CE-Kafka metadata snapshot to Apache Kafka");
        offboardCmd.addArgument(new String[]{CHECKPOINT_OPTION}).dest(CHECKPOINT_OPTION).metavar(new String[]{"<path-to-checkpoint-file>"}).help("Path to a specific checkpoint file to offboard").type((ArgumentType)Arguments.fileType().verifyIsFile().verifyCanRead()).required(false);
        offboardCmd.addArgument(new String[]{GET_LATEST_OPTION}).dest(GET_LATEST_OPTION).metavar(new String[]{"<path-to-metadata-dir>"}).help("Path to the metadata directory containing snapshots").type((ArgumentType)Arguments.fileType().verifyIsDirectory().verifyCanRead()).required(false);
        offboardCmd.addArgument(new String[]{OUTPUT_DIR_OPTION}).dest(OUTPUT_DIR_OPTION).metavar(new String[]{"<path-to-output-dir>"}).help("Path to the output directory for offboarded snapshots").type((ArgumentType)Arguments.fileType().verifyCanCreate()).required(false);
        offboardCmd.addArgument(new String[]{DRY_RUN_OPTION}).dest(DRY_RUN_OPTION).help("Shows what records will be changed without writing them to disk").action((ArgumentAction)Arguments.storeTrue()).required(false);
    }

    static int execute(Namespace namespace) throws IOException {
        Path metadataDir;
        Path snapshotPath;
        String checkpointPath = namespace.getString(CHECKPOINT_OPTION);
        String metadataDirPath = namespace.getString(GET_LATEST_OPTION);
        boolean dryRun = namespace.getBoolean(DRY_RUN_OPTION);
        if (checkpointPath == null && metadataDirPath == null || checkpointPath != null && metadataDirPath != null) {
            throw new RuntimeException("Either --checkpoint or --get-latest must be specified");
        }
        if (checkpointPath != null) {
            snapshotPath = Paths.get(checkpointPath, new String[0]).toAbsolutePath();
            metadataDir = snapshotPath.getParent().getParent();
        } else {
            metadataDir = Paths.get(metadataDirPath, new String[0]).toAbsolutePath();
            snapshotPath = OffboardCommand.findLatestSnapshotFromDirectory(metadataDir);
        }
        Path outputDir = null;
        if (!dryRun) {
            outputDir = namespace.getString(OUTPUT_DIR_OPTION) != null ? Paths.get(namespace.getString(OUTPUT_DIR_OPTION), new String[0]).toAbsolutePath() : metadataDir.resolve("Offboarded");
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        LockedMetadataLog lock = LockedMetadataLog.openMetadataLog(metadataDir);
        try {
            OffboardTranslator translator;
            Optional<Object> maybeMetadataVersion = Optional.empty();
            Optional<Object> maybeKraftVersion = Optional.empty();
            Optional<VoterSet> maybeVoterSet = Optional.empty();
            try (RecordsSnapshotReader<ApiMessageAndVersion> snapshotReader = MetadataRecoveryUtils.openSnapshotReader((RawSnapshotReader)MetadataRecoveryUtils.openFileRawSnapshotReader(snapshotPath));){
                while (snapshotReader.hasNext() && (maybeMetadataVersion.isEmpty() || maybeKraftVersion.isEmpty() || maybeVoterSet.isEmpty())) {
                    ApiMessage apiMessage;
                    Batch batch = snapshotReader.next();
                    for (ControlRecord controlRecord : batch.controlRecords()) {
                        apiMessage = controlRecord.message();
                        if (apiMessage instanceof KRaftVersionRecord) {
                            KRaftVersionRecord kraftVersionRecord = (KRaftVersionRecord)apiMessage;
                            maybeKraftVersion = Optional.of(KRaftVersion.fromFeatureLevel((short)kraftVersionRecord.kRaftVersion()));
                        }
                        if (!((apiMessage = controlRecord.message()) instanceof VotersRecord)) continue;
                        VotersRecord votersRecord = (VotersRecord)apiMessage;
                        maybeVoterSet = Optional.of(VoterSet.fromVotersRecord((VotersRecord)votersRecord));
                    }
                    for (ApiMessageAndVersion record : batch.records()) {
                        FeatureLevelRecord featureLevelRecord;
                        apiMessage = record.message();
                        if (!(apiMessage instanceof FeatureLevelRecord) || !(featureLevelRecord = (FeatureLevelRecord)apiMessage).name().equals("confluent.metadata.version")) continue;
                        maybeMetadataVersion = Optional.of(MetadataVersion.fromConfluentFeatureLevel((short)featureLevelRecord.featureLevel()));
                    }
                }
            }
            KRaftVersion kraftVersion = (KRaftVersion)maybeKraftVersion.orElseThrow(() -> new RuntimeException("No KraftVersion found"));
            MetadataVersion metadataVersion = (MetadataVersion)maybeMetadataVersion.orElseThrow(() -> new RuntimeException("No MetadataVersion found"));
            try {
                translator = OffboardTranslatorVersions.createFromMetadataVersion(metadataVersion);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unsupported metadata version for offboarding: " + String.valueOf(metadataVersion), e);
            }
            Optional snapshotPathOpt = Snapshots.parse((Path)snapshotPath);
            if (snapshotPathOpt.isEmpty()) {
                throw new RuntimeException("Invalid snapshot path: " + String.valueOf(snapshotPath));
            }
            OffsetAndEpoch snapshotId = ((SnapshotPath)snapshotPathOpt.get()).snapshotId();
            if (dryRun) {
                OffboardCommand.dryRunOffboardSnapshot(snapshotPath, translator);
            } else {
                Path offboardedSnapshotPath = outputDir.resolve(snapshotPath.getFileName());
                OffboardCommand.offboardSnapshot(snapshotPath, offboardedSnapshotPath, translator, kraftVersion, snapshotId, maybeVoterSet);
                OffboardCommand.generateBootstrapCheckpoint(outputDir, metadataVersion, kraftVersion);
                System.out.println("AK compatible Checkpoint file location:\t" + String.valueOf(offboardedSnapshotPath.toAbsolutePath()));
                System.out.println("Bootstrap file location:\t" + String.valueOf(outputDir.resolve("bootstrap.checkpoint").toAbsolutePath()));
                System.out.println("kraft.version:\t" + kraftVersion.featureLevel());
                System.out.println("Apache metadata.version:\t" + metadataVersion.apacheRelease());
            }
            int n = 0;
            if (lock != null) {
                lock.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error during offboarding: " + e.getMessage(), e);
            }
        }
    }

    private static Path findLatestSnapshotFromDirectory(Path metadataDir) throws IOException {
        String clusterMetadataDirName = MergedLogUtils.logDirName((TopicPartition)new TopicPartition("__cluster_metadata", Topic.CLUSTER_METADATA_TOPIC_PARTITION.partition()));
        Path clusterMetadataDir = metadataDir.getFileName().toString().equals(clusterMetadataDirName) ? metadataDir : metadataDir.resolve(clusterMetadataDirName);
        if (!Files.exists(clusterMetadataDir, new LinkOption[0])) {
            throw new RuntimeException("Metadata log directory not found at: " + String.valueOf(clusterMetadataDir));
        }
        Optional<SnapshotPath> latestSnapshot = OffboardCommand.findLatestSnapshot(clusterMetadataDir);
        if (latestSnapshot.isEmpty()) {
            throw new RuntimeException("No snapshot found in metadata directory");
        }
        SnapshotPath snapshotPath = latestSnapshot.get();
        System.out.println("Found latest snapshot: " + String.valueOf(snapshotPath.snapshotId()));
        return snapshotPath.path();
    }

    private static Optional<SnapshotPath> findLatestSnapshot(Path logDir) throws IOException {
        SnapshotPath latestSnapshot = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(logDir);){
            for (Path path : stream) {
                Optional parsed = Snapshots.parse((Path)path);
                if (!parsed.isPresent() || ((SnapshotPath)parsed.get()).partial() || ((SnapshotPath)parsed.get()).deleted() || latestSnapshot != null && ((SnapshotPath)parsed.get()).snapshotId().offset() <= latestSnapshot.snapshotId().offset()) continue;
                latestSnapshot = (SnapshotPath)parsed.get();
            }
        }
        return Optional.ofNullable(latestSnapshot);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void offboardSnapshot(Path inputSnapshot, Path outputSnapshot, OffboardTranslator translator, KRaftVersion kraftVersion, OffsetAndEpoch originalSnapshotId, Optional<VoterSet> maybeVoterSet) throws IOException {
        try {
            appender = MetadataRecoveryUtils.checkpointFreezableAppender(originalSnapshotId.offset(), originalSnapshotId.epoch(), OffboardCommand.LAST_TIMESTAMP_NS, outputSnapshot.getParent(), kraftVersion, maybeVoterSet);
            checkpointIterator = new CheckpointIterator(inputSnapshot);
            while (true) {
                if (!checkpointIterator.hasNext()) ** GOTO lbl14
                batch = checkpointIterator.next();
                var9_13 = batch.records().iterator();
                ** GOTO lbl20
                break;
            }
            {
                finally {
                    checkpointIterator.close();
                }
lbl14:
                // 1 sources

                appender.freeze();
                return;
                finally {
                    if (appender != null) {
                        appender.close();
                    }
                }
lbl20:
                // 1 sources

                while (true) lbl-1000:
                // 4 sources

                {
                    if (!var9_13.hasNext()) ** continue;
                    record = (ApiMessageAndVersion)var9_13.next();
                    msg = record.message();
                    type = MetadataRecordType.fromId((short)msg.apiKey());
                    try {
                        result = translator.translate(type, msg, record.version());
                        if (result.changed()) {
                            appender.append(Collections.singletonList(new ApiMessageAndVersion(result.record(), record.version())));
                            ** continue;
                        }
                        if (!result.unchanged()) ** continue;
                        appender.append(Collections.singletonList(record));
                        continue;
                    }
                    catch (UnsupportedOperationException e) {}
                    throw new RuntimeException("Translation not implemented for record type " + String.valueOf(type) + ". Shutting down.", e);
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to offboard snapshot: " + e.getMessage(), e);
        }
        {
            ** while (true)
        }
    }

    private static void generateBootstrapCheckpoint(Path outputDir, MetadataVersion metadataVersion, KRaftVersion kraftVersion) throws IOException {
        List<ApiMessageAndVersion> records = List.of(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("kraft.version").setFeatureLevel(kraftVersion.featureLevel()), 0), new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.apacheFeatureLevel()), 0));
        Path outputPath = outputDir.resolve("bootstrap.checkpoint");
        BootstrapMetadata bm = BootstrapMetadata.fromRecords(records, (String)outputPath.toString());
        BootstrapDirectory bd = new BootstrapDirectory(outputDir.toAbsolutePath().toString());
        bd.writeBinaryFile(bm);
    }

    private static void dryRunOffboardSnapshot(Path inputSnapshot, OffboardTranslator translator) {
        System.out.println("=== DRY RUN: Processing snapshot records ===");
        try (CheckpointIterator checkpointIterator = new CheckpointIterator(inputSnapshot);){
            while (checkpointIterator.hasNext()) {
                Batch<ApiMessageAndVersion> batch = checkpointIterator.next();
                for (ApiMessageAndVersion record : batch.records()) {
                    ApiMessage msg = record.message();
                    MetadataRecordType type = MetadataRecordType.fromId((short)msg.apiKey());
                    try {
                        OffboardTranslator.Result result = translator.translate(type, msg, record.version());
                        if (result.changed()) {
                            System.out.println("\nCHANGED: " + String.valueOf(type));
                            System.out.println("\nFROM: " + String.valueOf(msg));
                            System.out.println("\nTO: " + String.valueOf(result.record()));
                            continue;
                        }
                        if (result.unchanged()) {
                            System.out.println("\nUNCHANGED: " + String.valueOf(type));
                            continue;
                        }
                        if (!result.omitted()) continue;
                        System.out.println("\nOMITTED: " + String.valueOf(type));
                    }
                    catch (UnsupportedOperationException e) {
                        System.out.println("\nWARNING:Translation not implemented for record type " + String.valueOf(type) + ", and would fail.");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process snapshot for dry run: " + e.getMessage(), e);
        }
    }
}

