/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import java.util.Set;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.MetadataVersion;

public abstract class OffboardTranslator {
    final MetadataVersion version;
    final Set<MetadataRecordType> confluentOnlyRecords;
    final Set<MetadataRecordType> unchangedRecords;
    static final Set<MetadataRecordType> DEFAULT_CONFLUENT_ONLY_RECORDS = Set.of(MetadataRecordType.CLUSTER_LINK_RECORD, MetadataRecordType.CLUSTER_LINK_CHANGE_RECORD, MetadataRecordType.REMOVE_CLUSTER_LINK_RECORD, MetadataRecordType.MIRROR_TOPIC_CHANGE_RECORD, MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD, MetadataRecordType.ENCRYPTED_ENVELOPE_RECORD, MetadataRecordType.INSTALL_METADATA_ENCRYPTOR_RECORD, MetadataRecordType.CELL_RECORD, MetadataRecordType.REMOVE_CELL_RECORD, MetadataRecordType.MIRROR_TOPIC_RECORD, MetadataRecordType.TENANT_RECORD, MetadataRecordType.REMOVE_TENANT_RECORD, MetadataRecordType.CELL_MIGRATION_RECORD, MetadataRecordType.TRACE_CONTEXT_RECORD, MetadataRecordType.NO_TRACE_CONTEXT_RECORD, MetadataRecordType.CONFLUENT_KEY_VALUE_STREAM_CHANGE_RECORD, MetadataRecordType.CONFLUENT_KEY_VALUE_STREAM_ENTRY_RECORD, MetadataRecordType.CONFLUENT_KEY_VALUE_STREAM_TOPIC_RECORD);
    static final Set<MetadataRecordType> DEFAULT_UNCHANGED_RECORDS = Set.of(MetadataRecordType.ABORT_TRANSACTION_RECORD, MetadataRecordType.BEGIN_TRANSACTION_RECORD, MetadataRecordType.CLEAR_ELR_RECORD, MetadataRecordType.CLIENT_QUOTA_RECORD, MetadataRecordType.DELEGATION_TOKEN_RECORD, MetadataRecordType.END_TRANSACTION_RECORD, MetadataRecordType.FENCE_BROKER_RECORD, MetadataRecordType.NO_OP_RECORD, MetadataRecordType.PRODUCER_IDS_RECORD, MetadataRecordType.REMOVE_ACCESS_CONTROL_ENTRY_RECORD, MetadataRecordType.REMOVE_DELEGATION_TOKEN_RECORD, MetadataRecordType.REMOVE_TOPIC_RECORD, MetadataRecordType.REMOVE_USER_SCRAM_CREDENTIAL_RECORD, MetadataRecordType.UNFENCE_BROKER_RECORD, MetadataRecordType.UNREGISTER_BROKER_RECORD, MetadataRecordType.USER_SCRAM_CREDENTIAL_RECORD, MetadataRecordType.ZK_MIGRATION_STATE_RECORD);

    OffboardTranslator(MetadataVersion version, Set<MetadataRecordType> confluentOnlyRecords, Set<MetadataRecordType> unchangedRecords) {
        this.version = version;
        this.confluentOnlyRecords = confluentOnlyRecords;
        this.unchangedRecords = unchangedRecords;
    }

    final MetadataVersion supportedVersion() {
        return this.version;
    }

    abstract Result translateSpecificCases(MetadataRecordType var1, ApiMessage var2, short var3);

    protected final Result translate(MetadataRecordType recordType, ApiMessage record, short version) {
        if (this.confluentOnlyRecords.contains(recordType)) {
            return Result.OMITTED;
        }
        if (this.unchangedRecords.contains(recordType)) {
            return Result.UNCHANGED;
        }
        return this.translateSpecificCases(recordType, record, version);
    }

    public record Result(ApiMessage record, Outcome outcome) {
        public static final Result OMITTED = new Result(null, Outcome.OMIT);
        public static final Result UNCHANGED = new Result(null, Outcome.UNCHANGED);
        public static final Result CHANGED = new Result(null, Outcome.CHANGED);

        public boolean omitted() {
            return this.outcome == Outcome.OMIT;
        }

        public boolean changed() {
            return this.outcome == Outcome.CHANGED;
        }

        public boolean unchanged() {
            return this.outcome == Outcome.UNCHANGED;
        }

        public static Result of(ApiMessage result) {
            return new Result(result, Outcome.CHANGED);
        }
    }

    public static enum Outcome {
        OMIT,
        UNCHANGED,
        CHANGED;

    }
}

