/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.OffboardTranslator;
import java.util.ArrayList;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.metadata.TopicType;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.server.common.MetadataVersion;

public class OffboardTranslatorCommon {
    static OffboardTranslator.Result featureLevelRecord(MetadataVersion metadataVersion, FeatureLevelRecord record) {
        FeatureLevelRecord newRecord = record.duplicate();
        if (record.name().equals("confluent.metadata.version")) {
            newRecord.setName("metadata.version");
            newRecord.setFeatureLevel(metadataVersion.apacheFeatureLevel());
        }
        return OffboardTranslator.Result.of((ApiMessage)newRecord);
    }

    static OffboardTranslator.Result registerBrokerRecord(MetadataVersion metadataVersion, RegisterBrokerRecord record) {
        RegisterBrokerRecord newRecord = record.duplicate();
        if (record.degradedComponents() != null && !record.degradedComponents().isEmpty()) {
            newRecord.setDegradedComponents(new ArrayList());
        }
        if (record.metadataEncryptors() != null && !record.metadataEncryptors().isEmpty()) {
            newRecord.setMetadataEncryptors(null);
        }
        RegisterBrokerRecord.BrokerFeatureCollection features = record.features();
        RegisterBrokerRecord.BrokerFeatureCollection newFeatures = new RegisterBrokerRecord.BrokerFeatureCollection();
        for (RegisterBrokerRecord.BrokerFeature feature : features) {
            RegisterBrokerRecord.BrokerFeature newFeature = feature.duplicate();
            if ("confluent.metadata.version".equals(feature.name())) {
                newFeature.setName("metadata.version");
                newFeature.setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.apacheFeatureLevel());
                newFeature.setMaxSupportedVersion(metadataVersion.apacheFeatureLevel());
            }
            newFeatures.add((ImplicitLinkedHashCollection.Element)newFeature);
        }
        newRecord.setFeatures(newFeatures);
        return OffboardTranslator.Result.of((ApiMessage)newRecord);
    }

    static OffboardTranslator.Result topicRecord(TopicRecord record) {
        TopicRecord newRecord = record.duplicate();
        newRecord.setTopicType(TopicType.STANDARD.id());
        return OffboardTranslator.Result.of((ApiMessage)newRecord);
    }

    static OffboardTranslator.Result partitionRecord(PartitionRecord record) {
        PartitionRecord newRecord = record.duplicate();
        ArrayList<Integer> mergedReplicas = null;
        ArrayList<Integer> mergedIsr = null;
        if (record.observers() != null && !record.observers().isEmpty()) {
            if (record.replicas() != null) {
                mergedReplicas = new ArrayList<Integer>(record.replicas());
            }
            if (mergedReplicas != null) {
                for (Integer observer : record.observers()) {
                    if (mergedReplicas.contains(observer)) continue;
                    mergedReplicas.add(observer);
                }
            }
            if (record.isr() != null) {
                mergedIsr = new ArrayList<Integer>(record.isr());
                for (Integer observer : record.observers()) {
                    if (mergedIsr.contains(observer)) continue;
                    mergedIsr.add(observer);
                }
            }
        }
        if (mergedReplicas != null) {
            newRecord.setReplicas(mergedReplicas);
        } else if (record.replicas() != null) {
            newRecord.setReplicas(record.replicas());
        }
        if (mergedIsr != null) {
            newRecord.setIsr(mergedIsr);
        } else if (record.isr() != null) {
            newRecord.setIsr(record.isr());
        }
        if (record.addingReplicas() != null) {
            ArrayList<Integer> addingReplicas = new ArrayList<Integer>(record.addingReplicas());
            if (record.addingObservers() != null) {
                for (Integer addingObserver : record.addingObservers()) {
                    if (addingReplicas.contains(addingObserver)) continue;
                    addingReplicas.add(addingObserver);
                }
            }
            newRecord.setAddingReplicas(addingReplicas);
        } else if (record.addingObservers() != null) {
            newRecord.setAddingReplicas(record.addingObservers());
        }
        return OffboardTranslator.Result.of((ApiMessage)newRecord);
    }

    static OffboardTranslator.Result configRecord(ConfigRecord record) {
        if (ConfigResource.Type.forId((byte)record.resourceType()) == ConfigResource.Type.CLUSTER_LINK) {
            return OffboardTranslator.Result.OMITTED;
        }
        return OffboardTranslator.Result.of((ApiMessage)record.duplicate());
    }

    static OffboardTranslator.Result registerControllerRecord(RegisterControllerRecord record) {
        RegisterControllerRecord newRecord = record.duplicate();
        RegisterControllerRecord.ControllerFeatureCollection features = record.features();
        RegisterControllerRecord.ControllerFeatureCollection newFeatures = new RegisterControllerRecord.ControllerFeatureCollection();
        if (record.metadataEncryptors() != null && !record.metadataEncryptors().isEmpty()) {
            newRecord.setMetadataEncryptors(null);
        }
        for (RegisterControllerRecord.ControllerFeature feature : features) {
            RegisterControllerRecord.ControllerFeature newFeature = feature.duplicate();
            if ("confluent.metadata.version".equals(feature.name())) {
                newFeature.setName("metadata.version");
                newFeature.setMinSupportedVersion(MetadataVersion.MINIMUM_VERSION.apacheFeatureLevel());
                newFeature.setMaxSupportedVersion(MetadataVersion.latestProduction().apacheFeatureLevel());
            }
            newFeatures.add((ImplicitLinkedHashCollection.Element)newFeature);
        }
        newRecord.setFeatures(newFeatures);
        return OffboardTranslator.Result.of((ApiMessage)newRecord);
    }

    static OffboardTranslator.Result accessControlEntryRecord(AccessControlEntryRecord record) {
        ConfluentStandardAcl confluentAcl = ConfluentStandardAcl.fromRecord((AccessControlEntryRecord)record);
        StandardAcl standardAcl = confluentAcl.standardAcl();
        AccessControlEntryRecord newRecord = new AccessControlEntryRecord().setId(record.id()).setResourceType(standardAcl.resourceType().code()).setResourceName(standardAcl.resourceName()).setPatternType(standardAcl.patternType().code()).setPrincipal(standardAcl.principal()).setHost(standardAcl.host()).setOperation(standardAcl.operation().code()).setPermissionType(standardAcl.permissionType().code()).setClusterLinkId(record.clusterLinkId()).setAclState(record.aclState());
        return OffboardTranslator.Result.of((ApiMessage)newRecord);
    }
}

