/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.OffboardTranslator;
import io.confluent.kafka.tools.recovery.OffboardTranslatorCommon;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.MetadataVersion;

public class OffboardTranslatorVersions {
    static OffboardTranslator createFromMetadataVersion(MetadataVersion version) {
        return switch (version) {
            case MetadataVersion.IBP_4_1_IV0A -> new TranslatorIBP_4_1(MetadataVersion.IBP_4_1_IV0A);
            case MetadataVersion.IBP_4_1_IV0B -> new TranslatorIBP_4_1(MetadataVersion.IBP_4_1_IV0B);
            case MetadataVersion.IBP_4_1_IV1A -> new TranslatorIBP_4_1(MetadataVersion.IBP_4_1_IV1A);
            case MetadataVersion.IBP_4_2_IV0A -> new TranslatorIBP_4_2(MetadataVersion.IBP_4_2_IV0A);
            case MetadataVersion.IBP_4_2_IV1A -> new TranslatorIBP_4_2(MetadataVersion.IBP_4_2_IV1A);
            default -> throw new IllegalArgumentException("Offboarding tool does not support metadata-version: " + String.valueOf(version));
        };
    }

    static class TranslatorIBP_4_1
    extends OffboardTranslator {
        TranslatorIBP_4_1(MetadataVersion version) {
            super(version, DEFAULT_CONFLUENT_ONLY_RECORDS, DEFAULT_UNCHANGED_RECORDS);
        }

        @Override
        OffboardTranslator.Result translateSpecificCases(MetadataRecordType recordType, ApiMessage record, short version) {
            return switch (recordType) {
                case MetadataRecordType.FEATURE_LEVEL_RECORD -> OffboardTranslatorCommon.featureLevelRecord(this.version, (FeatureLevelRecord)record);
                case MetadataRecordType.REGISTER_BROKER_RECORD -> OffboardTranslatorCommon.registerBrokerRecord(this.version, (RegisterBrokerRecord)record);
                case MetadataRecordType.TOPIC_RECORD -> OffboardTranslatorCommon.topicRecord((TopicRecord)record);
                case MetadataRecordType.PARTITION_RECORD -> OffboardTranslatorCommon.partitionRecord((PartitionRecord)record);
                case MetadataRecordType.CONFIG_RECORD -> OffboardTranslatorCommon.configRecord((ConfigRecord)record);
                case MetadataRecordType.REGISTER_CONTROLLER_RECORD -> OffboardTranslatorCommon.registerControllerRecord((RegisterControllerRecord)record);
                case MetadataRecordType.ACCESS_CONTROL_ENTRY_RECORD -> OffboardTranslatorCommon.accessControlEntryRecord((AccessControlEntryRecord)record);
                default -> throw new IllegalStateException("Unknown metadata record type " + String.valueOf(recordType));
            };
        }
    }

    static class TranslatorIBP_4_2
    extends OffboardTranslator {
        TranslatorIBP_4_2(MetadataVersion version) {
            super(version, DEFAULT_CONFLUENT_ONLY_RECORDS, DEFAULT_UNCHANGED_RECORDS);
        }

        @Override
        OffboardTranslator.Result translateSpecificCases(MetadataRecordType recordType, ApiMessage record, short version) {
            return switch (recordType) {
                case MetadataRecordType.FEATURE_LEVEL_RECORD -> OffboardTranslatorCommon.featureLevelRecord(this.version, (FeatureLevelRecord)record);
                case MetadataRecordType.REGISTER_BROKER_RECORD -> OffboardTranslatorCommon.registerBrokerRecord(this.version, (RegisterBrokerRecord)record);
                case MetadataRecordType.TOPIC_RECORD -> OffboardTranslatorCommon.topicRecord((TopicRecord)record);
                case MetadataRecordType.PARTITION_RECORD -> OffboardTranslatorCommon.partitionRecord((PartitionRecord)record);
                case MetadataRecordType.CONFIG_RECORD -> OffboardTranslatorCommon.configRecord((ConfigRecord)record);
                case MetadataRecordType.REGISTER_CONTROLLER_RECORD -> OffboardTranslatorCommon.registerControllerRecord((RegisterControllerRecord)record);
                case MetadataRecordType.ACCESS_CONTROL_ENTRY_RECORD -> OffboardTranslatorCommon.accessControlEntryRecord((AccessControlEntryRecord)record);
                default -> throw new IllegalStateException("Unknown metadata record type " + String.valueOf(recordType));
            };
        }
    }
}

