/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.LockedMetadataLog;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.raft.DefaultExternalKRaftMetrics;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.ExternalKRaftMetrics;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.kafka.raft.internals.KRaftControlRecordStateMachine;
import org.apache.kafka.raft.internals.KafkaRaftMetrics;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.tools.MetadataQuorumCommand;
import org.apache.kafka.tools.TerseException;
import scala.Option;

final class ReconfigForceStandaloneCommand {
    static final String COMMAND = "force-standalone";
    private static final String PATH_TO_CONTROLLER_PROPERTIES_OPTION = "--config";

    ReconfigForceStandaloneCommand() {
    }

    static void addCommand(Subparser forceStandalone) {
        forceStandalone.addArgument(new String[]{PATH_TO_CONTROLLER_PROPERTIES_OPTION}).dest(PATH_TO_CONTROLLER_PROPERTIES_OPTION).required(true).metavar(new String[]{"<path-controller-properties>"}).help("path to the controller properties").type((ArgumentType)Arguments.fileType().verifyCanRead());
    }

    static int execute(Namespace namespace) throws TerseException {
        ReconfigForceStandaloneCommand.forceStandalone(namespace);
        return 0;
    }

    public static void forceStandalone(Namespace namespace) throws TerseException {
        Uuid controllerDirectoryId;
        Path config = Paths.get(namespace.getString(PATH_TO_CONTROLLER_PROPERTIES_OPTION), new String[0]);
        Properties controllerProperties = ReconfigForceStandaloneCommand.getProperties(config);
        String metadataDirectory = MetadataQuorumCommand.getMetadataDirectory(controllerProperties);
        Path metadataDirectoryPath = Path.of(metadataDirectory, new String[0]);
        int controllerId = MetadataQuorumCommand.getControllerId(controllerProperties);
        try {
            controllerDirectoryId = MetadataQuorumCommand.getMetadataDirectoryId(metadataDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (LockedMetadataLog lockedLog = LockedMetadataLog.openMetadataLog(metadataDirectoryPath);){
            KRaftControlRecordStateMachine partitionState = new KRaftControlRecordStateMachine(VoterSet.empty(), (ReplicatedLog)lockedLog, (RecordSerde)MetadataRecordSerde.INSTANCE, BufferSupplier.create(), 0x800000, new LogContext(), new KafkaRaftMetrics(new Metrics(), "raft"), (ExternalKRaftMetrics)new DefaultExternalKRaftMetrics(Option.empty(), Option.empty()));
            partitionState.updateState();
            KRaftVersion latestKRaftVersion = partitionState.lastKraftVersion();
            VoterSet latestVoterSet = partitionState.lastVoterSet();
            if (!latestKRaftVersion.isReconfigSupported()) {
                throw new IllegalStateException(String.format("This command can not be used with kRaft version %s that do not support quorum reconfiguration.", latestKRaftVersion.featureLevel()));
            }
            VoterSet.VoterNode standaloneVoter = latestVoterSet.voterNodes().stream().filter(voter -> voter.voterKey().id() == controllerId && voter.voterKey().directoryId().equals(Optional.of(controllerDirectoryId))).findAny().orElseThrow(() -> new TerseException("The current controller with controller ID " + controllerId + " and directory ID " + String.valueOf(controllerDirectoryId) + " is not in the voter set " + String.valueOf(latestVoterSet.voterKeys())));
            VoterSet standaloneVoterSet = VoterSet.fromMap(Collections.singletonMap(controllerId, standaloneVoter));
            VotersRecord votersRecord = standaloneVoterSet.toVotersRecord((short)0);
            ReconfigForceStandaloneCommand.appendToLog(lockedLog, votersRecord);
            System.out.printf("Successfully reconfigured the voter set %s to contain only the local controller%n", standaloneVoter.voterKey());
        }
    }

    private static Properties getProperties(Path config) {
        if (!Files.exists(config, new LinkOption[0])) {
            throw new IllegalStateException("Properties file " + String.valueOf(config) + " does not exists!");
        }
        try {
            return Utils.loadProps((String)config.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load properties file " + String.valueOf(config), e);
        }
    }

    public static void appendToLog(ReplicatedLog log, VotersRecord votersRecord) {
        long logEndOffset = log.endOffset().offset();
        int epoch = log.lastFetchedEpoch();
        try (BatchAccumulator batchAccumulator = new BatchAccumulator(epoch, logEndOffset, Integer.MAX_VALUE, 0x800000, Integer.MAX_VALUE, MemoryPool.NONE, Time.SYSTEM, (Compression)Compression.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE);){
            batchAccumulator.appendVotersRecord(votersRecord, System.currentTimeMillis());
            for (BatchAccumulator.CompletedBatch batch : batchAccumulator.drain()) {
                log.appendAsLeader((Records)batch.data, epoch);
                batch.release();
            }
        }
    }
}

