/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;
import joptsimple.util.EnumConverter;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;

public class AclCommand {
    private static final ResourcePatternFilter CLUSTER_RESOURCE_FILTER = new ResourcePatternFilter(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private static final String NL = System.lineSeparator();

    public static void main(String[] args) {
        AclCommandOptions opts = new AclCommandOptions(args);
        AdminClientService aclCommandService = new AdminClientService(opts);
        try (Admin admin = Admin.create((Properties)AclCommand.adminConfigs(opts));){
            if (opts.options.has((OptionSpec)opts.addOpt)) {
                aclCommandService.addAcls(admin);
            } else if (opts.options.has((OptionSpec)opts.removeOpt)) {
                aclCommandService.removeAcls(admin);
            } else if (opts.options.has((OptionSpec)opts.listOpt)) {
                aclCommandService.listAcls(admin);
            }
        }
        catch (Throwable e) {
            System.out.println("Error while executing ACL command: " + e.getMessage());
            System.out.println(Utils.stackTrace((Throwable)e));
            Exit.exit((int)1);
        }
    }

    private static Properties adminConfigs(AclCommandOptions opts) throws IOException {
        Properties props = new Properties();
        if (opts.options.has(opts.commandConfigOpt)) {
            props = Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt)));
        }
        if (opts.options.has(opts.bootstrapServerOpt)) {
            props.put("bootstrap.servers", opts.options.valueOf(opts.bootstrapServerOpt));
        } else {
            props.put("bootstrap.controllers", opts.options.valueOf(opts.bootstrapControllerOpt));
        }
        return props;
    }

    private static Set<Uuid> getClusterLinkIds(AclCommandOptions opts) {
        if (opts.options.has(opts.linkIdOpt)) {
            return opts.options.valuesOf(opts.linkIdOpt).stream().map(s -> Uuid.fromString((String)s.trim())).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private static Map<ResourcePattern, Set<AccessControlEntry>> getResourceToAcls(AclCommandOptions opts) {
        Map<ResourcePattern, Set<AccessControlEntry>> resourceToAcl;
        PatternType patternType = (PatternType)opts.options.valueOf(opts.resourcePatternType);
        if (!patternType.isSpecific()) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)("A '--resource-pattern-type' value of '" + String.valueOf(patternType) + "' is not valid when adding acls."));
        }
        if ((resourceToAcl = AclCommand.getResourceFilterToAcls(opts).entrySet().stream().collect(Collectors.toMap(entry -> new ResourcePattern(((ResourcePatternFilter)entry.getKey()).resourceType(), ((ResourcePatternFilter)entry.getKey()).name(), ((ResourcePatternFilter)entry.getKey()).patternType()), Map.Entry::getValue))).values().stream().anyMatch(Set::isEmpty)) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)"You must specify one of: --allow-principal, --deny-principal when trying to add ACLs.");
        }
        return resourceToAcl;
    }

    private static Map<ResourcePatternFilter, Set<AccessControlEntry>> getResourceFilterToAcls(AclCommandOptions opts) {
        HashMap<ResourcePatternFilter, Set<AccessControlEntry>> resourceToAcls = new HashMap<ResourcePatternFilter, Set<AccessControlEntry>>();
        if (!opts.options.has((OptionSpec)opts.producerOpt) && !opts.options.has((OptionSpec)opts.consumerOpt)) {
            resourceToAcls.putAll(AclCommand.getCliResourceFilterToAcls(opts));
        }
        if (opts.options.has((OptionSpec)opts.producerOpt)) {
            resourceToAcls.putAll(AclCommand.getProducerResourceFilterToAcls(opts));
        }
        if (opts.options.has((OptionSpec)opts.consumerOpt)) {
            AclCommand.getConsumerResourceFilterToAcls(opts).forEach((k, v) -> {
                Set existingAcls = resourceToAcls.getOrDefault(k, new HashSet());
                existingAcls.addAll(v);
                resourceToAcls.put((ResourcePatternFilter)k, existingAcls);
            });
        }
        AclCommand.validateOperation(opts, resourceToAcls);
        return resourceToAcls;
    }

    private static Map<ResourcePatternFilter, Set<AccessControlEntry>> getProducerResourceFilterToAcls(AclCommandOptions opts) {
        Set<ResourcePatternFilter> filters = AclCommand.getResourceFilter(opts, true);
        Set topics = filters.stream().filter(f -> f.resourceType() == ResourceType.TOPIC).collect(Collectors.toSet());
        Set transactionalIds = filters.stream().filter(f -> f.resourceType() == ResourceType.TRANSACTIONAL_ID).collect(Collectors.toSet());
        boolean enableIdempotence = opts.options.has((OptionSpec)opts.idempotentOpt);
        Set<AccessControlEntry> topicAcls = AclCommand.getAcl(opts, new HashSet<AclOperation>(Arrays.asList(AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE)));
        Set<AccessControlEntry> transactionalIdAcls = AclCommand.getAcl(opts, new HashSet<AclOperation>(Arrays.asList(AclOperation.WRITE, AclOperation.DESCRIBE)));
        HashMap<ResourcePatternFilter, Set<AccessControlEntry>> result = new HashMap<ResourcePatternFilter, Set<AccessControlEntry>>();
        for (ResourcePatternFilter topic : topics) {
            result.put(topic, topicAcls);
        }
        for (ResourcePatternFilter transactionalId : transactionalIds) {
            result.put(transactionalId, transactionalIdAcls);
        }
        if (enableIdempotence) {
            result.put(CLUSTER_RESOURCE_FILTER, AclCommand.getAcl(opts, Collections.singleton(AclOperation.IDEMPOTENT_WRITE)));
        }
        return result;
    }

    private static Map<ResourcePatternFilter, Set<AccessControlEntry>> getConsumerResourceFilterToAcls(AclCommandOptions opts) {
        Set<ResourcePatternFilter> filters = AclCommand.getResourceFilter(opts, true);
        Set topics = filters.stream().filter(f -> f.resourceType() == ResourceType.TOPIC).collect(Collectors.toSet());
        Set groups = filters.stream().filter(f -> f.resourceType() == ResourceType.GROUP).collect(Collectors.toSet());
        Set<AccessControlEntry> topicAcls = AclCommand.getAcl(opts, new HashSet<AclOperation>(Arrays.asList(AclOperation.READ, AclOperation.DESCRIBE)));
        Set<AccessControlEntry> groupAcls = AclCommand.getAcl(opts, Collections.singleton(AclOperation.READ));
        HashMap<ResourcePatternFilter, Set<AccessControlEntry>> result = new HashMap<ResourcePatternFilter, Set<AccessControlEntry>>();
        for (ResourcePatternFilter topic : topics) {
            result.put(topic, topicAcls);
        }
        for (ResourcePatternFilter group : groups) {
            result.put(group, groupAcls);
        }
        return result;
    }

    private static Map<ResourcePatternFilter, Set<AccessControlEntry>> getCliResourceFilterToAcls(AclCommandOptions opts) {
        Set<AccessControlEntry> acls = AclCommand.getAcl(opts);
        Set<ResourcePatternFilter> filters = AclCommand.getResourceFilter(opts, true);
        return filters.stream().collect(Collectors.toMap(filter -> filter, filter -> acls));
    }

    private static Set<AccessControlEntry> getAcl(AclCommandOptions opts, Set<AclOperation> operations) {
        Set<KafkaPrincipal> allowedPrincipals = AclCommand.getPrincipals(opts, opts.allowPrincipalsOpt);
        Set<KafkaPrincipal> deniedPrincipals = AclCommand.getPrincipals(opts, opts.denyPrincipalsOpt);
        Set<String> allowedHosts = AclCommand.getHosts(opts, opts.allowHostsOpt, opts.allowPrincipalsOpt);
        Set<String> deniedHosts = AclCommand.getHosts(opts, opts.denyHostsOpt, opts.denyPrincipalsOpt);
        Set<Uuid> linkIds = AclCommand.getClusterLinkIds(opts);
        HashSet<AccessControlEntry> acls = new HashSet<AccessControlEntry>();
        if (!allowedHosts.isEmpty() && !allowedPrincipals.isEmpty()) {
            acls.addAll(AclCommand.getAcls(allowedPrincipals, AclPermissionType.ALLOW, operations, allowedHosts, linkIds));
        }
        if (!deniedHosts.isEmpty() && !deniedPrincipals.isEmpty()) {
            acls.addAll(AclCommand.getAcls(deniedPrincipals, AclPermissionType.DENY, operations, deniedHosts, linkIds));
        }
        return acls;
    }

    private static Set<AccessControlEntry> getAcl(AclCommandOptions opts) {
        Set<AclOperation> operations = opts.options.valuesOf(opts.operationsOpt).stream().map(operation -> SecurityUtils.operation((String)operation.trim())).collect(Collectors.toSet());
        return AclCommand.getAcl(opts, operations);
    }

    static Set<AccessControlEntry> getAcls(Set<KafkaPrincipal> principals, AclPermissionType permissionType, Set<AclOperation> operations, Set<String> hosts, Set<Uuid> linkIds) {
        HashSet<AccessControlEntry> acls = new HashSet<AccessControlEntry>();
        for (KafkaPrincipal principal : principals) {
            for (AclOperation operation : operations) {
                for (String host : hosts) {
                    acls.add(new AccessControlEntry(principal.toString(), host, operation, permissionType, linkIds));
                }
            }
        }
        return acls;
    }

    private static Set<String> getHosts(AclCommandOptions opts, OptionSpec<String> hostOptionSpec, OptionSpec<String> principalOptionSpec) {
        if (opts.options.has(hostOptionSpec)) {
            return opts.options.valuesOf(hostOptionSpec).stream().map(String::trim).collect(Collectors.toSet());
        }
        if (opts.options.has(principalOptionSpec)) {
            return Collections.singleton("*");
        }
        return Collections.emptySet();
    }

    private static Set<KafkaPrincipal> getPrincipals(AclCommandOptions opts, OptionSpec<String> principalOptionSpec) {
        if (opts.options.has(principalOptionSpec)) {
            return opts.options.valuesOf(principalOptionSpec).stream().map(s -> SecurityUtils.parseKafkaPrincipal((String)s.trim())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static Set<ResourcePatternFilter> getResourceFilter(AclCommandOptions opts, boolean dieIfNoResourceFound) {
        PatternType patternType = (PatternType)opts.options.valueOf(opts.resourcePatternType);
        HashSet<ResourcePatternFilter> resourceFilters = new HashSet<ResourcePatternFilter>();
        if (opts.options.has(opts.topicOpt)) {
            opts.options.valuesOf(opts.topicOpt).forEach(topic -> resourceFilters.add(new ResourcePatternFilter(ResourceType.TOPIC, topic.trim(), patternType)));
        }
        if (patternType == PatternType.LITERAL && (opts.options.has((OptionSpec)opts.clusterOpt) || opts.options.has((OptionSpec)opts.idempotentOpt))) {
            resourceFilters.add(CLUSTER_RESOURCE_FILTER);
        }
        if (opts.options.has(opts.groupOpt)) {
            opts.options.valuesOf(opts.groupOpt).forEach(group -> resourceFilters.add(new ResourcePatternFilter(ResourceType.GROUP, group.trim(), patternType)));
        }
        if (opts.options.has(opts.transactionalIdOpt)) {
            opts.options.valuesOf(opts.transactionalIdOpt).forEach(transactionalId -> resourceFilters.add(new ResourcePatternFilter(ResourceType.TRANSACTIONAL_ID, transactionalId, patternType)));
        }
        if (opts.options.has(opts.delegationTokenOpt)) {
            opts.options.valuesOf(opts.delegationTokenOpt).forEach(token -> resourceFilters.add(new ResourcePatternFilter(ResourceType.DELEGATION_TOKEN, token.trim(), patternType)));
        }
        if (opts.options.has(opts.userPrincipalOpt)) {
            opts.options.valuesOf(opts.userPrincipalOpt).forEach(user -> resourceFilters.add(new ResourcePatternFilter(ResourceType.USER, user.trim(), patternType)));
        }
        if (resourceFilters.isEmpty() && dieIfNoResourceFound) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)"You must provide at least one resource: --topic <topic> or --cluster or --group <group> or --delegation-token <Delegation Token ID>");
        }
        return resourceFilters;
    }

    private static boolean confirmAction(AclCommandOptions opts, String msg) {
        if (opts.options.has((OptionSpec)opts.forceOpt)) {
            return true;
        }
        System.out.println(msg);
        return System.console().readLine().equalsIgnoreCase("y");
    }

    private static void validateOperation(AclCommandOptions opts, Map<ResourcePatternFilter, Set<AccessControlEntry>> resourceToAcls) {
        for (Map.Entry<ResourcePatternFilter, Set<AccessControlEntry>> entry : resourceToAcls.entrySet()) {
            ResourcePatternFilter resource = entry.getKey();
            Set<AccessControlEntry> acls = entry.getValue();
            HashSet<AclOperation> validOps = new HashSet<AclOperation>(AclEntry.supportedOperations((ResourceType)resource.resourceType()));
            validOps.add(AclOperation.ALL);
            HashSet<AclOperation> unsupportedOps = new HashSet<AclOperation>();
            for (AccessControlEntry acl : acls) {
                if (validOps.contains(acl.operation())) continue;
                unsupportedOps.add(acl.operation());
            }
            if (unsupportedOps.isEmpty()) continue;
            String msg = String.format("ResourceType %s only supports operations %s", resource.resourceType(), validOps);
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)msg);
        }
    }

    public static final class AclCommandOptions
    extends CommandDefaultOptions {
        private final OptionSpec<String> bootstrapServerOpt;
        private final OptionSpec<String> bootstrapControllerOpt;
        private final OptionSpec<String> commandConfigOpt;
        private final OptionSpec<String> topicOpt;
        private final OptionSpecBuilder clusterOpt;
        private final OptionSpec<String> groupOpt;
        private final OptionSpec<String> transactionalIdOpt;
        private final OptionSpecBuilder idempotentOpt;
        private final OptionSpec<String> delegationTokenOpt;
        private final OptionSpec<PatternType> resourcePatternType;
        private final OptionSpecBuilder addOpt;
        private final OptionSpecBuilder removeOpt;
        private final OptionSpecBuilder listOpt;
        private final OptionSpec<String> operationsOpt;
        private final OptionSpec<String> allowPrincipalsOpt;
        private final OptionSpec<String> denyPrincipalsOpt;
        private final OptionSpec<String> listPrincipalsOpt;
        private final OptionSpec<String> allowHostsOpt;
        private final OptionSpec<String> denyHostsOpt;
        private final OptionSpecBuilder producerOpt;
        private final OptionSpecBuilder consumerOpt;
        private final OptionSpecBuilder forceOpt;
        private final OptionSpec<String> linkIdOpt;
        private final OptionSpecBuilder resourceId;
        private final OptionSpec<String> userPrincipalOpt;

        public AclCommandOptions(String[] args) {
            super(args);
            this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "A list of host/port pairs to use for establishing the connection to the Kafka cluster. This list should be in the form host1:port1,host2:port2,... This config is required for acl management using admin client API.").withRequiredArg().describedAs("server to connect to").ofType(String.class);
            this.bootstrapControllerOpt = this.parser.accepts("bootstrap-controller", "A list of host/port pairs to use for establishing the connection to the Kafka cluster. This list should be in the form host1:port1,host2:port2,... This config is required for acl management using admin client API.").withRequiredArg().describedAs("controller to connect to").ofType(String.class);
            this.commandConfigOpt = this.parser.accepts("command-config", "A property file containing configs to be passed to Admin Client.").withOptionalArg().describedAs("command-config").ofType(String.class);
            this.topicOpt = this.parser.accepts("topic", "topic to which ACLs should be added or removed. A value of '*' indicates ACL should apply to all topics.").withRequiredArg().describedAs("topic").ofType(String.class);
            this.clusterOpt = this.parser.accepts("cluster", "Add/Remove cluster ACLs.");
            this.groupOpt = this.parser.accepts("group", "Consumer Group to which the ACLs should be added or removed. A value of '*' indicates the ACLs should apply to all groups.").withRequiredArg().describedAs("group").ofType(String.class);
            this.transactionalIdOpt = this.parser.accepts("transactional-id", "The transactionalId to which ACLs should be added or removed. A value of '*' indicates the ACLs should apply to all transactionalIds.").withRequiredArg().describedAs("transactional-id").ofType(String.class);
            this.idempotentOpt = this.parser.accepts("idempotent", "Enable idempotence for the producer. This should be used in combination with the --producer option. Note that idempotence is enabled automatically if the producer is authorized to a particular transactional-id.");
            this.delegationTokenOpt = this.parser.accepts("delegation-token", "Delegation token to which ACLs should be added or removed. A value of '*' indicates ACL should apply to all tokens.").withRequiredArg().describedAs("delegation-token").ofType(String.class);
            this.resourcePatternType = this.parser.accepts("resource-pattern-type", "The type of the resource pattern or pattern filter. When adding acls, this should be a specific pattern type, e.g. 'literal' or 'prefixed'. When listing or removing acls, a specific pattern type can be used to list or remove acls from specific resource patterns, or use the filter values of 'any' or 'match', where 'any' will match any pattern type, but will match the resource name exactly, where as 'match' will perform pattern matching to list or remove all acls that affect the supplied resource(s). WARNING: 'match', when used in combination with the '--remove' switch, should be used with care.").withRequiredArg().ofType(String.class).withValuesConvertedBy((ValueConverter)new PatternTypeConverter()).defaultsTo((Object)PatternType.LITERAL, (Object[])new PatternType[0]);
            this.addOpt = this.parser.accepts("add", "Indicates you are trying to add ACLs.");
            this.removeOpt = this.parser.accepts("remove", "Indicates you are trying to remove ACLs.");
            this.listOpt = this.parser.accepts("list", "List ACLs for the specified resource, use --topic <topic> or --group <group> or --cluster to specify a resource.");
            this.operationsOpt = this.parser.accepts("operation", "Operation that is being allowed or denied. Valid operation names are: " + NL + AclEntry.ACL_OPERATIONS.stream().map(o -> "\t" + SecurityUtils.operationName((AclOperation)o)).collect(Collectors.joining(NL)) + NL).withRequiredArg().ofType(String.class).defaultsTo((Object)SecurityUtils.operationName((AclOperation)AclOperation.ALL), (Object[])new String[0]);
            this.allowPrincipalsOpt = this.parser.accepts("allow-principal", "principal is in principalType:name format. Note that principalType must be supported by the Authorizer being used. For example, User:'*' is the wild card indicating all users.").withRequiredArg().describedAs("allow-principal").ofType(String.class);
            this.denyPrincipalsOpt = this.parser.accepts("deny-principal", "principal is in principalType:name format. By default anyone not added through --allow-principal is denied access. You only need to use this option as negation to already allowed set. Note that principalType must be supported by the Authorizer being used. For example if you wanted to allow access to all users in the system but not test-user you can define an ACL that allows access to User:'*' and specify --deny-principal=User:test@EXAMPLE.COM. AND PLEASE REMEMBER DENY RULES TAKES PRECEDENCE OVER ALLOW RULES.").withRequiredArg().describedAs("deny-principal").ofType(String.class);
            this.listPrincipalsOpt = this.parser.accepts("principal", "List ACLs for the specified principal. principal is in principalType:name format. Note that principalType must be supported by the Authorizer being used. Multiple --principal option can be passed.").withOptionalArg().describedAs("principal").ofType(String.class);
            this.allowHostsOpt = this.parser.accepts("allow-host", "Host from which principals listed in --allow-principal will have access. If you have specified --allow-principal then the default for this option will be set to '*' which allows access from all hosts.").withRequiredArg().describedAs("allow-host").ofType(String.class);
            this.denyHostsOpt = this.parser.accepts("deny-host", "Host from which principals listed in --deny-principal will be denied access. If you have specified --deny-principal then the default for this option will be set to '*' which denies access from all hosts.").withRequiredArg().describedAs("deny-host").ofType(String.class);
            this.producerOpt = this.parser.accepts("producer", "Convenience option to add/remove ACLs for producer role. This will generate ACLs that allows WRITE,DESCRIBE and CREATE on topic.");
            this.consumerOpt = this.parser.accepts("consumer", "Convenience option to add/remove ACLs for consumer role. This will generate ACLs that allows READ,DESCRIBE on topic and READ on group.");
            this.forceOpt = this.parser.accepts("force", "Assume Yes to all queries and do not prompt.");
            this.linkIdOpt = this.parser.accepts("link-id", "Cluster link ID associated with the ACLs for add/remove/list.").withRequiredArg().describedAs("link id").ofType(String.class);
            this.resourceId = this.parser.accepts("resource-id", "List the ACLs with principal as resourceID. This is only applicable for Confluent Cloud.");
            this.userPrincipalOpt = this.parser.accepts("user-principal", "Specifies a user principal as a resource in relation with the operation. For instance one could grant CreateTokens or DescribeTokens permission on a given user principal.").withRequiredArg().describedAs("user-principal").ofType(String.class);
            try {
                this.options = this.parser.parse(args);
            }
            catch (OptionException e) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)e.getMessage());
            }
            this.checkArgs();
        }

        void checkArgs() {
            List<AbstractOptionSpec> mutuallyExclusiveOptions;
            long mutuallyExclusiveOptionsCount;
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to manage acls on kafka.");
            if (this.options.has(this.bootstrapServerOpt) && this.options.has(this.bootstrapControllerOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Only one of --bootstrap-server or --bootstrap-controller must be specified");
            }
            if (!this.options.has(this.bootstrapServerOpt) && !this.options.has(this.bootstrapControllerOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"One of --bootstrap-server or --bootstrap-controller must be specified");
            }
            if ((mutuallyExclusiveOptionsCount = (mutuallyExclusiveOptions = Arrays.asList(this.addOpt, this.removeOpt, this.listOpt)).stream().filter(abstractOptionSpec -> this.options.has((OptionSpec)abstractOptionSpec)).count()) != 1L) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Command must include exactly one action: --list, --add, --remove. ");
            }
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.listOpt, (OptionSpec[])new OptionSpec[]{this.producerOpt, this.consumerOpt, this.allowHostsOpt, this.allowPrincipalsOpt, this.denyHostsOpt, this.denyPrincipalsOpt});
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.producerOpt, (OptionSpec[])new OptionSpec[]{this.operationsOpt, this.denyPrincipalsOpt, this.denyHostsOpt});
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.consumerOpt, (OptionSpec[])new OptionSpec[]{this.operationsOpt, this.denyPrincipalsOpt, this.denyHostsOpt});
            if (this.options.has(this.listPrincipalsOpt) && !this.options.has((OptionSpec)this.listOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"The --principal option is only available if --list is set");
            }
            if (this.options.has((OptionSpec)this.producerOpt) && !this.options.has(this.topicOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"With --producer you must specify a --topic");
            }
            if (this.options.has((OptionSpec)this.idempotentOpt) && !this.options.has((OptionSpec)this.producerOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"The --idempotent option is only available if --producer is set");
            }
            if (this.options.has((OptionSpec)this.consumerOpt) && (!this.options.has(this.topicOpt) || !this.options.has(this.groupOpt) || !this.options.has((OptionSpec)this.producerOpt) && (this.options.has((OptionSpec)this.clusterOpt) || this.options.has(this.transactionalIdOpt)))) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"With --consumer you must specify a --topic and a --group and no --cluster or --transactional-id option should be specified.");
            }
        }
    }

    private static class AdminClientService {
        private final AclCommandOptions opts;
        private final AccessControlEntryFilter anyAceFilter;

        AdminClientService(AclCommandOptions opts) {
            this.opts = opts;
            this.anyAceFilter = opts.options.has((OptionSpec)opts.resourceId) ? new AccessControlEntryFilter(new KafkaPrincipal("UserV2", "*").toString(), null, AclOperation.ANY, AclPermissionType.ANY) : AccessControlEntryFilter.ANY;
        }

        void addAcls(Admin admin) throws ExecutionException, InterruptedException {
            Map<ResourcePattern, Set<AccessControlEntry>> resourceToAcl = AclCommand.getResourceToAcls(this.opts);
            for (Map.Entry<ResourcePattern, Set<AccessControlEntry>> entry : resourceToAcl.entrySet()) {
                ResourcePattern resource = entry.getKey();
                Set<AccessControlEntry> acls = entry.getValue();
                System.out.println("Adding ACLs for resource `" + String.valueOf(resource) + "`: " + NL + " " + acls.stream().map(a -> "\t" + String.valueOf(a)).collect(Collectors.joining(NL)) + NL);
                Collection aclBindings = acls.stream().map(acl -> new AclBinding(resource, acl)).collect(Collectors.toList());
                admin.createAcls(aclBindings).all().get();
            }
            this.listAcls(admin);
        }

        void removeAcls(Admin admin) throws ExecutionException, InterruptedException {
            Map<ResourcePatternFilter, Set<AccessControlEntry>> filterToAcl = AclCommand.getResourceFilterToAcls(this.opts);
            for (Map.Entry<ResourcePatternFilter, Set<AccessControlEntry>> entry : filterToAcl.entrySet()) {
                ResourcePatternFilter filter = entry.getKey();
                Set<AccessControlEntry> acls = entry.getValue();
                if (acls.isEmpty()) {
                    if (!AclCommand.confirmAction(this.opts, "Are you sure you want to delete all ACLs for resource filter `" + String.valueOf(filter) + "`? (y/n)")) continue;
                    this.removeAcls(admin, acls, filter);
                    continue;
                }
                String msg = "Are you sure you want to remove ACLs: " + NL + " " + acls.stream().map(a -> "\t" + String.valueOf(a)).collect(Collectors.joining(NL)) + NL + " from resource filter `" + String.valueOf(filter) + "`? (y/n)";
                if (!AclCommand.confirmAction(this.opts, msg)) continue;
                this.removeAcls(admin, acls, filter);
            }
            this.listAcls(admin);
        }

        private void listAcls(Admin admin) throws ExecutionException, InterruptedException {
            Set<ResourcePatternFilter> filters = AclCommand.getResourceFilter(this.opts, false);
            Set<KafkaPrincipal> listPrincipals = AclCommand.getPrincipals(this.opts, this.opts.listPrincipalsOpt);
            Set<Uuid> linkIds = AclCommand.getClusterLinkIds(this.opts);
            Map<ResourcePattern, Set<AccessControlEntry>> resourceToAcls = this.getAcls(admin, filters, linkIds);
            if (listPrincipals.isEmpty()) {
                AdminClientService.printResourceAcls(resourceToAcls);
            } else {
                listPrincipals.forEach(principal -> {
                    System.out.println("ACLs for principal `" + String.valueOf(principal) + "`");
                    Map<ResourcePattern, Set<AccessControlEntry>> filteredResourceToAcls = resourceToAcls.entrySet().stream().map(entry -> {
                        ResourcePattern resource = (ResourcePattern)entry.getKey();
                        Set acls = ((Set)entry.getValue()).stream().filter(acl -> principal.toString().equals(acl.principal())).collect(Collectors.toSet());
                        return new AbstractMap.SimpleEntry(resource, acls);
                    }).filter(entry -> !((Set)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    AdminClientService.printResourceAcls(filteredResourceToAcls);
                });
            }
        }

        private static void printResourceAcls(Map<ResourcePattern, Set<AccessControlEntry>> resourceToAcls) {
            resourceToAcls.forEach((resource, acls) -> System.out.println("Current ACLs for resource `" + String.valueOf(resource) + "`:" + NL + acls.stream().map(acl -> "\t" + String.valueOf(acl)).collect(Collectors.joining(NL)) + NL));
        }

        private void removeAcls(Admin adminClient, Set<AccessControlEntry> acls, ResourcePatternFilter filter) throws ExecutionException, InterruptedException {
            if (acls.isEmpty()) {
                adminClient.deleteAcls(List.of(new AclBindingFilter(filter, this.anyAceFilter))).all().get();
            } else {
                List aclBindingFilters = acls.stream().map(acl -> new AclBindingFilter(filter, acl.toFilter())).collect(Collectors.toList());
                adminClient.deleteAcls(aclBindingFilters).all().get();
            }
        }

        private Map<ResourcePattern, Set<AccessControlEntry>> getAcls(Admin adminClient, Set<ResourcePatternFilter> filters, Set<Uuid> linkIds) throws ExecutionException, InterruptedException {
            Collection aclBindings;
            AccessControlEntryFilter aceFilter = SecurityUtils.aceFilterWithClusterLinkIds((AccessControlEntryFilter)this.anyAceFilter, linkIds);
            if (filters.isEmpty()) {
                aclBindings = (Collection)adminClient.describeAcls(new AclBindingFilter(ResourcePatternFilter.ANY, aceFilter)).values().get();
            } else {
                aclBindings = new ArrayList();
                for (ResourcePatternFilter filter : filters) {
                    aclBindings.addAll((Collection)adminClient.describeAcls(new AclBindingFilter(filter, aceFilter)).values().get());
                }
            }
            HashMap<ResourcePattern, Set<AccessControlEntry>> resourceToAcls = new HashMap<ResourcePattern, Set<AccessControlEntry>>();
            for (AclBinding aclBinding : aclBindings) {
                ResourcePattern resource = aclBinding.pattern();
                Set acls = resourceToAcls.getOrDefault(resource, new HashSet());
                acls.add(aclBinding.entry());
                resourceToAcls.put(resource, acls);
            }
            return resourceToAcls;
        }
    }

    static class PatternTypeConverter
    extends EnumConverter<PatternType> {
        PatternTypeConverter() {
            super(PatternType.class);
        }

        public PatternType convert(String value) {
            PatternType patternType = (PatternType)super.convert(value);
            if (patternType.isUnknown()) {
                throw new ValueConversionException("Unknown resource-pattern-type: " + value);
            }
            return patternType;
        }

        public String valuePattern() {
            List<PatternType> values = Arrays.asList(PatternType.values());
            List filteredValues = values.stream().filter(type -> type != PatternType.UNKNOWN).collect(Collectors.toList());
            return filteredValues.stream().map(Object::toString).collect(Collectors.joining("|"));
        }
    }
}

