/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerApiVersionsCommand {
    public static void main(String[] args) {
        Exit.exit((int)BrokerApiVersionsCommand.mainNoExit(args));
    }

    static int mainNoExit(String[] args) {
        return BrokerApiVersionsCommand.mainNoExit(args, System.out);
    }

    static int mainNoExit(String[] args, PrintStream out) {
        try {
            BrokerApiVersionsCommand.execute(args, out);
            return 0;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    public static void execute(String[] args, PrintStream out) throws IOException, InterruptedException {
        BrokerVersionCommandOptions opts = new BrokerVersionCommandOptions(args);
        try (AdminClient adminClient = BrokerApiVersionsCommand.createAdminClient(opts);){
            adminClient.awaitBrokers();
            Map<Node, KafkaFuture<NodeApiVersions>> brokerMap = adminClient.listAllBrokerVersionInfo();
            brokerMap.forEach((broker, future) -> {
                try {
                    NodeApiVersions apiVersions = (NodeApiVersions)future.get();
                    out.print(BrokerApiVersionsCommand.formatNode(broker) + " -> " + apiVersions.toString(true) + "\n");
                }
                catch (Exception e) {
                    out.print(BrokerApiVersionsCommand.formatNode(broker) + " -> ERROR: " + e.getMessage() + "\n");
                }
            });
        }
    }

    private static String formatNode(Node node) {
        return String.format("%s:%d (id: %s rack: %s isFenced: %s)", node.host(), node.port(), node.idString(), node.rack(), node.isFenced());
    }

    private static AdminClient createAdminClient(BrokerVersionCommandOptions opts) throws IOException {
        Properties props = opts.options.has(opts.commandConfigOpt) ? Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt))) : new Properties();
        props.put("bootstrap.servers", opts.options.valueOf(opts.bootstrapServerOpt));
        return AdminClient.create(props);
    }

    private static class BrokerVersionCommandOptions
    extends CommandDefaultOptions {
        private static final String BOOTSTRAP_SERVER_DOC = "REQUIRED: The server to connect to.";
        private static final String COMMAND_CONFIG_DOC = "A property file containing configs to be passed to Admin Client.";
        final OptionSpec<String> commandConfigOpt;
        final OptionSpec<String> bootstrapServerOpt;

        BrokerVersionCommandOptions(String[] args) {
            super(args);
            this.commandConfigOpt = this.parser.accepts("command-config", COMMAND_CONFIG_DOC).withRequiredArg().describedAs("command config property file").ofType(String.class);
            this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", BOOTSTRAP_SERVER_DOC).withRequiredArg().describedAs("server(s) to use for bootstrapping").ofType(String.class);
            this.options = this.parser.parse(args);
            this.checkArgs();
        }

        private void checkArgs() {
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to retrieve broker version information.");
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.bootstrapServerOpt});
        }
    }

    protected static class AdminClient
    implements AutoCloseable {
        private static final Logger LOGGER = LoggerFactory.getLogger(AdminClient.class);
        private static final int DEFAULT_CONNECTION_MAX_IDLE_MS = 540000;
        private static final int DEFAULT_REQUEST_TIMEOUT_MS = 5000;
        private static final int DEFAULT_MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION = 100;
        private static final int DEFAULT_RECONNECT_BACKOFF_MS = 50;
        private static final int DEFAULT_RECONNECT_BACKOFF_MAX = 50;
        private static final int DEFAULT_SEND_BUFFER_BYTES = 131072;
        private static final int DEFAULT_RECEIVE_BUFFER_BYTES = 32768;
        private static final int DEFAULT_RETRY_BACKOFF_MS = 100;
        private static final AtomicInteger ADMIN_CLIENT_ID_SEQUENCE = new AtomicInteger(1);
        private static final ConfigDef ADMIN_CONFIG_DEF = new ConfigDef().define("bootstrap.servers", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "A list of host/port pairs used to establish the initial connection to the Kafka cluster. Clients use this list to bootstrap and discover the full set of Kafka brokers. While the order of servers in the list does not matter, we recommend including more than one server to ensure resilience if any servers are down. This list does not need to contain the entire set of brokers, as Kafka clients automatically manage and update connections to the cluster efficiently. This list must be in the form <code>host1:port1,host2:port2,...</code>.").define("client.dns.lookup", ConfigDef.Type.STRING, (Object)ClientDnsLookup.USE_ALL_DNS_IPS.toString(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY.toString()}), ConfigDef.Importance.MEDIUM, "Controls how the client uses DNS lookups. If set to <code>use_all_dns_ips</code>, connect to each returned IP address in sequence until a successful connection is established. After a disconnection, the next IP is used. Once all IPs have been used once, the client resolves the IP(s) from the hostname again (both the JVM and the OS cache DNS name lookups, however). If set to <code>resolve_canonical_bootstrap_servers_only</code>, resolve each bootstrap address into a list of canonical names. After the bootstrap phase, this behaves the same as <code>use_all_dns_ips</code>.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", (ConfigDef.Validator)ConfigDef.CaseInsensitiveValidString.in((String[])Utils.enumOptions(SecurityProtocol.class)), ConfigDef.Importance.MEDIUM, "Protocol used to communicate with brokers.").define("request.timeout.ms", ConfigDef.Type.INT, (Object)5000, ConfigDef.Importance.MEDIUM, "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.").define("socket.connection.setup.timeout.ms", ConfigDef.Type.LONG, (Object)CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS, ConfigDef.Importance.MEDIUM, "The amount of time the client will wait for the socket connection to be established. If the connection is not built before the timeout elapses, clients will close the socket channel. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>socket.connection.setup.timeout.max.ms</code> value.").define("socket.connection.setup.timeout.max.ms", ConfigDef.Type.LONG, (Object)CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS, ConfigDef.Importance.MEDIUM, "The maximum amount of time the client will wait for the socket connection to be established. The connection setup timeout will increase exponentially for each consecutive connection failure up to this maximum. To avoid connection storms, a randomization factor of 0.2 will be applied to the timeout resulting in a random range between 20% below and 20% above the computed value.").define("retry.backoff.ms", ConfigDef.Type.LONG, (Object)100, ConfigDef.Importance.MEDIUM, "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios. This value is the initial backoff value and will increase exponentially for each failed request, up to the <code>retry.backoff.max.ms</code> value.").withClientSslSupport().withClientSaslSupport();
        private final Time time;
        private final ConsumerNetworkClient client;
        private final List<Node> bootstrapBrokers;

        static AdminClient create(Properties props) {
            return AdminClient.create(new AbstractConfig(ADMIN_CONFIG_DEF, (Map)props, false));
        }

        static AdminClient create(AbstractConfig config) {
            String clientId = "admin-" + ADMIN_CLIENT_ID_SEQUENCE.getAndIncrement();
            LogContext logContext = new LogContext("[LegacyAdminClient clientId=" + clientId + "] ");
            Time time = Time.SYSTEM;
            Metrics metrics = new Metrics(time);
            Metadata metadata = new Metadata(CommonClientConfigs.DEFAULT_RETRY_BACKOFF_MS.longValue(), CommonClientConfigs.DEFAULT_RETRY_BACKOFF_MAX_MS.longValue(), 3600000L, logContext, new ClusterResourceListeners());
            metadata.bootstrap(ClientUtils.parseAndValidateAddresses((List)config.getList("bootstrap.servers"), (String)config.getString("client.dns.lookup")));
            Selector selector = new Selector(540000L, metrics, time, "admin", ClientUtils.createChannelBuilder((AbstractConfig)config, (Time)time, (LogContext)logContext), logContext);
            NetworkClient networkClient = new NetworkClient((Selectable)selector, metadata, clientId, 100, 50L, 50L, 131072, 32768, config.getInt("request.timeout.ms").intValue(), config.getLong("socket.connection.setup.timeout.ms").longValue(), config.getLong("socket.connection.setup.timeout.max.ms").longValue(), time, true, new ApiVersions(), logContext, MetadataRecoveryStrategy.NONE);
            ConsumerNetworkClient highLevelClient = new ConsumerNetworkClient(logContext, (KafkaClient)networkClient, metadata, time, config.getLong("retry.backoff.ms").longValue(), config.getInt("request.timeout.ms").intValue(), Integer.MAX_VALUE);
            return new AdminClient(time, highLevelClient, metadata.fetch().nodes());
        }

        AdminClient(Time time, ConsumerNetworkClient client, List<Node> bootstrapBrokers) {
            this.time = time;
            this.client = client;
            this.bootstrapBrokers = bootstrapBrokers;
        }

        private AbstractResponse send(Node target, AbstractRequest.Builder<?> request) {
            RequestFuture future = this.client.send(target, request);
            while (!future.isDone()) {
                this.client.poll(this.time.timer(5000L));
            }
            if (future.succeeded()) {
                return ((ClientResponse)future.value()).responseBody();
            }
            throw future.exception();
        }

        private AbstractResponse sendAnyNode(AbstractRequest.Builder<?> request) {
            for (Node broker : this.bootstrapBrokers) {
                try {
                    return this.send(broker, request);
                }
                catch (AuthenticationException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.debug("Request {} failed against node {}", new Object[]{request.apiKey(), broker, e});
                }
            }
            throw new RuntimeException("Request " + String.valueOf(request.apiKey()) + " failed on brokers " + String.valueOf(this.bootstrapBrokers));
        }

        protected KafkaFuture<NodeApiVersions> getNodeApiVersions(Node node) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            try {
                ApiVersionsResponse response = (ApiVersionsResponse)this.send(node, (AbstractRequest.Builder<?>)new ApiVersionsRequest.Builder());
                Errors error = Errors.forCode((short)response.data().errorCode());
                if (error.exception() != null) {
                    future.completeExceptionally((Throwable)error.exception());
                } else {
                    future.complete((Object)new NodeApiVersions((Collection)response.data().apiKeys(), (Collection)response.data().supportedFeatures()));
                }
            }
            catch (Exception e) {
                future.completeExceptionally((Throwable)e);
            }
            return future;
        }

        public void awaitBrokers() throws InterruptedException {
            List<Node> nodes;
            do {
                if (!(nodes = this.findAllBrokers()).isEmpty()) continue;
                TimeUnit.MILLISECONDS.sleep(50L);
            } while (nodes.isEmpty());
        }

        private List<Node> findAllBrokers() {
            MetadataResponse response = (MetadataResponse)this.sendAnyNode((AbstractRequest.Builder<?>)MetadataRequest.Builder.allTopics());
            if (!response.errors().isEmpty()) {
                LOGGER.debug("Metadata request contained errors: {}", (Object)response.errors());
            }
            return response.buildCluster().nodes();
        }

        public Map<Node, KafkaFuture<NodeApiVersions>> listAllBrokerVersionInfo() {
            return this.findAllBrokers().stream().collect(Collectors.toMap(broker -> broker, this::getNodeApiVersions));
        }

        @Override
        public void close() {
            try {
                this.client.close();
            }
            catch (IOException e) {
                LOGGER.error("Exception closing nioSelector:", (Throwable)e);
            }
        }
    }
}

