/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.TerseException;

public class ClusterTool {
    public static void main(String ... args) {
        Exit.exit((int)ClusterTool.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            ClusterTool.execute(args);
            return 0;
        }
        catch (TerseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    static void execute(String ... args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"kafka-cluster").defaultHelp(true).description("The Kafka cluster tool.");
        Subparsers subparsers = parser.addSubparsers().dest("command");
        Subparser clusterIdParser = subparsers.addParser("cluster-id").help("Get information about the ID of a cluster.");
        Subparser unregisterParser = subparsers.addParser("unregister").help("Unregister a broker.");
        Subparser listEndpoints = subparsers.addParser("list-endpoints").help("List endpoints");
        for (Subparser subpparser : Arrays.asList(clusterIdParser, unregisterParser, listEndpoints)) {
            MutuallyExclusiveGroup connectionOptions = subpparser.addMutuallyExclusiveGroup().required(true);
            connectionOptions.addArgument(new String[]{"--bootstrap-server", "-b"}).action((ArgumentAction)Arguments.store()).help("A list of host/port pairs to use for establishing the connection to the Kafka cluster.");
            connectionOptions.addArgument(new String[]{"--bootstrap-controller", "-C"}).action((ArgumentAction)Arguments.store()).help("A list of host/port pairs to use for establishing the connection to the KRaft controllers.");
            subpparser.addArgument(new String[]{"--config", "-c"}).action((ArgumentAction)Arguments.store()).help("A property file containing configurations for the Admin client.");
        }
        unregisterParser.addArgument(new String[]{"--id", "-i"}).type(Integer.class).action((ArgumentAction)Arguments.store()).required(true).help("The ID of the broker to unregister.");
        listEndpoints.addArgument(new String[]{"--include-fenced-brokers"}).action((ArgumentAction)Arguments.storeTrue()).help("Whether to include fenced brokers when listing broker endpoints");
        Namespace namespace = parser.parseArgsOrFail(args);
        String command = namespace.getString("command");
        String configPath = namespace.getString("config");
        Properties properties = configPath == null ? new Properties() : Utils.loadProps((String)configPath);
        CommandLineUtils.initializeBootstrapProperties((Properties)properties, Optional.ofNullable(namespace.getString("bootstrap_server")), Optional.ofNullable(namespace.getString("bootstrap_controller")));
        switch (command) {
            case "cluster-id": {
                try (Admin adminClient = Admin.create((Properties)properties);){
                    ClusterTool.clusterIdCommand(System.out, adminClient);
                    break;
                }
            }
            case "unregister": {
                try (Admin adminClient = Admin.create((Properties)properties);){
                    ClusterTool.unregisterCommand(System.out, adminClient, namespace.getInt("id"));
                    break;
                }
            }
            case "list-endpoints": {
                try (Admin adminClient = Admin.create((Properties)properties);){
                    boolean listControllerEndpoints;
                    boolean includeFencedBrokers = Optional.ofNullable(namespace.getBoolean("include_fenced_brokers")).orElse(false);
                    boolean bl = listControllerEndpoints = namespace.getString("bootstrap_controller") != null;
                    if (includeFencedBrokers && listControllerEndpoints) {
                        throw new IllegalArgumentException("The option --include-fenced-brokers is only supported with --bootstrap-server option");
                    }
                    ClusterTool.listEndpoints(System.out, adminClient, listControllerEndpoints, includeFencedBrokers);
                    break;
                }
            }
            default: {
                throw new RuntimeException("Unknown command " + command);
            }
        }
    }

    static void clusterIdCommand(PrintStream stream, Admin adminClient) throws Exception {
        String clusterId = (String)adminClient.describeCluster().clusterId().get();
        if (clusterId != null) {
            stream.println("Cluster ID: " + clusterId);
        } else {
            stream.println("No cluster ID found. The Kafka version is probably too old.");
        }
    }

    static void unregisterCommand(PrintStream stream, Admin adminClient, int id) throws Exception {
        try {
            adminClient.unregisterBroker(id).all().get();
            stream.println("Broker " + id + " is no longer registered.");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof UnsupportedVersionException) {
                stream.println("The target cluster does not support the broker unregistration API.");
            }
            throw ee;
        }
    }

    static void listEndpoints(PrintStream stream, Admin adminClient, boolean listControllerEndpoints, boolean includeFencedBrokers) throws Exception {
        try {
            DescribeClusterOptions option = new DescribeClusterOptions().includeFencedBrokers(includeFencedBrokers);
            Collection nodes = (Collection)adminClient.describeCluster(option).nodes().get();
            String maxHostLength = String.valueOf(nodes.stream().map(node -> node.host().length()).max(Integer::compareTo).orElse(100));
            String maxRackLength = String.valueOf(nodes.stream().filter(node -> node.hasRack()).map(node -> node.rack().length()).max(Integer::compareTo).orElse(10));
            if (listControllerEndpoints) {
                String format = "%-10s %-" + maxHostLength + "s %-10s %-" + maxRackLength + "s %-15s%n";
                stream.printf(format, "ID", "HOST", "PORT", "RACK", "ENDPOINT_TYPE");
                nodes.forEach(node -> stream.printf(format, node.idString(), node.host(), node.port(), node.rack(), "controller"));
            } else {
                String format = "%-10s %-" + maxHostLength + "s %-10s %-" + maxRackLength + "s %-10s %-15s%n";
                stream.printf(format, "ID", "HOST", "PORT", "RACK", "STATE", "ENDPOINT_TYPE");
                nodes.forEach(node -> stream.printf(format, node.idString(), node.host(), node.port(), node.rack(), node.isFenced() ? "fenced" : "unfenced", "broker"));
            }
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof UnsupportedVersionException) {
                stream.println(ee.getCause().getMessage());
            }
            throw ee;
        }
    }
}

