/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class UnassignBrokersCommand
implements CloudAdminCommand {
    @Override
    public String name() {
        return "unassign-brokers";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Unassigns brokers from their cell");
        parser.addArgument(new String[]{"--broker-ids"}).help("list of brokers to unassign separated by commas").action((ArgumentAction)Arguments.store()).type(String.class).required(true);
        parser.addArgument(new String[]{"--force"}).help("allows for brokers to be unassigned even if cell un-assignment is not in increment of cell size").action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).required(false);
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        String brokerIds = ns.getString("broker_ids");
        List unassignments = Arrays.stream(brokerIds.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        boolean force = Optional.ofNullable(ns.getBoolean("force")).orElse(false);
        try {
            admin.unassignBrokersFromCell(unassignments, force).value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to unassign brokers from their cell", e.getCause());
            return;
        }
        CellsAdminCommand.printMessageAndExit(out, "Successfully unassigned brokers " + brokerIds);
    }
}

