/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class UnassignTenantsCommand
implements CloudAdminCommand {
    @Override
    public String name() {
        return "unassign-tenants";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Unassigns tenants from their cell");
        parser.addArgument(new String[]{"--tenant-ids"}).help("list of tenants to unassign separated by commas").action((ArgumentAction)Arguments.store()).type(String.class).required(true);
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        String tenantIds = ns.getString("tenant_ids");
        List unassignments = Arrays.stream(tenantIds.split(",")).collect(Collectors.toList());
        try {
            admin.deleteTenants(unassignments).value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to unassign tenants from their cell", e.getCause());
            return;
        }
        CellsAdminCommand.printMessageAndExit(out, "Successfully unassigned tenants " + tenantIds);
    }
}

