/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.io.PrintStream;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;

public class DuplicateMessageFormatter
implements MessageFormatter {
    public static final int DEFAULT_WINDOW_SIZE = 10000000;
    private MessageDigest messageDigest;
    private int windowSize = 10000000;
    private final Map<Integer, PartitionMessages> partitions = new HashMap<Integer, PartitionMessages>();

    public void configure(Map<String, ?> configs) {
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize MD5 MessageDigest", e);
        }
        if (configs.containsKey("window.size")) {
            this.windowSize = Integer.parseInt((String)configs.get("window.size"));
            if (this.windowSize <= 1) {
                throw new IllegalArgumentException("Window size must be greater than 1");
            }
        }
    }

    public void close() {
        this.partitions.clear();
    }

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        PartitionMessages partitionMessages = this.partitions.computeIfAbsent(consumerRecord.partition(), k -> new PartitionMessages());
        if (consumerRecord.key() != null) {
            this.messageDigest.update((byte[])consumerRecord.key());
        }
        if (consumerRecord.value() != null) {
            this.messageDigest.update((byte[])consumerRecord.value());
        }
        MessageKey key = new MessageKey(this.messageDigest.digest());
        MessageInfo newMessageInfo = new MessageInfo(key, consumerRecord.offset());
        MessageInfo oldMessageInfo = partitionMessages.messageMap.put(key, newMessageInfo);
        partitionMessages.messageQueue.add(newMessageInfo);
        if (oldMessageInfo != null) {
            output.println(consumerRecord.partition() + ":" + newMessageInfo.offset + "-" + oldMessageInfo.offset + ":" + consumerRecord.timestamp());
        }
        if (partitionMessages.messageQueue.size() > this.windowSize) {
            MessageInfo removedMessage = partitionMessages.messageQueue.poll();
            partitionMessages.messageMap.remove(removedMessage.key, removedMessage);
        }
    }

    static class PartitionMessages {
        public final Queue<MessageInfo> messageQueue = new ArrayDeque<MessageInfo>();
        public final Map<MessageKey, MessageInfo> messageMap = new HashMap<MessageKey, MessageInfo>();

        PartitionMessages() {
        }
    }

    static class MessageKey {
        public final byte[] md5;

        public MessageKey(byte[] md5) {
            this.md5 = md5;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageKey that = (MessageKey)o;
            return Arrays.equals(this.md5, that.md5);
        }

        public int hashCode() {
            return Arrays.hashCode(this.md5);
        }
    }

    static class MessageInfo {
        public final MessageKey key;
        public final long offset;

        public MessageInfo(MessageKey key, long offset) {
            this.key = key;
            this.offset = offset;
        }
    }
}

