/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.tenantplacementadvisor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import org.apache.kafka.tools.tenantplacementadvisor.DefaultLoadMetric;
import org.apache.kafka.tools.tenantplacementadvisor.Tenant;
import org.apache.kafka.tools.tenantplacementadvisor.TenantLoad;
import org.apache.kafka.tools.tenantplacementadvisor.TenantLoadFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTenantLoadFunction
implements TenantLoadFunction {
    private static final Logger log = LoggerFactory.getLogger(DefaultTenantLoadFunction.class);
    static final String CONFLUENT_SERVER_PREFIX_ENV = "confluent.server.prefix";
    static final String METRICS_API_URL_ENV = "metrics.api.url";
    static final String JWT_AUTH_TOKEN_ENV = "auth.token";
    private final ObjectMapper mapper;
    private final URL metricsApiUrl;
    private final List<DefaultLoadMetric> metrics;
    private final Interval interval;
    private final String jwt;
    private final String confluentServerPrefix;
    private static final String REQUEST_BODY = "{ \"group_by\": [ \"resource.kafka.id\" ], \"aggregations\": [{ \"metric\": \"%s%s\", \"agg\": \"SUM\" }],\"filter\": { \"field\": \"resource.kafka.id\", \"op\": \"EQ\", \"value\": \"%s\" }, \"granularity\": \"ALL\", \"intervals\" : [ \"%s\" ] }";

    public DefaultTenantLoadFunction(Interval interval, DefaultLoadMetric ... metrics) throws MalformedURLException {
        this(new URL(Objects.requireNonNull(System.getProperty(METRICS_API_URL_ENV), String.format("Property $%s must be set for DefaultTenantLoadFunction initialization", METRICS_API_URL_ENV))), new ObjectMapper(), interval, metrics);
    }

    public DefaultTenantLoadFunction() throws MalformedURLException {
        this(Interval.LAST_HOUR, DefaultLoadMetric.values());
    }

    DefaultTenantLoadFunction(URL metricsApiUrl, ObjectMapper mapper, Interval interval, DefaultLoadMetric ... metrics) {
        this.interval = interval;
        if ((long)metrics.length != Arrays.stream(metrics).distinct().count()) {
            throw new IllegalArgumentException("Was not able to construct DefaultTenantLoadFunction: duplicate metric names provided");
        }
        this.metrics = Collections.unmodifiableList(Arrays.asList(metrics));
        this.mapper = mapper;
        String propertyNotSet = "Property $%s must be set for DefaultTenantLoadFunction initialization";
        this.jwt = Objects.requireNonNull(System.getProperty(JWT_AUTH_TOKEN_ENV), String.format(propertyNotSet, JWT_AUTH_TOKEN_ENV));
        this.metricsApiUrl = metricsApiUrl;
        String confluentServerPrefixUnformatted = Objects.requireNonNull(System.getProperty(CONFLUENT_SERVER_PREFIX_ENV), String.format(propertyNotSet, CONFLUENT_SERVER_PREFIX_ENV));
        this.confluentServerPrefix = confluentServerPrefixUnformatted.endsWith("/") ? confluentServerPrefixUnformatted : confluentServerPrefixUnformatted.substring(0, confluentServerPrefixUnformatted.length() - 1) + "/";
    }

    @Override
    public Optional<TenantLoad> getTenantLoad(String tenantId) {
        HashMap<String, Number> namedMetrics = new HashMap<String, Number>();
        for (DefaultLoadMetric metric : this.metrics) {
            try {
                namedMetrics.put(metric.getVal(), this.getMetricValue(tenantId, metric, this.interval));
            }
            catch (IOException e) {
                log.warn("Was not able to construct TenantLoad: request to metrics API not successful");
                throw new RuntimeException(e);
            }
        }
        return Optional.of(new TenantLoad(new Tenant(tenantId), namedMetrics));
    }

    private double getMetricValue(String tenantId, DefaultLoadMetric metric, Interval interval) throws IOException {
        String bodyFormatted = String.format(REQUEST_BODY, this.confluentServerPrefix, metric.getVal(), tenantId, interval.val);
        return this.parseHttpResponse(this.makeApiClientRequest(bodyFormatted));
    }

    private String makeApiClientRequest(String bodyFormatted) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.metricsApiUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestProperty("Authorization", "Bearer " + this.jwt);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "*/*");
        connection.setUseCaches(false);
        byte[] data = bodyFormatted.getBytes();
        connection.setRequestProperty("Content-Length", Integer.toString(data.length));
        OutputStream os = connection.getOutputStream();
        os.write(data);
        int status = connection.getResponseCode();
        if (status != 200) {
            throw new IOException("Could not successfully make request: error code " + status);
        }
        return DefaultTenantLoadFunction.readResponse(connection.getInputStream());
    }

    private double parseHttpResponse(String response) throws JsonProcessingException {
        ArrayNode responseArray = (ArrayNode)this.mapper.readTree(response).get("data");
        if (responseArray.size() == 0) {
            return 0.0;
        }
        if (responseArray.size() != 1 || responseArray.get(0).size() != 3) {
            throw new IllegalStateException("Unexpected response format from metrics API");
        }
        return responseArray.get(0).get("value").doubleValue();
    }

    private static String readResponse(InputStream is) {
        try (Scanner s = new Scanner(is, StandardCharsets.UTF_8.name()).useDelimiter("\\A");){
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    public static void main(String[] args) throws MalformedURLException {
        new DefaultTenantLoadFunction().getTenantLoad("your_tenant_id_here");
    }

    static enum Interval {
        LAST_HOUR("now-1h/PT1H");

        private final String val;

        private Interval(String val) {
            this.val = val;
        }
    }
}

