/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BlockingBucket;
import io.github.bucket4j.BlockingStrategy;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.LimitChecker;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.SchedulingBucket;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.UninterruptibleBlockingStrategy;
import io.github.bucket4j.VerboseBlockingBucket;
import io.github.bucket4j.VerboseBucket;
import io.github.bucket4j.VerboseResult;
import io.github.bucket4j.VerboseSchedulingBucket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class AbstractBucket
implements Bucket {
    protected static final long INFINITY_DURATION = Long.MAX_VALUE;
    protected static final long UNLIMITED_AMOUNT = Long.MAX_VALUE;
    private final BucketListener listener;
    private final VerboseBucket verboseView = new VerboseBucket(){

        @Override
        public VerboseResult<Boolean> tryConsume(long tokensToConsume) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            VerboseResult<Boolean> result = AbstractBucket.this.tryConsumeVerboseImpl(tokensToConsume);
            if (result.getValue().booleanValue()) {
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
            } else {
                AbstractBucket.this.listener.onRejected(tokensToConsume);
            }
            return result;
        }

        @Override
        public VerboseResult<Long> consumeIgnoringRateLimits(long tokens) {
            LimitChecker.checkTokensToConsume(tokens);
            VerboseResult<Long> result = AbstractBucket.this.consumeIgnoringRateLimitsVerboseImpl(tokens);
            long penaltyNanos = result.getValue();
            if (penaltyNanos == Long.MAX_VALUE) {
                throw BucketExceptions.reservationOverflow();
            }
            AbstractBucket.this.listener.onConsumed(tokens);
            return result;
        }

        @Override
        public VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemaining(long tokensToConsume) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            VerboseResult<ConsumptionProbe> result = AbstractBucket.this.tryConsumeAndReturnRemainingTokensVerboseImpl(tokensToConsume);
            ConsumptionProbe probe = result.getValue();
            if (probe.isConsumed()) {
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
            } else {
                AbstractBucket.this.listener.onRejected(tokensToConsume);
            }
            return result;
        }

        @Override
        public VerboseResult<EstimationProbe> estimateAbilityToConsume(long numTokens) {
            LimitChecker.checkTokensToConsume(numTokens);
            return AbstractBucket.this.estimateAbilityToConsumeVerboseImpl(numTokens);
        }

        @Override
        public VerboseResult<Long> tryConsumeAsMuchAsPossible() {
            VerboseResult<Long> result = AbstractBucket.this.consumeAsMuchAsPossibleVerboseImpl(Long.MAX_VALUE);
            long consumed = result.getValue();
            if (consumed > 0L) {
                AbstractBucket.this.listener.onConsumed(consumed);
            }
            return result;
        }

        @Override
        public VerboseResult<Long> tryConsumeAsMuchAsPossible(long limit) {
            LimitChecker.checkTokensToConsume(limit);
            VerboseResult<Long> result = AbstractBucket.this.consumeAsMuchAsPossibleVerboseImpl(limit);
            long consumed = result.getValue();
            if (consumed > 0L) {
                AbstractBucket.this.listener.onConsumed(consumed);
            }
            return result;
        }

        @Override
        public VerboseResult<Long> getAvailableTokens() {
            return AbstractBucket.this.getAvailableTokensVerboseImpl();
        }

        @Override
        public VerboseResult<Nothing> addTokens(long tokensToAdd) {
            LimitChecker.checkTokensToAdd(tokensToAdd);
            return AbstractBucket.this.addTokensVerboseImpl(tokensToAdd);
        }

        @Override
        public VerboseResult<Nothing> reset() {
            return AbstractBucket.this.resetVerboseImpl();
        }

        @Override
        public VerboseResult<Nothing> forceAddTokens(long tokensToAdd) {
            LimitChecker.checkTokensToAdd(tokensToAdd);
            return AbstractBucket.this.forceAddTokensVerboseImpl(tokensToAdd);
        }

        @Override
        public VerboseResult<Nothing> replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
            LimitChecker.checkConfiguration(newConfiguration);
            LimitChecker.checkMigrationMode(tokensInheritanceStrategy);
            return AbstractBucket.this.replaceConfigurationVerboseImpl(newConfiguration, tokensInheritanceStrategy);
        }
    };
    private final BlockingBucket blockingView = new BlockingBucket(){

        @Override
        public boolean tryConsume(long tokensToConsume, long maxWaitTimeNanos, BlockingStrategy blockingStrategy) throws InterruptedException {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkMaxWaitTime(maxWaitTimeNanos);
            long nanosToSleep = AbstractBucket.this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
            if (nanosToSleep == Long.MAX_VALUE) {
                AbstractBucket.this.listener.onRejected(tokensToConsume);
                return false;
            }
            AbstractBucket.this.listener.onConsumed(tokensToConsume);
            if (nanosToSleep > 0L) {
                try {
                    AbstractBucket.this.listener.beforeParking(nanosToSleep);
                    blockingStrategy.park(nanosToSleep);
                }
                catch (InterruptedException e) {
                    AbstractBucket.this.listener.onInterrupted(e);
                    throw e;
                }
                AbstractBucket.this.listener.onParked(nanosToSleep);
            }
            return true;
        }

        @Override
        public boolean tryConsumeUninterruptibly(long tokensToConsume, long maxWaitTimeNanos, UninterruptibleBlockingStrategy blockingStrategy) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkMaxWaitTime(maxWaitTimeNanos);
            long nanosToSleep = AbstractBucket.this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
            if (nanosToSleep == Long.MAX_VALUE) {
                AbstractBucket.this.listener.onRejected(tokensToConsume);
                return false;
            }
            AbstractBucket.this.listener.onConsumed(tokensToConsume);
            if (nanosToSleep > 0L) {
                AbstractBucket.this.listener.beforeParking(nanosToSleep);
                blockingStrategy.parkUninterruptibly(nanosToSleep);
                AbstractBucket.this.listener.onParked(nanosToSleep);
            }
            return true;
        }

        @Override
        public void consume(long tokensToConsume, BlockingStrategy blockingStrategy) throws InterruptedException {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            long nanosToSleep = AbstractBucket.this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, Long.MAX_VALUE);
            if (nanosToSleep == Long.MAX_VALUE) {
                throw BucketExceptions.reservationOverflow();
            }
            AbstractBucket.this.listener.onConsumed(tokensToConsume);
            if (nanosToSleep > 0L) {
                try {
                    AbstractBucket.this.listener.beforeParking(nanosToSleep);
                    blockingStrategy.park(nanosToSleep);
                }
                catch (InterruptedException e) {
                    AbstractBucket.this.listener.onInterrupted(e);
                    throw e;
                }
                AbstractBucket.this.listener.onParked(nanosToSleep);
            }
        }

        @Override
        public void consumeUninterruptibly(long tokensToConsume, UninterruptibleBlockingStrategy blockingStrategy) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            long nanosToSleep = AbstractBucket.this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, Long.MAX_VALUE);
            if (nanosToSleep == Long.MAX_VALUE) {
                throw BucketExceptions.reservationOverflow();
            }
            AbstractBucket.this.listener.onConsumed(tokensToConsume);
            if (nanosToSleep > 0L) {
                AbstractBucket.this.listener.beforeParking(nanosToSleep);
                blockingStrategy.parkUninterruptibly(nanosToSleep);
                AbstractBucket.this.listener.onParked(nanosToSleep);
            }
        }

        @Override
        public VerboseBlockingBucket asVerbose() {
            return AbstractBucket.this.verboseBlockingView;
        }
    };
    private final SchedulingBucket schedulingBucketView = new SchedulingBucket(){

        @Override
        public CompletableFuture<Boolean> tryConsume(long tokensToConsume, long maxWaitTimeNanos, ScheduledExecutorService scheduler) {
            LimitChecker.checkMaxWaitTime(maxWaitTimeNanos);
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkScheduler(scheduler);
            try {
                long nanosToSleep = AbstractBucket.this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
                if (nanosToSleep == Long.MAX_VALUE) {
                    AbstractBucket.this.listener.onRejected(tokensToConsume);
                    return CompletableFuture.completedFuture(false);
                }
                if (nanosToSleep == 0L) {
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                    return CompletableFuture.completedFuture(true);
                }
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
                AbstractBucket.this.listener.onDelayed(nanosToSleep);
                CompletableFuture<Boolean> resultFuture = new CompletableFuture<Boolean>();
                Runnable delayedCompletion = () -> resultFuture.complete(true);
                scheduler.schedule(delayedCompletion, nanosToSleep, TimeUnit.NANOSECONDS);
                return resultFuture;
            }
            catch (Throwable t) {
                return AbstractBucket.failedFuture(t);
            }
        }

        @Override
        public CompletableFuture<Void> consume(long tokensToConsume, ScheduledExecutorService scheduler) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkScheduler(scheduler);
            try {
                long nanosToSleep = AbstractBucket.this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, Long.MAX_VALUE);
                if (nanosToSleep == Long.MAX_VALUE) {
                    return AbstractBucket.failedFuture(BucketExceptions.reservationOverflow());
                }
                if (nanosToSleep == 0L) {
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                    return CompletableFuture.completedFuture(null);
                }
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
                AbstractBucket.this.listener.onDelayed(nanosToSleep);
                CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
                Runnable delayedCompletion = () -> resultFuture.complete(null);
                scheduler.schedule(delayedCompletion, nanosToSleep, TimeUnit.NANOSECONDS);
                return resultFuture;
            }
            catch (Throwable t) {
                return AbstractBucket.failedFuture(t);
            }
        }

        @Override
        public VerboseSchedulingBucket asVerbose() {
            return AbstractBucket.this.verboseSchedulingView;
        }
    };
    private final VerboseSchedulingBucket verboseSchedulingView = new VerboseSchedulingBucket(){

        @Override
        public CompletableFuture<VerboseResult<Boolean>> tryConsume(long tokensToConsume, long maxWaitTimeNanos, ScheduledExecutorService scheduler) {
            LimitChecker.checkMaxWaitTime(maxWaitTimeNanos);
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkScheduler(scheduler);
            try {
                VerboseResult<Long> nanosToSleepVerbose = AbstractBucket.this.reserveAndCalculateTimeToSleepVerboseImpl(tokensToConsume, maxWaitTimeNanos);
                long nanosToSleep = nanosToSleepVerbose.getValue();
                if (nanosToSleep == Long.MAX_VALUE) {
                    AbstractBucket.this.listener.onRejected(tokensToConsume);
                    return CompletableFuture.completedFuture(nanosToSleepVerbose.withValue(false));
                }
                if (nanosToSleep == 0L) {
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                    return CompletableFuture.completedFuture(nanosToSleepVerbose.withValue(true));
                }
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
                AbstractBucket.this.listener.onDelayed(nanosToSleep);
                CompletableFuture<VerboseResult<Boolean>> resultFuture = new CompletableFuture<VerboseResult<Boolean>>();
                Runnable delayedCompletion = () -> resultFuture.complete(nanosToSleepVerbose.withValue(true));
                scheduler.schedule(delayedCompletion, nanosToSleep, TimeUnit.NANOSECONDS);
                return resultFuture;
            }
            catch (Throwable t) {
                return AbstractBucket.failedFuture(t);
            }
        }

        @Override
        public CompletableFuture<VerboseResult<Void>> consume(long tokensToConsume, ScheduledExecutorService scheduler) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkScheduler(scheduler);
            try {
                VerboseResult<Long> nanosToSleepVerbose = AbstractBucket.this.reserveAndCalculateTimeToSleepVerboseImpl(tokensToConsume, Long.MAX_VALUE);
                long nanosToSleep = nanosToSleepVerbose.getValue();
                if (nanosToSleep == Long.MAX_VALUE) {
                    return AbstractBucket.failedFuture(BucketExceptions.reservationOverflow());
                }
                if (nanosToSleep == 0L) {
                    AbstractBucket.this.listener.onConsumed(tokensToConsume);
                    return CompletableFuture.completedFuture(nanosToSleepVerbose.withValue(null));
                }
                AbstractBucket.this.listener.onConsumed(tokensToConsume);
                AbstractBucket.this.listener.onDelayed(nanosToSleep);
                CompletableFuture<VerboseResult<Void>> resultFuture = new CompletableFuture<VerboseResult<Void>>();
                Runnable delayedCompletion = () -> resultFuture.complete(nanosToSleepVerbose.withValue(null));
                scheduler.schedule(delayedCompletion, nanosToSleep, TimeUnit.NANOSECONDS);
                return resultFuture;
            }
            catch (Throwable t) {
                return AbstractBucket.failedFuture(t);
            }
        }
    };
    private final VerboseBlockingBucket verboseBlockingView = new VerboseBlockingBucket(){

        @Override
        public VerboseResult<Boolean> tryConsume(long tokensToConsume, long maxWaitTimeNanos, BlockingStrategy blockingStrategy) throws InterruptedException {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkMaxWaitTime(maxWaitTimeNanos);
            VerboseResult<Long> nanosToSleepVerbose = AbstractBucket.this.reserveAndCalculateTimeToSleepVerboseImpl(tokensToConsume, maxWaitTimeNanos);
            long nanosToSleep = nanosToSleepVerbose.getValue();
            if (nanosToSleep == Long.MAX_VALUE) {
                AbstractBucket.this.listener.onRejected(tokensToConsume);
                return nanosToSleepVerbose.withValue(false);
            }
            AbstractBucket.this.listener.onConsumed(tokensToConsume);
            if (nanosToSleep > 0L) {
                try {
                    AbstractBucket.this.listener.beforeParking(nanosToSleep);
                    blockingStrategy.park(nanosToSleep);
                }
                catch (InterruptedException e) {
                    AbstractBucket.this.listener.onInterrupted(e);
                    throw e;
                }
                AbstractBucket.this.listener.onParked(nanosToSleep);
            }
            return nanosToSleepVerbose.withValue(true);
        }

        @Override
        public VerboseResult<Boolean> tryConsumeUninterruptibly(long tokensToConsume, long maxWaitTimeNanos, UninterruptibleBlockingStrategy blockingStrategy) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkMaxWaitTime(maxWaitTimeNanos);
            VerboseResult<Long> nanosToSleepVerbose = AbstractBucket.this.reserveAndCalculateTimeToSleepVerboseImpl(tokensToConsume, maxWaitTimeNanos);
            long nanosToSleep = nanosToSleepVerbose.getValue();
            if (nanosToSleep == Long.MAX_VALUE) {
                AbstractBucket.this.listener.onRejected(tokensToConsume);
                return nanosToSleepVerbose.withValue(false);
            }
            AbstractBucket.this.listener.onConsumed(tokensToConsume);
            if (nanosToSleep > 0L) {
                AbstractBucket.this.listener.beforeParking(nanosToSleep);
                blockingStrategy.parkUninterruptibly(nanosToSleep);
                AbstractBucket.this.listener.onParked(nanosToSleep);
            }
            return nanosToSleepVerbose.withValue(true);
        }

        @Override
        public VerboseResult<Void> consume(long tokensToConsume, BlockingStrategy blockingStrategy) throws InterruptedException {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            VerboseResult<Long> nanosToSleepVerbose = AbstractBucket.this.reserveAndCalculateTimeToSleepVerboseImpl(tokensToConsume, Long.MAX_VALUE);
            long nanosToSleep = nanosToSleepVerbose.getValue();
            if (nanosToSleep == Long.MAX_VALUE) {
                throw BucketExceptions.reservationOverflow();
            }
            AbstractBucket.this.listener.onConsumed(tokensToConsume);
            if (nanosToSleep > 0L) {
                try {
                    AbstractBucket.this.listener.beforeParking(nanosToSleep);
                    blockingStrategy.park(nanosToSleep);
                }
                catch (InterruptedException e) {
                    AbstractBucket.this.listener.onInterrupted(e);
                    throw e;
                }
                AbstractBucket.this.listener.onParked(nanosToSleep);
            }
            return nanosToSleepVerbose.withValue(null);
        }

        @Override
        public VerboseResult<Void> consumeUninterruptibly(long tokensToConsume, UninterruptibleBlockingStrategy blockingStrategy) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            VerboseResult<Long> nanosToSleepVerbose = AbstractBucket.this.reserveAndCalculateTimeToSleepVerboseImpl(tokensToConsume, Long.MAX_VALUE);
            long nanosToSleep = nanosToSleepVerbose.getValue();
            if (nanosToSleep == Long.MAX_VALUE) {
                throw BucketExceptions.reservationOverflow();
            }
            AbstractBucket.this.listener.onConsumed(tokensToConsume);
            if (nanosToSleep > 0L) {
                AbstractBucket.this.listener.beforeParking(nanosToSleep);
                blockingStrategy.parkUninterruptibly(nanosToSleep);
                AbstractBucket.this.listener.onParked(nanosToSleep);
            }
            return nanosToSleepVerbose.withValue(null);
        }
    };

    protected abstract long consumeAsMuchAsPossibleImpl(long var1);

    protected abstract boolean tryConsumeImpl(long var1);

    protected abstract ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long var1);

    protected abstract EstimationProbe estimateAbilityToConsumeImpl(long var1);

    protected abstract long reserveAndCalculateTimeToSleepImpl(long var1, long var3);

    protected abstract void addTokensImpl(long var1);

    protected abstract void forceAddTokensImpl(long var1);

    protected abstract void replaceConfigurationImpl(BucketConfiguration var1, TokensInheritanceStrategy var2);

    protected abstract long consumeIgnoringRateLimitsImpl(long var1);

    protected abstract VerboseResult<Long> consumeAsMuchAsPossibleVerboseImpl(long var1);

    protected abstract VerboseResult<Boolean> tryConsumeVerboseImpl(long var1);

    protected abstract VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemainingTokensVerboseImpl(long var1);

    protected abstract VerboseResult<EstimationProbe> estimateAbilityToConsumeVerboseImpl(long var1);

    protected abstract VerboseResult<Long> getAvailableTokensVerboseImpl();

    protected abstract VerboseResult<Nothing> addTokensVerboseImpl(long var1);

    protected abstract VerboseResult<Nothing> forceAddTokensVerboseImpl(long var1);

    protected abstract VerboseResult<Nothing> resetVerboseImpl();

    protected abstract VerboseResult<Nothing> replaceConfigurationVerboseImpl(BucketConfiguration var1, TokensInheritanceStrategy var2);

    protected abstract VerboseResult<Long> consumeIgnoringRateLimitsVerboseImpl(long var1);

    protected abstract VerboseResult<Long> reserveAndCalculateTimeToSleepVerboseImpl(long var1, long var3);

    public AbstractBucket(BucketListener listener) {
        if (listener == null) {
            throw BucketExceptions.nullListener();
        }
        this.listener = listener;
    }

    @Override
    public SchedulingBucket asScheduler() {
        return this.schedulingBucketView;
    }

    @Override
    public VerboseBucket asVerbose() {
        return this.verboseView;
    }

    @Override
    public BlockingBucket asBlocking() {
        return this.blockingView;
    }

    @Override
    public boolean tryConsume(long tokensToConsume) {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        if (this.tryConsumeImpl(tokensToConsume)) {
            this.listener.onConsumed(tokensToConsume);
            return true;
        }
        this.listener.onRejected(tokensToConsume);
        return false;
    }

    @Override
    public long consumeIgnoringRateLimits(long tokens) {
        LimitChecker.checkTokensToConsume(tokens);
        long penaltyNanos = this.consumeIgnoringRateLimitsImpl(tokens);
        if (penaltyNanos == Long.MAX_VALUE) {
            throw BucketExceptions.reservationOverflow();
        }
        this.listener.onConsumed(tokens);
        return penaltyNanos;
    }

    @Override
    public long tryConsumeAsMuchAsPossible(long limit) {
        LimitChecker.checkTokensToConsume(limit);
        long consumed = this.consumeAsMuchAsPossibleImpl(limit);
        if (consumed > 0L) {
            this.listener.onConsumed(consumed);
        }
        return consumed;
    }

    @Override
    public long tryConsumeAsMuchAsPossible() {
        long consumed = this.consumeAsMuchAsPossibleImpl(Long.MAX_VALUE);
        if (consumed > 0L) {
            this.listener.onConsumed(consumed);
        }
        return consumed;
    }

    @Override
    public ConsumptionProbe tryConsumeAndReturnRemaining(long tokensToConsume) {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        ConsumptionProbe probe = this.tryConsumeAndReturnRemainingTokensImpl(tokensToConsume);
        if (probe.isConsumed()) {
            this.listener.onConsumed(tokensToConsume);
        } else {
            this.listener.onRejected(tokensToConsume);
        }
        return probe;
    }

    @Override
    public EstimationProbe estimateAbilityToConsume(long numTokens) {
        LimitChecker.checkTokensToConsume(numTokens);
        return this.estimateAbilityToConsumeImpl(numTokens);
    }

    @Override
    public void addTokens(long tokensToAdd) {
        LimitChecker.checkTokensToAdd(tokensToAdd);
        this.addTokensImpl(tokensToAdd);
    }

    @Override
    public void forceAddTokens(long tokensToAdd) {
        LimitChecker.checkTokensToAdd(tokensToAdd);
        this.forceAddTokensImpl(tokensToAdd);
    }

    @Override
    public void replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        LimitChecker.checkConfiguration(newConfiguration);
        LimitChecker.checkMigrationMode(tokensInheritanceStrategy);
        this.replaceConfigurationImpl(newConfiguration, tokensInheritanceStrategy);
    }

    protected BucketListener getListener() {
        return this.listener;
    }

    public static <T> CompletableFuture<T> completedFuture(Supplier<T> supplier) {
        try {
            return CompletableFuture.completedFuture(supplier.get());
        }
        catch (Throwable t) {
            CompletableFuture fail = new CompletableFuture();
            fail.completeExceptionally(t);
            return fail;
        }
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable t) {
        CompletableFuture fail = new CompletableFuture();
        fail.completeExceptionally(t);
        return fail;
    }
}

