/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.jdbc;

import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public interface CustomColumnProvider<K> {
    public void setCustomField(K var1, int var2, PreparedStatement var3, RemoteBucketState var4, long var5) throws SQLException;

    public String getCustomFieldName();

    public static <K> CustomColumnProvider<K> createExpiresInColumnProvider(final String expiresAtColumn, final ExpirationAfterWriteStrategy expiration) {
        return new CustomColumnProvider<K>(){

            @Override
            public void setCustomField(K key, int paramIndex, PreparedStatement statement, RemoteBucketState state, long currentTimeNanos) throws SQLException {
                long ttlMillis = expiration.calculateTimeToLiveMillis(state, currentTimeNanos);
                statement.setLong(paramIndex, ttlMillis < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + ttlMillis);
            }

            @Override
            public String getCustomFieldName() {
                return expiresAtColumn;
            }
        };
    }
}

