/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.LimitChecker;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.SchedulingBucket;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.VerboseResult;
import io.github.bucket4j.VerboseSchedulingBucket;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.distributed.AsyncOptimizationController;
import io.github.bucket4j.distributed.AsyncVerboseBucket;
import io.github.bucket4j.distributed.proxy.AsyncCommandExecutor;
import io.github.bucket4j.distributed.proxy.BucketNotFoundException;
import io.github.bucket4j.distributed.proxy.ImplicitConfigurationReplacement;
import io.github.bucket4j.distributed.proxy.RecoveryStrategy;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.RemoteVerboseResult;
import io.github.bucket4j.distributed.remote.commands.AddTokensCommand;
import io.github.bucket4j.distributed.remote.commands.CheckConfigurationVersionAndExecuteCommand;
import io.github.bucket4j.distributed.remote.commands.ConsumeAsMuchAsPossibleCommand;
import io.github.bucket4j.distributed.remote.commands.ConsumeIgnoringRateLimitsCommand;
import io.github.bucket4j.distributed.remote.commands.CreateInitialStateAndExecuteCommand;
import io.github.bucket4j.distributed.remote.commands.CreateInitialStateWithVersionOrReplaceConfigurationAndExecuteCommand;
import io.github.bucket4j.distributed.remote.commands.EstimateAbilityToConsumeCommand;
import io.github.bucket4j.distributed.remote.commands.ForceAddTokensCommand;
import io.github.bucket4j.distributed.remote.commands.GetAvailableTokensCommand;
import io.github.bucket4j.distributed.remote.commands.ReplaceConfigurationCommand;
import io.github.bucket4j.distributed.remote.commands.ReserveAndCalculateTimeToSleepCommand;
import io.github.bucket4j.distributed.remote.commands.ResetCommand;
import io.github.bucket4j.distributed.remote.commands.SyncCommand;
import io.github.bucket4j.distributed.remote.commands.TryConsumeAndReturnRemainingTokensCommand;
import io.github.bucket4j.distributed.remote.commands.TryConsumeCommand;
import io.github.bucket4j.distributed.remote.commands.VerboseCommand;
import io.github.bucket4j.util.ComparableByContent;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class DefaultAsyncBucketProxy
implements AsyncBucketProxy,
AsyncOptimizationController {
    private final AsyncCommandExecutor commandExecutor;
    private final RecoveryStrategy recoveryStrategy;
    private final Supplier<CompletableFuture<BucketConfiguration>> configurationSupplier;
    private final BucketListener listener;
    private final ImplicitConfigurationReplacement implicitConfigurationReplacement;
    private final AtomicBoolean wasInitialized;
    private final AsyncVerboseBucket asyncVerboseView = new AsyncVerboseBucket(){

        @Override
        public CompletableFuture<VerboseResult<Boolean>> tryConsume(long tokensToConsume) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            VerboseCommand command = TryConsumeCommand.create(tokensToConsume).asVerbose();
            return DefaultAsyncBucketProxy.this.execute(command).thenApply(consumed -> {
                if (((Boolean)consumed.getValue()).booleanValue()) {
                    DefaultAsyncBucketProxy.this.listener.onConsumed(tokensToConsume);
                } else {
                    DefaultAsyncBucketProxy.this.listener.onRejected(tokensToConsume);
                }
                return consumed.asLocal();
            });
        }

        @Override
        public CompletableFuture<VerboseResult<Long>> consumeIgnoringRateLimits(long tokensToConsume) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            VerboseCommand<Long> command = VerboseCommand.from(new ConsumeIgnoringRateLimitsCommand(tokensToConsume));
            return DefaultAsyncBucketProxy.this.execute(command).thenApply(penaltyNanos -> {
                if ((Long)penaltyNanos.getValue() == Long.MAX_VALUE) {
                    throw BucketExceptions.reservationOverflow();
                }
                DefaultAsyncBucketProxy.this.listener.onConsumed(tokensToConsume);
                return penaltyNanos.asLocal();
            });
        }

        @Override
        public CompletableFuture<VerboseResult<ConsumptionProbe>> tryConsumeAndReturnRemaining(long tokensToConsume) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            VerboseCommand<ConsumptionProbe> command = VerboseCommand.from(new TryConsumeAndReturnRemainingTokensCommand(tokensToConsume));
            return DefaultAsyncBucketProxy.this.execute(command).thenApply(probe -> {
                if (((ConsumptionProbe)probe.getValue()).isConsumed()) {
                    DefaultAsyncBucketProxy.this.listener.onConsumed(tokensToConsume);
                } else {
                    DefaultAsyncBucketProxy.this.listener.onRejected(tokensToConsume);
                }
                return probe.asLocal();
            });
        }

        @Override
        public CompletableFuture<VerboseResult<EstimationProbe>> estimateAbilityToConsume(long numTokens) {
            LimitChecker.checkTokensToConsume(numTokens);
            return DefaultAsyncBucketProxy.this.execute(VerboseCommand.from(new EstimateAbilityToConsumeCommand(numTokens))).thenApply(RemoteVerboseResult::asLocal);
        }

        @Override
        public CompletableFuture<VerboseResult<Long>> tryConsumeAsMuchAsPossible() {
            VerboseCommand<Long> command = VerboseCommand.from(new ConsumeAsMuchAsPossibleCommand(Long.MAX_VALUE));
            return DefaultAsyncBucketProxy.this.execute(command).thenApply(consumedTokens -> {
                long actuallyConsumedTokens = (Long)consumedTokens.getValue();
                if (actuallyConsumedTokens > 0L) {
                    DefaultAsyncBucketProxy.this.listener.onConsumed(actuallyConsumedTokens);
                }
                return consumedTokens.asLocal();
            });
        }

        @Override
        public CompletableFuture<VerboseResult<Long>> tryConsumeAsMuchAsPossible(long limit) {
            LimitChecker.checkTokensToConsume(limit);
            VerboseCommand<Long> verboseCommand = VerboseCommand.from(new ConsumeAsMuchAsPossibleCommand(limit));
            return DefaultAsyncBucketProxy.this.execute(verboseCommand).thenApply(consumedTokens -> {
                long actuallyConsumedTokens = (Long)consumedTokens.getValue();
                if (actuallyConsumedTokens > 0L) {
                    DefaultAsyncBucketProxy.this.listener.onConsumed(actuallyConsumedTokens);
                }
                return consumedTokens.asLocal();
            });
        }

        @Override
        public CompletableFuture<VerboseResult<Nothing>> addTokens(long tokensToAdd) {
            LimitChecker.checkTokensToAdd(tokensToAdd);
            VerboseCommand<Nothing> verboseCommand = VerboseCommand.from(new AddTokensCommand(tokensToAdd));
            return DefaultAsyncBucketProxy.this.execute(verboseCommand).thenApply(RemoteVerboseResult::asLocal);
        }

        @Override
        public CompletableFuture<VerboseResult<Nothing>> forceAddTokens(long tokensToAdd) {
            LimitChecker.checkTokensToAdd(tokensToAdd);
            VerboseCommand<Nothing> verboseCommand = VerboseCommand.from(new ForceAddTokensCommand(tokensToAdd));
            return DefaultAsyncBucketProxy.this.execute(verboseCommand).thenApply(RemoteVerboseResult::asLocal);
        }

        @Override
        public CompletableFuture<VerboseResult<Nothing>> reset() {
            VerboseCommand<Nothing> verboseCommand = VerboseCommand.from(new ResetCommand());
            return DefaultAsyncBucketProxy.this.execute(verboseCommand).thenApply(RemoteVerboseResult::asLocal);
        }

        @Override
        public CompletableFuture<VerboseResult<Nothing>> replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
            LimitChecker.checkConfiguration(newConfiguration);
            LimitChecker.checkMigrationMode(tokensInheritanceStrategy);
            VerboseCommand<Nothing> command = VerboseCommand.from(new ReplaceConfigurationCommand(newConfiguration, tokensInheritanceStrategy));
            return DefaultAsyncBucketProxy.this.execute(command).thenApply(RemoteVerboseResult::asLocal);
        }

        @Override
        public CompletableFuture<VerboseResult<Long>> getAvailableTokens() {
            VerboseCommand<Long> command = VerboseCommand.from(new GetAvailableTokensCommand());
            return DefaultAsyncBucketProxy.this.execute(command).thenApply(RemoteVerboseResult::asLocal);
        }
    };
    private final SchedulingBucket schedulingBucketView = new SchedulingBucket(){

        @Override
        public CompletableFuture<Boolean> tryConsume(long tokensToConsume, long maxWaitTimeNanos, ScheduledExecutorService scheduler) {
            LimitChecker.checkMaxWaitTime(maxWaitTimeNanos);
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkScheduler(scheduler);
            CompletableFuture<Boolean> resultFuture = new CompletableFuture<Boolean>();
            ReserveAndCalculateTimeToSleepCommand consumeCommand = new ReserveAndCalculateTimeToSleepCommand(tokensToConsume, maxWaitTimeNanos);
            CompletableFuture<Long> reservationFuture = DefaultAsyncBucketProxy.this.execute(consumeCommand);
            reservationFuture.whenComplete((nanosToSleep, exception) -> {
                if (exception != null) {
                    resultFuture.completeExceptionally((Throwable)exception);
                    return;
                }
                if (nanosToSleep == Long.MAX_VALUE) {
                    resultFuture.complete(false);
                    DefaultAsyncBucketProxy.this.listener.onRejected(tokensToConsume);
                    return;
                }
                if (nanosToSleep == 0L) {
                    resultFuture.complete(true);
                    DefaultAsyncBucketProxy.this.listener.onConsumed(tokensToConsume);
                    return;
                }
                try {
                    DefaultAsyncBucketProxy.this.listener.onConsumed(tokensToConsume);
                    DefaultAsyncBucketProxy.this.listener.onDelayed((long)nanosToSleep);
                    Runnable delayedCompletion = () -> resultFuture.complete(true);
                    scheduler.schedule(delayedCompletion, (long)nanosToSleep, TimeUnit.NANOSECONDS);
                }
                catch (Throwable t) {
                    resultFuture.completeExceptionally(t);
                }
            });
            return resultFuture;
        }

        @Override
        public CompletableFuture<Void> consume(long tokensToConsume, ScheduledExecutorService scheduler) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkScheduler(scheduler);
            CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
            ReserveAndCalculateTimeToSleepCommand consumeCommand = new ReserveAndCalculateTimeToSleepCommand(tokensToConsume, Long.MAX_VALUE);
            CompletableFuture<Long> reservationFuture = DefaultAsyncBucketProxy.this.execute(consumeCommand);
            reservationFuture.whenComplete((nanosToSleep, exception) -> {
                if (exception != null) {
                    resultFuture.completeExceptionally((Throwable)exception);
                    return;
                }
                if (nanosToSleep == Long.MAX_VALUE) {
                    resultFuture.completeExceptionally(BucketExceptions.reservationOverflow());
                    return;
                }
                if (nanosToSleep == 0L) {
                    resultFuture.complete(null);
                    DefaultAsyncBucketProxy.this.listener.onConsumed(tokensToConsume);
                    return;
                }
                try {
                    DefaultAsyncBucketProxy.this.listener.onConsumed(tokensToConsume);
                    DefaultAsyncBucketProxy.this.listener.onDelayed((long)nanosToSleep);
                    Runnable delayedCompletion = () -> resultFuture.complete(null);
                    scheduler.schedule(delayedCompletion, (long)nanosToSleep, TimeUnit.NANOSECONDS);
                }
                catch (Throwable t) {
                    resultFuture.completeExceptionally(t);
                }
            });
            return resultFuture;
        }

        @Override
        public VerboseSchedulingBucket asVerbose() {
            return DefaultAsyncBucketProxy.this.verboseSchedulingView;
        }
    };
    private final VerboseSchedulingBucket verboseSchedulingView = new VerboseSchedulingBucket(){

        @Override
        public CompletableFuture<VerboseResult<Boolean>> tryConsume(long tokensToConsume, long maxWaitTimeNanos, ScheduledExecutorService scheduler) {
            LimitChecker.checkMaxWaitTime(maxWaitTimeNanos);
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkScheduler(scheduler);
            CompletableFuture<VerboseResult<Boolean>> resultFuture = new CompletableFuture<VerboseResult<Boolean>>();
            ReserveAndCalculateTimeToSleepCommand consumeCommand = new ReserveAndCalculateTimeToSleepCommand(tokensToConsume, maxWaitTimeNanos);
            CompletableFuture reservationFuture = DefaultAsyncBucketProxy.this.execute(consumeCommand.asVerbose());
            reservationFuture.whenComplete((nanosToSleepVerbose, exception) -> {
                if (exception != null) {
                    resultFuture.completeExceptionally((Throwable)exception);
                    return;
                }
                long nanosToSleep = (Long)nanosToSleepVerbose.getValue();
                if (nanosToSleep == Long.MAX_VALUE) {
                    resultFuture.complete(nanosToSleepVerbose.withValue(false).asLocal());
                    DefaultAsyncBucketProxy.this.listener.onRejected(tokensToConsume);
                    return;
                }
                if (nanosToSleep == 0L) {
                    resultFuture.complete(nanosToSleepVerbose.withValue(true).asLocal());
                    DefaultAsyncBucketProxy.this.listener.onConsumed(tokensToConsume);
                    return;
                }
                try {
                    DefaultAsyncBucketProxy.this.listener.onConsumed(tokensToConsume);
                    DefaultAsyncBucketProxy.this.listener.onDelayed(nanosToSleep);
                    Runnable delayedCompletion = () -> resultFuture.complete(nanosToSleepVerbose.withValue(true).asLocal());
                    scheduler.schedule(delayedCompletion, nanosToSleep, TimeUnit.NANOSECONDS);
                }
                catch (Throwable t) {
                    resultFuture.completeExceptionally(t);
                }
            });
            return resultFuture;
        }

        @Override
        public CompletableFuture<VerboseResult<Void>> consume(long tokensToConsume, ScheduledExecutorService scheduler) {
            LimitChecker.checkTokensToConsume(tokensToConsume);
            LimitChecker.checkScheduler(scheduler);
            CompletableFuture<VerboseResult<Void>> resultFuture = new CompletableFuture<VerboseResult<Void>>();
            ReserveAndCalculateTimeToSleepCommand consumeCommand = new ReserveAndCalculateTimeToSleepCommand(tokensToConsume, Long.MAX_VALUE);
            CompletableFuture reservationFuture = DefaultAsyncBucketProxy.this.execute(consumeCommand.asVerbose());
            reservationFuture.whenComplete((nanosToSleepVerbose, exception) -> {
                if (exception != null) {
                    resultFuture.completeExceptionally((Throwable)exception);
                    return;
                }
                long nanosToSleep = (Long)nanosToSleepVerbose.getValue();
                if (nanosToSleep == Long.MAX_VALUE) {
                    resultFuture.completeExceptionally(BucketExceptions.reservationOverflow());
                    return;
                }
                if (nanosToSleep == 0L) {
                    resultFuture.complete(nanosToSleepVerbose.withValue(null).asLocal());
                    DefaultAsyncBucketProxy.this.listener.onConsumed(tokensToConsume);
                    return;
                }
                try {
                    DefaultAsyncBucketProxy.this.listener.onConsumed(tokensToConsume);
                    DefaultAsyncBucketProxy.this.listener.onDelayed(nanosToSleep);
                    Runnable delayedCompletion = () -> resultFuture.complete(nanosToSleepVerbose.withValue(null).asLocal());
                    scheduler.schedule(delayedCompletion, nanosToSleep, TimeUnit.NANOSECONDS);
                }
                catch (Throwable t) {
                    resultFuture.completeExceptionally(t);
                }
            });
            return resultFuture;
        }
    };

    @Override
    public AsyncVerboseBucket asVerbose() {
        return this.asyncVerboseView;
    }

    @Override
    public AsyncBucketProxy toListenable(BucketListener listener) {
        return new DefaultAsyncBucketProxy(this.commandExecutor, this.recoveryStrategy, this.configurationSupplier, this.implicitConfigurationReplacement, this.wasInitialized, listener);
    }

    @Override
    public SchedulingBucket asScheduler() {
        return this.schedulingBucketView;
    }

    public DefaultAsyncBucketProxy(AsyncCommandExecutor commandExecutor, RecoveryStrategy recoveryStrategy, Supplier<CompletableFuture<BucketConfiguration>> configurationSupplier, ImplicitConfigurationReplacement implicitConfigurationReplacement, BucketListener listener) {
        this(commandExecutor, recoveryStrategy, configurationSupplier, implicitConfigurationReplacement, new AtomicBoolean(false), listener);
    }

    private DefaultAsyncBucketProxy(AsyncCommandExecutor commandExecutor, RecoveryStrategy recoveryStrategy, Supplier<CompletableFuture<BucketConfiguration>> configurationSupplier, ImplicitConfigurationReplacement implicitConfigurationReplacement, AtomicBoolean wasInitialized, BucketListener listener) {
        this.commandExecutor = Objects.requireNonNull(commandExecutor);
        this.recoveryStrategy = recoveryStrategy;
        this.configurationSupplier = configurationSupplier;
        this.implicitConfigurationReplacement = implicitConfigurationReplacement;
        this.wasInitialized = wasInitialized;
        if (listener == null) {
            throw BucketExceptions.nullListener();
        }
        this.listener = listener;
    }

    @Override
    public CompletableFuture<Long> consumeIgnoringRateLimits(long tokensToConsume) {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        return this.execute(new ConsumeIgnoringRateLimitsCommand(tokensToConsume)).thenApply(penaltyNanos -> {
            if (penaltyNanos == Long.MAX_VALUE) {
                throw BucketExceptions.reservationOverflow();
            }
            this.listener.onConsumed(tokensToConsume);
            return penaltyNanos;
        });
    }

    @Override
    public CompletableFuture<Boolean> tryConsume(long tokensToConsume) {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        return this.execute(TryConsumeCommand.create(tokensToConsume)).thenApply(consumed -> {
            if (consumed.booleanValue()) {
                this.listener.onConsumed(tokensToConsume);
            } else {
                this.listener.onRejected(tokensToConsume);
            }
            return consumed;
        });
    }

    @Override
    public CompletableFuture<ConsumptionProbe> tryConsumeAndReturnRemaining(long tokensToConsume) {
        LimitChecker.checkTokensToConsume(tokensToConsume);
        return this.execute(new TryConsumeAndReturnRemainingTokensCommand(tokensToConsume)).thenApply(probe -> {
            if (probe.isConsumed()) {
                this.listener.onConsumed(tokensToConsume);
            } else {
                this.listener.onRejected(tokensToConsume);
            }
            return probe;
        });
    }

    @Override
    public CompletableFuture<EstimationProbe> estimateAbilityToConsume(long numTokens) {
        LimitChecker.checkTokensToConsume(numTokens);
        return this.execute(new EstimateAbilityToConsumeCommand(numTokens));
    }

    @Override
    public CompletableFuture<Long> tryConsumeAsMuchAsPossible() {
        return this.execute(new ConsumeAsMuchAsPossibleCommand(Long.MAX_VALUE)).thenApply(consumedTokens -> {
            if (consumedTokens > 0L) {
                this.listener.onConsumed((long)consumedTokens);
            }
            return consumedTokens;
        });
    }

    @Override
    public CompletableFuture<Long> tryConsumeAsMuchAsPossible(long limit) {
        LimitChecker.checkTokensToConsume(limit);
        return this.execute(new ConsumeAsMuchAsPossibleCommand(limit)).thenApply(consumedTokens -> {
            if (consumedTokens > 0L) {
                this.listener.onConsumed((long)consumedTokens);
            }
            return consumedTokens;
        });
    }

    @Override
    public CompletableFuture<Void> replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        LimitChecker.checkConfiguration(newConfiguration);
        LimitChecker.checkMigrationMode(tokensInheritanceStrategy);
        ReplaceConfigurationCommand replaceConfigCommand = new ReplaceConfigurationCommand(newConfiguration, tokensInheritanceStrategy);
        CompletableFuture<Nothing> result = this.execute(replaceConfigCommand);
        return result.thenApply(nothing -> null);
    }

    @Override
    public CompletableFuture<Void> addTokens(long tokensToAdd) {
        LimitChecker.checkTokensToAdd(tokensToAdd);
        CompletableFuture<Nothing> future = this.execute(new AddTokensCommand(tokensToAdd));
        return future.thenApply(nothing -> null);
    }

    @Override
    public CompletableFuture<Void> forceAddTokens(long tokensToAdd) {
        LimitChecker.checkTokensToAdd(tokensToAdd);
        CompletableFuture<Nothing> future = this.execute(new ForceAddTokensCommand(tokensToAdd));
        return future.thenApply(nothing -> null);
    }

    @Override
    public CompletableFuture<Void> reset() {
        CompletableFuture<Nothing> future = this.execute(new ResetCommand());
        return future.thenApply(nothing -> null);
    }

    @Override
    public CompletableFuture<Long> getAvailableTokens() {
        return this.execute(new GetAvailableTokensCommand());
    }

    @Override
    public AsyncOptimizationController getOptimizationController() {
        return this;
    }

    @Override
    public CompletableFuture<Void> syncByCondition(long unsynchronizedTokens, Duration timeSinceLastSync) {
        return this.execute(new SyncCommand(unsynchronizedTokens, timeSinceLastSync.toNanos())).thenApply(nothing -> null);
    }

    private <T> CompletableFuture<T> execute(RemoteCommand<T> command) {
        CheckConfigurationVersionAndExecuteCommand commandToExecute = this.implicitConfigurationReplacement == null ? command : new CheckConfigurationVersionAndExecuteCommand(command, this.implicitConfigurationReplacement.getDesiredConfigurationVersion());
        boolean wasInitializedBeforeExecution = this.wasInitialized.get();
        CompletableFuture futureResult = this.commandExecutor.executeAsync(commandToExecute);
        return futureResult.thenCompose(cmdResult -> {
            CompletableFuture<BucketConfiguration> configurationFuture;
            if (!cmdResult.isBucketNotFound() && !cmdResult.isConfigurationNeedToBeReplaced()) {
                Object resultDate = cmdResult.getData();
                return CompletableFuture.completedFuture(resultDate);
            }
            if (cmdResult.isBucketNotFound() && this.recoveryStrategy == RecoveryStrategy.THROW_BUCKET_NOT_FOUND_EXCEPTION && wasInitializedBeforeExecution) {
                CompletableFuture failedFuture = new CompletableFuture();
                failedFuture.completeExceptionally(new BucketNotFoundException());
                return failedFuture;
            }
            try {
                configurationFuture = this.configurationSupplier.get();
            }
            catch (Throwable t) {
                CompletableFuture failedFuture = new CompletableFuture();
                failedFuture.completeExceptionally(t);
                return failedFuture;
            }
            if (configurationFuture == null) {
                CompletableFuture failedFuture = new CompletableFuture();
                failedFuture.completeExceptionally(BucketExceptions.nullConfigurationFuture());
                return failedFuture;
            }
            return configurationFuture.thenCompose(configuration -> {
                if (configuration == null) {
                    CompletableFuture failedFuture = new CompletableFuture();
                    failedFuture.completeExceptionally(BucketExceptions.nullConfiguration());
                    return failedFuture;
                }
                ComparableByContent<CreateInitialStateAndExecuteCommand> initAndExecuteCommand = this.implicitConfigurationReplacement == null ? new CreateInitialStateAndExecuteCommand((BucketConfiguration)configuration, command) : new CreateInitialStateWithVersionOrReplaceConfigurationAndExecuteCommand((BucketConfiguration)configuration, command, this.implicitConfigurationReplacement.getDesiredConfigurationVersion(), this.implicitConfigurationReplacement.getTokensInheritanceStrategy());
                return this.commandExecutor.executeAsync(initAndExecuteCommand).thenApply(initAndExecuteCmdResult -> {
                    this.wasInitialized.set(true);
                    return initAndExecuteCmdResult.getData();
                });
            });
        });
    }
}

