/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.BucketProxy;
import io.github.bucket4j.distributed.proxy.RecoveryStrategy;
import io.github.bucket4j.distributed.proxy.RemoteBucketBuilder;
import io.github.bucket4j.distributed.proxy.optimization.Optimization;
import java.util.function.Function;
import java.util.function.Supplier;

public class RemoteBucketBuilderView<K, KeyOld>
implements RemoteBucketBuilder<K> {
    private final RemoteBucketBuilder<KeyOld> target;
    private final Function<K, KeyOld> mapper;

    public RemoteBucketBuilderView(RemoteBucketBuilder<KeyOld> target, Function<K, KeyOld> mapper) {
        this.target = target;
        this.mapper = mapper;
    }

    @Override
    public RemoteBucketBuilder<K> withRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
        this.target.withRecoveryStrategy(recoveryStrategy);
        return this;
    }

    @Override
    public RemoteBucketBuilder<K> withOptimization(Optimization optimization) {
        this.target.withOptimization(optimization);
        return this;
    }

    @Override
    public RemoteBucketBuilder<K> withImplicitConfigurationReplacement(long desiredConfigurationVersion, TokensInheritanceStrategy tokensInheritanceStrategy) {
        this.target.withImplicitConfigurationReplacement(desiredConfigurationVersion, tokensInheritanceStrategy);
        return this;
    }

    @Override
    public RemoteBucketBuilder<K> withListener(BucketListener listener) {
        this.target.withListener(listener);
        return this;
    }

    @Override
    public BucketProxy build(K key, Supplier<BucketConfiguration> configurationSupplier) {
        return this.target.build(this.mapper.apply(key), configurationSupplier);
    }

    @Override
    public BucketProxy build(K key, BucketConfiguration configuration) {
        return this.target.build(this.mapper.apply(key), configuration);
    }

    @Override
    public <K2> RemoteBucketBuilder<K2> withMapper(Function<? super K2, ? extends K> innerMapper) {
        return this.target.withMapper(this.mapper.compose(innerMapper));
    }
}

