/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiResult
implements ComparableByContent<MultiResult> {
    private final List<CommandResult<?>> results;
    public static final SerializationHandle<MultiResult> SERIALIZATION_HANDLE = new SerializationHandle<MultiResult>(){

        @Override
        public <S> MultiResult deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int size = adapter.readInt(input);
            ArrayList results = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                CommandResult<?> result = CommandResult.SERIALIZATION_HANDLE.deserialize(adapter, input);
                results.add(result);
            }
            return new MultiResult(results);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, MultiResult multiResult, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeInt(output, multiResult.results.size());
            for (CommandResult<?> result : multiResult.results) {
                CommandResult.SERIALIZATION_HANDLE.serialize(adapter, output, result, backwardCompatibilityVersion, scope);
            }
        }

        @Override
        public int getTypeId() {
            return 13;
        }

        @Override
        public Class<MultiResult> getSerializedType() {
            return MultiResult.class;
        }

        @Override
        public MultiResult fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            List resultSnapshots = (List)snapshot.get("results");
            ArrayList results = new ArrayList(resultSnapshots.size());
            for (Map resultSnapshot : resultSnapshots) {
                CommandResult<?> result = CommandResult.SERIALIZATION_HANDLE.fromJsonCompatibleSnapshot(resultSnapshot);
                results.add(result);
            }
            return new MultiResult(results);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(MultiResult multiResult, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> snapshot = new HashMap<String, Object>();
            snapshot.put("version", Versions.v_7_0_0.getNumber());
            ArrayList<Map<String, Object>> resultSnapshots = new ArrayList<Map<String, Object>>(multiResult.results.size());
            for (CommandResult<?> result : multiResult.results) {
                Map<String, Object> resultSnapshot = CommandResult.SERIALIZATION_HANDLE.toJsonCompatibleSnapshot(result, backwardCompatibilityVersion, scope);
                resultSnapshots.add(resultSnapshot);
            }
            snapshot.put("results", resultSnapshots);
            return snapshot;
        }

        @Override
        public String getTypeName() {
            return "MultiResult";
        }
    };

    public MultiResult(List<CommandResult<?>> results) {
        this.results = results;
    }

    public List<CommandResult<?>> getResults() {
        return this.results;
    }

    @Override
    public boolean equalsByContent(MultiResult other) {
        if (this.results.size() != other.results.size()) {
            return false;
        }
        for (int i = 0; i < this.results.size(); ++i) {
            CommandResult<?> result2;
            CommandResult<?> result1 = this.results.get(i);
            if (ComparableByContent.equals(result1, result2 = other.results.get(i))) continue;
            return false;
        }
        return true;
    }
}

