/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.VerboseResult;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.serialization.SerializationHandles;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class RemoteVerboseResult<T>
implements ComparableByContent<RemoteVerboseResult<?>> {
    private final long operationTimeNanos;
    private final int resultTypeId;
    private final T value;
    private final RemoteBucketState state;
    public static final SerializationHandle<RemoteVerboseResult<?>> SERIALIZATION_HANDLE = new SerializationHandle<RemoteVerboseResult<?>>(){

        @Override
        public <I> RemoteVerboseResult<?> deserialize(DeserializationAdapter<I> adapter, I input) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long operationTimeNanos = adapter.readLong(input);
            int typeId = adapter.readInt(input);
            SerializationHandle handle = SerializationHandles.CORE_HANDLES.getHandleByTypeId(typeId);
            Object result = handle.deserialize(adapter, input);
            RemoteBucketState state = RemoteBucketState.SERIALIZATION_HANDLE.deserialize(adapter, input);
            return new RemoteVerboseResult(operationTimeNanos, typeId, result, state);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, RemoteVerboseResult<?> result, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeLong(output, result.operationTimeNanos);
            adapter.writeInt(output, result.resultTypeId);
            SerializationHandle handle = SerializationHandles.CORE_HANDLES.getHandleByTypeId(result.resultTypeId);
            handle.serialize(adapter, output, result.value, backwardCompatibilityVersion, scope);
            RemoteBucketState.SERIALIZATION_HANDLE.serialize(adapter, output, result.state, backwardCompatibilityVersion, scope);
        }

        @Override
        public int getTypeId() {
            return 14;
        }

        @Override
        public Class<RemoteVerboseResult<?>> getSerializedType() {
            return RemoteVerboseResult.class;
        }

        @Override
        public RemoteVerboseResult<?> fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long operationTimeNanos = this.readLongValue(snapshot, "operationTimeNanos");
            Map valueSnapshot = (Map)snapshot.get("result");
            String valueTypeName = (String)valueSnapshot.get("type");
            SerializationHandle<?> valueHandle = SerializationHandles.CORE_HANDLES.getHandleByTypeName(valueTypeName);
            Object result = valueHandle.fromJsonCompatibleSnapshot(valueSnapshot);
            Map stateSnapshot = (Map)snapshot.get("remoteState");
            RemoteBucketState state = RemoteBucketState.SERIALIZATION_HANDLE.fromJsonCompatibleSnapshot(stateSnapshot);
            return new RemoteVerboseResult(operationTimeNanos, valueHandle.getTypeId(), result, state);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(RemoteVerboseResult<?> verboseResult, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("operationTimeNanos", verboseResult.operationTimeNanos);
            SerializationHandle valueHandle = SerializationHandles.CORE_HANDLES.getHandleByTypeId(verboseResult.resultTypeId);
            Map<String, Object> valueSnapshot = valueHandle.toJsonCompatibleSnapshot(verboseResult.value, backwardCompatibilityVersion, scope);
            valueSnapshot.put("type", valueHandle.getTypeName());
            result.put("result", valueSnapshot);
            Map<String, Object> stateSnapshot = RemoteBucketState.SERIALIZATION_HANDLE.toJsonCompatibleSnapshot(verboseResult.state, backwardCompatibilityVersion, scope);
            result.put("remoteState", stateSnapshot);
            return result;
        }

        @Override
        public String getTypeName() {
            return "RemoteVerboseResult";
        }
    };

    public RemoteVerboseResult(long operationTimeNanos, int resultTypeId, T value, RemoteBucketState state) {
        this.operationTimeNanos = operationTimeNanos;
        this.resultTypeId = resultTypeId;
        this.value = value;
        this.state = state;
    }

    public T getValue() {
        return this.value;
    }

    public RemoteBucketState getState() {
        return this.state;
    }

    public long getOperationTimeNanos() {
        return this.operationTimeNanos;
    }

    public VerboseResult<T> asLocal() {
        return new VerboseResult<T>(this.operationTimeNanos, this.value, this.state.copyBucketState());
    }

    public <R> RemoteVerboseResult<R> map(Function<T, R> mapper) {
        return new RemoteVerboseResult<R>(this.operationTimeNanos, this.resultTypeId, mapper.apply(this.value), this.state);
    }

    public <R> RemoteVerboseResult<R> withValue(R newValue) {
        return new RemoteVerboseResult<R>(this.operationTimeNanos, this.resultTypeId, newValue, this.state);
    }

    @Override
    public boolean equalsByContent(RemoteVerboseResult<?> other) {
        return this.operationTimeNanos == other.operationTimeNanos && this.resultTypeId == other.resultTypeId && ComparableByContent.equals(this.value, other.value) && ComparableByContent.equals(this.state, other.state);
    }
}

