/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTransactionsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TransactionState;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:size:medium")})
public class DeleteTenantIntegrationTest {
    private static final Long TEST_CACHE_RELOAD_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);
    private static final long TEST_MAX_WAIT_MS = TimeUnit.SECONDS.toMillis(60L);
    static final String KEY1 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"u-9\",", "  \"OrgResourceId\": \"org1\",", "  \"PkcId\": \"pkc1\"", "}");
    static final String VALUE1 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"9\",", "  \"ActiveLkcIds\": [\"lkc-abc\"]", "}");
    static final String KEY2 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"u-3\",", "  \"OrgResourceId\": \"org1\",", "  \"PkcId\": \"pkc1\"", "}");
    static final String VALUE2 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"3\",", "  \"ActiveLkcIds\": [\"lkc-xyz\"]", "}");
    private IntegrationTestHarness testHarness;
    private PhysicalCluster physicalCluster;
    private LogicalCluster lc1;
    private LogicalCluster lc2;
    private PhysicalClusterMetadata metadata;
    private String topic = "abcd";
    private List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic(this.topic, 3, 1));
    private final String userMetaDataTopic = "_confluent-user_metadata";
    private int adminUserId = 100;
    private Path tempDir;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.tempDir = TestUtils.tempDirectory().toPath();
        Utils.createLogicalClusterFile(KafkaLogicalClusterUtils.LC_META_ABC, this.tempDir);
        Utils.createLogicalClusterFile(KafkaLogicalClusterUtils.LC_META_XYZ, this.tempDir);
        this.testHarness = new IntegrationTestHarness(testInfo);
        this.physicalCluster = this.testHarness.startWithTopic("_confluent-user_metadata", 1, 1, 15000L, this.nodeProps(), this.controllerProps());
        this.lc1 = this.physicalCluster.createLogicalCluster(KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId(), this.adminUserId, 9, 11, 12);
        this.lc2 = this.physicalCluster.createLogicalCluster(KafkaLogicalClusterUtils.LC_META_XYZ.logicalClusterId(), this.adminUserId, 9, 11, 12);
        this.metadata = this.getPhysicalClusterMetadata(this.physicalCluster);
        TestUtils.waitForCondition(() -> this.metadata.logicalClusterIds().size() == 2, (String)"Expected metadata of new logical cluster to be present in metadata cache");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
    }

    private Properties controllerProps() throws IOException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.nodeProps());
        props.put("confluent.cdc.user.deletion.handler.enable", "true");
        return props;
    }

    private Properties nodeProps() throws IOException {
        Properties props = new Properties();
        props.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        props.put("multitenant.metadata.class", "io.confluent.kafka.multitenant.PhysicalClusterMetadata");
        props.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
        props.put("confluent.max.acls.per.tenant", "100");
        props.put("multitenant.metadata.reload.delay.ms", TEST_CACHE_RELOAD_DELAY_MS);
        props.put("multitenant.tenant.delete.delay", "0");
        props.put("confluent.close.connections.on.credential.delete", "true");
        props.put("confluent.cdc.user.metadata.topic", "_confluent-user_metadata");
        props.put("confluent.cdc.user.metadata.enable", "true");
        props.put("confluent.cdc.api.keys.topic.load.timeout.ms", (Object)15000L);
        props.put("confluent.multitenant.authorizer.enable.acl.state", "true");
        props.put("transactional.id.expiration.ms", "5000");
        props.put("transaction.state.log.num.partitions", "1");
        props.put("transaction.state.log.replication.factor", "1");
        props.put("transaction.state.log.min.isr", "1");
        return props;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDeleteSingleTenantWithOneTopic(String quorum) throws InterruptedException, IOException, ExecutionException {
        AdminClient adminClient1 = this.testHarness.createAdminClient(this.lc1.adminUser());
        AdminClient adminClient2 = this.testHarness.createAdminClient(this.lc2.adminUser());
        adminClient1.createTopics(this.sampleTopics).all().get();
        adminClient2.createTopics(this.sampleTopics).all().get();
        this.testHarness.ensureKraftMetadataConsistent();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        Assertions.assertTrue((boolean)((Set)adminClient1.listTopics().names().get()).containsAll(expectedTopics));
        Assertions.assertTrue((boolean)((Set)adminClient2.listTopics().names().get()).containsAll(expectedTopics));
        KafkaLogicalClusterMetadata deleted = this.deleteLogicalCluster(KafkaLogicalClusterUtils.LC_META_ABC);
        TestUtils.waitForCondition(() -> !this.metadata.logicalClusterIds().contains(deleted.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Expect that the tenant is gone");
        TestUtils.waitForCondition(() -> {
            try {
                return ((Set)adminClient2.listTopics().names().get()).containsAll(expectedTopics);
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting the topics to be present in other cluster");
        TestUtils.waitForCondition(() -> {
            try {
                return ((Set)adminClient1.listTopics().names().get()).size() == 0;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting that the tenant topics were deleted");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testTenantDeleteWhileClusterIsDown(String quorum) throws Exception {
        AdminClient adminClient1 = this.testHarness.createAdminClient(this.lc1.adminUser());
        AdminClient adminClient2 = this.testHarness.createAdminClient(this.lc2.adminUser());
        adminClient1.createTopics(this.sampleTopics).all().get();
        adminClient2.createTopics(this.sampleTopics).all().get();
        this.testHarness.ensureKraftMetadataConsistent();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        Assertions.assertTrue((boolean)((Set)adminClient1.listTopics().names().get()).containsAll(expectedTopics));
        Assertions.assertTrue((boolean)((Set)adminClient2.listTopics().names().get()).containsAll(expectedTopics));
        this.testHarness.shutdownBrokers();
        KafkaLogicalClusterMetadata deleted = this.deleteLogicalCluster(KafkaLogicalClusterUtils.LC_META_ABC);
        this.testHarness.startBrokers(this.nodeProps(), this.nodeProps());
        this.metadata = this.getPhysicalClusterMetadata(this.physicalCluster);
        AdminClient adminClient11 = this.testHarness.createAdminClient(this.lc1.adminUser());
        AdminClient adminClient22 = this.testHarness.createAdminClient(this.lc2.adminUser());
        Assertions.assertFalse((boolean)this.metadata.logicalClusterIds().contains(deleted.logicalClusterId()));
        TestUtils.waitForCondition(() -> {
            try {
                return ((Set)adminClient11.listTopics().names().get()).size() == 0;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting that the tenant topics were deleted");
        TestUtils.waitForCondition(() -> {
            try {
                return ((Set)adminClient22.listTopics().names().get()).size() > 0;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting non zero tenant topics count.");
        Set topics = (Set)adminClient22.listTopics().names().get();
        Assertions.assertTrue((boolean)topics.containsAll(expectedTopics), (String)("topics: " + String.valueOf(topics) + ", expected Topics: " + String.valueOf(expectedTopics)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDeleteSingleTenantWithACLs(String quorum) throws InterruptedException, IOException, ExecutionException {
        LogicalClusterUser user = this.lc1.user(9);
        LogicalClusterUser user2 = this.lc2.user(11);
        this.testHarness.newAclCommand().produceAclArgs(user.prefixedKafkaPrincipal(), user.withPrefix("topic1"), PatternType.LITERAL).execute();
        this.testHarness.newAclCommand().consumeAclArgs(user.prefixedKafkaPrincipal(), user.withPrefix("topic2."), user.withPrefix("group"), PatternType.PREFIXED).execute();
        this.testHarness.newAclCommand().produceAclArgs(user2.prefixedKafkaPrincipal(), user2.withPrefix("topic1"), PatternType.LITERAL).execute();
        AdminClient superClient = this.physicalCluster.superAdminClient();
        Collection describedAcls = (Collection)superClient.describeAcls(this.filterForUser(null)).values().get();
        Assertions.assertTrue((describedAcls.size() > 0 ? 1 : 0) != 0, (String)"ACLs should exist");
        KafkaLogicalClusterMetadata deleted = this.deleteLogicalCluster(KafkaLogicalClusterUtils.LC_META_ABC);
        TestUtils.waitForCondition(() -> !this.metadata.logicalClusterIds().contains(deleted.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Expect that the tenant is gone");
        TestUtils.waitForCondition(() -> {
            try {
                return ((Collection)superClient.describeAcls(this.filterForUser(user.prefixedKafkaPrincipal().toString())).values().get()).isEmpty();
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting that the tenant ACLs were deleted");
        describedAcls.clear();
        describedAcls = (Collection)superClient.describeAcls(this.filterForUser(user2.prefixedKafkaPrincipal().toString())).values().get();
        Assertions.assertTrue((describedAcls.size() > 0 ? 1 : 0) != 0, (String)"ACLs should exist");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDeleteSingleTenantWithSoftACLs(String quorum) throws InterruptedException, IOException, ExecutionException {
        int sequenceId = 0;
        LogicalClusterUser user1 = this.lc1.user(9);
        LogicalClusterUser user2 = this.lc2.addUser(this.physicalCluster.getOrCreateUser(3, false));
        this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++sequenceId, KEY1, VALUE1);
        this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++sequenceId, KEY2, VALUE2);
        String principal1 = user1.prefixedKafkaPrincipal().toString();
        String principal2 = user2.prefixedKafkaPrincipal().toString();
        this.testHarness.newAclCommand().produceAclArgs(user1.prefixedKafkaPrincipal(), user1.withPrefix("topic1"), PatternType.LITERAL).execute();
        this.testHarness.newAclCommand().produceAclArgs(user2.prefixedKafkaPrincipal(), user2.withPrefix("topic1"), PatternType.LITERAL).execute();
        AdminClient superClient = this.physicalCluster.superAdminClient();
        TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertFalse((boolean)((Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)superClient), (AclBindingFilter)this.filterForUser(null), (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.ANY).values().get()).isEmpty(), (String)"ACLs should exist"));
        this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++sequenceId, KEY1, null);
        this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++sequenceId, KEY2, null);
        TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertFalse((boolean)((Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)superClient), (AclBindingFilter)this.filterForUser(principal2), (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.DELETED).values().get()).isEmpty(), (String)"Soft ACLs should exist for User3"));
        KafkaLogicalClusterMetadata deleted = this.deleteLogicalCluster(KafkaLogicalClusterUtils.LC_META_XYZ);
        TestUtils.waitForCondition(() -> !this.metadata.logicalClusterIds().contains(deleted.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Expect that the tenant is gone");
        TestUtils.waitForCondition(() -> {
            try {
                return ((Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)superClient), (AclBindingFilter)this.filterForUser(principal2), (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.ANY).values().get()).isEmpty();
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting that the tenant soft ACLs were deleted");
        Collection describedAcls = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)superClient), (AclBindingFilter)this.filterForUser(principal1), (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.ANY).values().get();
        Assertions.assertFalse((boolean)describedAcls.isEmpty(), (String)"ACLs should exist for user1");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testHandleACLsDisabledCase(String quorum) throws Exception {
        Properties props = new Properties();
        props.put("broker.id", (Object)100);
        props.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        props.put("multitenant.metadata.class", "io.confluent.kafka.multitenant.PhysicalClusterMetadata");
        props.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
        props.put("multitenant.metadata.reload.delay.ms", TEST_CACHE_RELOAD_DELAY_MS);
        props.put("multitenant.tenant.delete.delay", "0");
        this.testHarness.shutdown();
        PhysicalCluster physicalCluster = this.testHarness.start(props);
        PhysicalClusterMetadata metadata = this.getPhysicalClusterMetadata(physicalCluster);
        Utils.createLogicalClusterFile(KafkaLogicalClusterUtils.LC_META_ABC, this.tempDir);
        KafkaLogicalClusterMetadata deleted1 = this.deleteLogicalCluster(KafkaLogicalClusterUtils.LC_META_ABC);
        TestUtils.waitForCondition(() -> metadata.tenantLifecycleManager.fullyDeletedClusters().contains(deleted1.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Expect that the tenants are gone");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDelayedDelete(String quorum) throws Exception {
        int delaySec = 10;
        Properties props = new Properties();
        props.put("broker.id", (Object)100);
        props.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        props.put("multitenant.metadata.class", "io.confluent.kafka.multitenant.PhysicalClusterMetadata");
        props.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
        props.put("multitenant.metadata.reload.delay.ms", TEST_CACHE_RELOAD_DELAY_MS);
        props.put("multitenant.tenant.delete.delay", (Object)TimeUnit.SECONDS.toMillis(delaySec));
        this.testHarness.shutdown();
        PhysicalCluster physicalCluster = this.testHarness.start(props);
        PhysicalClusterMetadata metadata = this.getPhysicalClusterMetadata(physicalCluster);
        Utils.createLogicalClusterFile(KafkaLogicalClusterUtils.LC_META_ABC, this.tempDir);
        TestUtils.waitForCondition(() -> metadata.logicalClusterIds().contains(KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Tenant wasn't created on time");
        KafkaLogicalClusterMetadata deleted = this.deleteLogicalCluster(KafkaLogicalClusterUtils.LC_META_ABC);
        TestUtils.waitForCondition(() -> !metadata.logicalClusterIds().contains(deleted.logicalClusterId()) && !metadata.tenantLifecycleManager.deletedClusters().contains(deleted.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Tenant should not be part of the cache but not deleted either");
        TestUtils.waitForCondition(() -> metadata.tenantLifecycleManager.fullyDeletedClusters().contains(deleted.logicalClusterId()), (long)TEST_MAX_WAIT_MS, (String)"Tenant was not deleted as expected");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDeleteCredentials(String quorum) throws Exception {
        AdminClient adminClient1 = this.testHarness.createAdminClient(this.lc1.adminUser());
        AdminClient adminClient2 = this.testHarness.createAdminClient(this.lc2.adminUser());
        adminClient1.createTopics(this.sampleTopics).all().get();
        adminClient2.createTopics(this.sampleTopics).all().get();
        this.testHarness.ensureKraftMetadataConsistent();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        Assertions.assertTrue((boolean)((Set)adminClient1.listTopics().names().get()).containsAll(expectedTopics));
        Assertions.assertTrue((boolean)((Set)adminClient2.listTopics().names().get()).containsAll(expectedTopics));
        this.lc1.deleteUserCredential(this.lc1.adminUser());
        TestUtils.waitForCondition(() -> {
            try {
                adminClient1.listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(5000))).names().get(10L, TimeUnit.SECONDS);
                return false;
            }
            catch (ExecutionException e) {
                return e.getCause() instanceof AuthenticationException;
            }
        }, (long)15000L, (String)"Expected connections to fail authentication");
        Assertions.assertTrue((boolean)((Set)adminClient2.listTopics().names().get()).containsAll(expectedTopics));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDeleteWithOngoingTransaction(String quorum) throws Exception {
        AdminClient adminClient1 = this.testHarness.createAdminClient(this.lc1.adminUser());
        adminClient1.createTopics(this.sampleTopics).all().get();
        this.testHarness.ensureKraftMetadataConsistent();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        Assertions.assertTrue((boolean)((Set)adminClient1.listTopics().names().get()).containsAll(expectedTopics));
        Properties properties = new Properties();
        properties.setProperty("transactional.id", "transactionalId");
        KafkaProducer<String, String> producer1 = this.testHarness.createProducer(this.lc1.adminUser(), SecurityProtocol.SASL_PLAINTEXT, properties);
        producer1.initTransactions();
        try {
            producer1.beginTransaction();
            producer1.send(new ProducerRecord(this.topic, (Object)"value")).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AdminClient superClient = this.physicalCluster.superAdminClient();
        ListTransactionsOptions options = new ListTransactionsOptions().filterStates(Collections.singletonList(TransactionState.ONGOING));
        TestUtils.waitForCondition(() -> {
            try {
                return ((Collection)superClient.listTransactions(options).all().get()).size() == 1;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Transaction never progressed to ongoing state.");
        this.deleteLogicalCluster(KafkaLogicalClusterUtils.LC_META_ABC);
        TestUtils.waitForCondition(() -> {
            try {
                return ((Collection)superClient.listTransactions(options).all().get()).isEmpty();
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting that the tenant topics were deleted");
        TestUtils.waitForCondition(() -> {
            try {
                return ((Set)adminClient1.listTopics().names().get()).isEmpty();
            }
            catch (Exception e) {
                return false;
            }
        }, (long)TEST_MAX_WAIT_MS, (String)"Expecting non zero tenant topics count.");
    }

    private KafkaLogicalClusterMetadata deleteLogicalCluster(KafkaLogicalClusterMetadata lkc) throws IOException {
        KafkaLogicalClusterMetadata deleted = new KafkaLogicalClusterMetadata(lkc.logicalClusterId(), lkc.physicalClusterId(), lkc.logicalClusterName(), lkc.accountId(), lkc.k8sClusterId(), lkc.logicalClusterType(), lkc.storageBytes(), lkc.producerByteRate(), lkc.consumerByteRate(), null, null, Long.valueOf(lkc.brokerRequestPercentage().longValue()), lkc.networkQuotaOverhead(), new KafkaLogicalClusterMetadata.LifecycleMetadata(lkc.lifecycleMetadata().logicalClusterName(), lkc.lifecycleMetadata().physicalK8sNamespace(), lkc.lifecycleMetadata().creationDate(), new Date()), null, null, lkc.organizationId(), lkc.environmentId(), Long.valueOf(lkc.brokerLinkRequestPercentage().longValue()), KafkaLogicalClusterUtils.ELASTIC_CKU_METADATA_DEFAULT, KafkaLogicalClusterUtils.CKU_COUNT, lkc.flexFanoutEnabled());
        Utils.updateLogicalClusterFile(deleted, this.tempDir);
        return deleted;
    }

    private PhysicalClusterMetadata getPhysicalClusterMetadata(PhysicalCluster physicalCluster) {
        PhysicalClusterMetadata metadata = (PhysicalClusterMetadata)physicalCluster.kafkaCluster().kafkaBrokers().get(0).multiTenantMetadata().get();
        return metadata;
    }

    private AclBindingFilter filterForUser(String principal) {
        return new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(principal, null, AclOperation.ANY, AclPermissionType.ANY));
    }
}

