/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.clients.plugins.auth.oauth.OAuthBearerLoginCallbackHandler;
import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.multitenant.TopicBasedPhysicalClusterMetadata;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthUtils;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.security.auth.oauth.mockserver.common.ServerFailedToConnectException;
import io.confluent.security.auth.oauth.mockserver.server.MockOAuthServer;
import io.confluent.security.auth.oauth.mockserver.server.TokenBuilder;
import io.confluent.security.auth.provider.oauth.EnhancedOAuthBearerValidatorCallbackHandler;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kafka.test.JarResourceLoader;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class JkuOAuthIntegrationTest {
    private static final String CONFLUENT_ISSUER = "Confluent";
    private static final String NON_CONFLUENT_ISSUER = "nonConfluent";
    private final String testTopic = "abcd3";
    private final List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd3", 1, 1));
    private final String lkcMetadataTopic = "_confluent-logical_clusters";
    private final String logicalClusterId = KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId();
    private final String orgResourceId = KafkaLogicalClusterUtils.LC_META_ABC.organizationId();
    private final Properties adminProperties = new Properties();
    private final String adminUserId = "100";
    private IntegrationTestHarness testHarness;
    private OAuthUtils.JwsContainer jwsContainer;
    private final AtomicInteger sequenceId;
    private TestInfo testInfo;
    private PhysicalCluster physicalCluster;
    private MockOAuthServer mockOAuthServer;
    private String token;
    private int authServerPort;

    public JkuOAuthIntegrationTest() {
        this.adminProperties.put("sasl.login.callback.handler.class", OAuthBearerLoginCallbackHandler.class.getName());
        this.adminUserId = "100";
        this.sequenceId = new AtomicInteger();
        this.authServerPort = 61578;
    }

    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) throws Exception {
        this.testInfo = testInfo;
    }

    private void setUp(String issuer) throws Exception {
        this.testHarness = new IntegrationTestHarness(this.testInfo, 1);
        long topicCreateTimeout = 15000L;
        this.jwsContainer = new OAuthUtils.Builder(0, null, "sub", this.orgResourceId).build();
        this.physicalCluster = this.testHarness.startWithTopic(Arrays.asList("_confluent-logical_clusters"), 1, 1, topicCreateTimeout, this.nodeProps(), this.nodeProps(), Optional.empty());
        this.physicalCluster.createLogicalCluster(this.logicalClusterId, Integer.parseInt("100"), new Integer[0]);
        this.setUpMockOauthServer(issuer);
        this.loadLkcMetadata();
    }

    private void setUpMockOauthServer(String issuer) throws Exception {
        this.mockOAuthServer = new MockOAuthServer();
        this.mockOAuthServer.startServer(this.authServerPort);
        this.mockOAuthServer.connectToServer();
        ArrayList<String> clustersAllowed = new ArrayList<String>();
        clustersAllowed.add(this.logicalClusterId);
        this.token = new TokenBuilder("clientSecret", "clientId", this.mockOAuthServer).setExpiry(100000).setIssuer(issuer).setSubject("sub_1").addClaims("userResourceId", "UR1").addClaims("userId", "UI1").addClaims("clusters", clustersAllowed).addClaims("orgResourceId", this.orgResourceId).build();
    }

    @AfterEach
    public void tearDown() throws Exception {
        try {
            this.testHarness.shutdown();
            this.mockOAuthServer.stopServer();
        }
        finally {
            KafkaTestUtils.verifyThreadCleanup();
        }
    }

    private Properties nodeProps() {
        Properties props = IntegrationTestHarness.defaultOAuthBrokerProps();
        Path pathToConfigFile = null;
        try {
            pathToConfigFile = JarResourceLoader.loadFileFromResourceWithClassLoader(this.getClass(), (String)"AuthConfigJku.yaml").toPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        props.put("listener.name.external.oauthbearer.sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required publicKeyPath=\"" + String.valueOf(this.jwsContainer.getPublicKeyFile().toPath()) + "\"authenticator.jwt.config.url=\"" + String.valueOf(pathToConfigFile) + "\";");
        props.put("listener.name.external.oauthbearer.sasl.server.callback.handler.class", EnhancedOAuthBearerValidatorCallbackHandler.class.getName());
        props.put("confluent.cdc.lkc.metadata.topic", "_confluent-logical_clusters");
        props.put("multitenant.metadata.class", TopicBasedPhysicalClusterMetadata.class.getName());
        return props;
    }

    private String clientJaasConfig(String jwsToken, String allowedCluster) {
        return "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required token=\"" + jwsToken + "\" cluster=\"" + allowedCluster + "\";";
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testValidDomainAuthenticatesSuccessfully(String quorum) throws Exception {
        try {
            this.setUp(CONFLUENT_ISSUER);
        }
        catch (ServerFailedToConnectException exception) {
            Assertions.fail();
        }
        Assertions.assertNotNull((Object)this.token);
        AdminClient client = this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.token, this.logicalClusterId), this.adminProperties);
        client.createTopics(this.sampleTopics).all().get();
        Assertions.assertNotNull((Object)this.token);
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        TestUtils.retryOnExceptionWithTimeout((long)30000L, () -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testInvalidDomainAuthenticatesFailure(String quorum) throws Exception {
        block4: {
            try {
                this.setUp(NON_CONFLUENT_ISSUER);
            }
            catch (ServerFailedToConnectException exception) {
                Assertions.fail();
            }
            Assertions.assertNotNull((Object)this.token);
            Class<SaslAuthenticationException> expectedException = SaslAuthenticationException.class;
            try {
                AdminClient client = this.testHarness.createOAuthAdminClient(this.clientJaasConfig(this.token, this.logicalClusterId), this.adminProperties);
                client.createTopics(this.sampleTopics).all().get();
                Assertions.fail((String)String.format("Expected admin command to throw a %s", expectedException));
            }
            catch (Exception e) {
                if (e.getCause().getClass() == expectedException) break block4;
                Assertions.fail((String)String.format("Expected admin command to throw a %s but it threw a %s", expectedException, e.getCause().getClass()));
            }
        }
    }

    public void loadLkcMetadata() {
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", this.sequenceId.incrementAndGet(), this.logicalClusterId, KafkaLogicalClusterUtils.LC_META_ABC);
    }
}

