/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class MultiTenantConfigIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    @Override
    protected void createPhysicalAndLogicalClusters(Properties brokerProperties) {
        super.createPhysicalAndLogicalClusters(brokerProperties);
        this.awaitMetadataPropagation();
    }

    @Override
    protected Properties nodeProps() {
        Properties props = super.nodeProps();
        props.put("confluent.plugins.topic.policy.replication.factor", "3");
        return props;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testCreateAndDeleteTopicLevelConfig(String quorum) throws Exception {
        this.setUp(6, Arrays.asList("0", "1", "2", "0", "1", "2"));
        this.createPhysicalAndLogicalClusters(this.nodeProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        String topicName = "test_topic";
        HashMap<String, String> configurations = new HashMap<String, String>();
        configurations.put("retention.ms", "100000");
        configurations.put("min.insync.replicas", "2");
        NewTopic newTopic = new NewTopic(topicName, 3, 3);
        client.createTopics(Collections.singleton(newTopic)).all().get();
        TestUtils.waitForCondition(() -> ((Set)client.listTopics().names().get()).contains(topicName), (String)"Topic was not created within timeout.");
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, topicName);
        List<AlterConfigOp> opAdds = configurations.entrySet().stream().map(entry -> new ConfigEntry((String)entry.getKey(), (String)entry.getValue())).map(configEntry -> new AlterConfigOp(configEntry, AlterConfigOp.OpType.SET)).toList();
        client.incrementalAlterConfigs(Collections.singletonMap(topicResource, opAdds)).all().get();
        TestUtils.waitForCondition(() -> {
            Config config = (Config)((KafkaFuture)client.describeConfigs(Collections.singleton(topicResource)).values().get(topicResource)).get();
            return configurations.entrySet().stream().map(entry -> ((String)entry.getValue()).equals(config.get((String)entry.getKey()).value())).reduce(true, (a, b) -> a != false && b != false);
        }, (String)"configurations were not set within timeout");
        List<AlterConfigOp> opDeletes = configurations.keySet().stream().map(s -> new ConfigEntry(s, "")).map(configEntry -> new AlterConfigOp(configEntry, AlterConfigOp.OpType.DELETE)).toList();
        client.incrementalAlterConfigs(Collections.singletonMap(topicResource, opDeletes)).all().get();
        TestUtils.waitForCondition(() -> {
            Config config = (Config)((KafkaFuture)client.describeConfigs(Collections.singleton(topicResource)).values().get(topicResource)).get();
            return configurations.entrySet().stream().map(entry -> !((String)entry.getValue()).equals(config.get((String)entry.getKey()).value())).reduce(true, (a, b) -> a != false && b != false);
        }, (String)"configurations were not deleted within timeout");
    }
}

