/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer;

import io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ConfluentServerAuthorizerKRaftUnitTest {
    @AfterEach
    public void tearDown() {
        KafkaTestUtils.verifyThreadCleanup();
    }

    @Test
    public void testBasicAuthorization() throws Exception {
        this.testBasicAuth(Optional.empty());
        this.testBasicAuth(Optional.of(Uuid.fromString((String)"EMpWdUr1Qt-t2vsqpyjgSg")));
    }

    private void testBasicAuth(Optional<Uuid> linkId) throws Exception {
        String clusterId = Uuid.randomUuid().toString();
        int brokerId = 0;
        ConfluentServerAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL);
        authorizer.completeInitialLoad();
        authorizer.applyAclChanges(Collections.singletonMap(Uuid.randomUuid(), Optional.of(new ConfluentStandardAcl(new StandardAcl(topicResource.resourceType(), topicResource.name(), topicResource.patternType(), AccessRule.WILDCARD_USER_PRINCIPAL.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW), linkId))));
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "ernie");
        RequestContext requestContext = this.sampleRequestContext(ApiKeys.FETCH, userPrincipal);
        Action allowedAction = new Action(AclOperation.READ, topicResource, 1, true, true);
        Action deniedAction = new Action(AclOperation.WRITE, topicResource, 1, true, true);
        Assertions.assertEquals(Arrays.asList(AuthorizationResult.ALLOWED, AuthorizationResult.DENIED), (Object)authorizer.authorize((AuthorizableRequestContext)requestContext, Arrays.asList(allowedAction, deniedAction)));
    }

    @Test
    public void testAclCreationReturnsNotControllerIfNoAclMutator() throws Exception {
        String clusterId = Uuid.randomUuid().toString();
        int brokerId = 0;
        ConfluentServerAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "ernie");
        RequestContext requestContext = this.sampleRequestContext(ApiKeys.CREATE_ACLS, userPrincipal);
        ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL);
        AccessControlEntry accessControlEntry = new AccessControlEntry(AccessRule.WILDCARD_USER_PRINCIPAL.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AclBinding aclBinding = new AclBinding(topicResource, accessControlEntry);
        Assertions.assertThrows(NotControllerException.class, () -> authorizer.createAcls((AuthorizableRequestContext)requestContext, Collections.singletonList(aclBinding)));
    }

    @Test
    public void testAclDeletionReturnsNotControllerIfNoAclMutator() throws Exception {
        String clusterId = Uuid.randomUuid().toString();
        int brokerId = 0;
        ConfluentServerAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "ernie");
        RequestContext requestContext = this.sampleRequestContext(ApiKeys.DELETE_ACLS, userPrincipal);
        ResourcePatternFilter topicResourceFilter = new ResourcePatternFilter(ResourceType.TOPIC, "foo", PatternType.LITERAL);
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(AccessRule.WILDCARD_USER_PRINCIPAL.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AclBindingFilter aclBindingFilter = new AclBindingFilter(topicResourceFilter, accessControlEntryFilter);
        Assertions.assertThrows(NotControllerException.class, () -> authorizer.deleteAcls((AuthorizableRequestContext)requestContext, Collections.singletonList(aclBindingFilter)));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "CLUSTER_AUTHORIZATION_FAILED"})
    public void testAclCreation(Errors error) throws Exception {
        String clusterId = Uuid.randomUuid().toString();
        int brokerId = 0;
        ConfluentServerAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        AclMutator aclMutator = (AclMutator)Mockito.mock(AclMutator.class);
        authorizer.setAclMutator(aclMutator);
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "ernie");
        RequestContext requestContext = this.sampleRequestContext(ApiKeys.CREATE_ACLS, userPrincipal);
        ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL);
        AccessControlEntry accessControlEntry = new AccessControlEntry(AccessRule.WILDCARD_USER_PRINCIPAL.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AclBinding aclBinding = new AclBinding(topicResource, accessControlEntry);
        CompletableFuture<List<AclCreateResult>> createAclFuture = new CompletableFuture<List<AclCreateResult>>();
        Mockito.when((Object)aclMutator.createAcls((ControllerRequestContext)ArgumentMatchers.any(ControllerRequestContext.class), (List)ArgumentMatchers.eq(Collections.singletonList(aclBinding)))).thenReturn(createAclFuture);
        Mockito.when((Object)aclMutator.createAcls((ControllerRequestContext)ArgumentMatchers.any(ControllerRequestContext.class), (List)ArgumentMatchers.eq(Collections.singletonList(aclBinding)), (AclState)ArgumentMatchers.any(AclState.class))).thenReturn(createAclFuture);
        List createAclRequestFutures = authorizer.createAcls((AuthorizableRequestContext)requestContext, Collections.singletonList(aclBinding));
        Assertions.assertEquals((int)1, (int)createAclRequestFutures.size());
        CompletableFuture createAclRequestFuture = ((CompletionStage)createAclRequestFutures.get(0)).toCompletableFuture();
        Assertions.assertFalse((boolean)createAclRequestFuture.isDone());
        if (error == Errors.NONE) {
            createAclFuture.complete(Collections.singletonList(AclCreateResult.SUCCESS));
            Assertions.assertTrue((boolean)createAclRequestFuture.isDone());
            Assertions.assertFalse((boolean)createAclRequestFuture.isCompletedExceptionally());
            Assertions.assertSame((Object)AclCreateResult.SUCCESS, createAclRequestFuture.get());
        } else {
            ApiException expectedException = error.exception();
            createAclFuture.completeExceptionally((Throwable)error.exception());
            Assertions.assertTrue((boolean)createAclRequestFuture.isDone());
            Assertions.assertFalse((boolean)createAclRequestFuture.isCompletedExceptionally());
            AclCreateResult result = (AclCreateResult)createAclRequestFuture.get();
            Assertions.assertEquals(Optional.of(expectedException), (Object)result.exception());
        }
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "CLUSTER_AUTHORIZATION_FAILED"})
    public void testAclDeletion(Errors error) throws Exception {
        String clusterId = Uuid.randomUuid().toString();
        int brokerId = 0;
        ConfluentServerAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        AclMutator aclMutator = (AclMutator)Mockito.mock(AclMutator.class);
        authorizer.setAclMutator(aclMutator);
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "ernie");
        RequestContext requestContext = this.sampleRequestContext(ApiKeys.DELETE_ACLS, userPrincipal);
        ResourcePatternFilter topicResourceFilter = new ResourcePatternFilter(ResourceType.TOPIC, "foo", PatternType.LITERAL);
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(AccessRule.WILDCARD_USER_PRINCIPAL.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AclBindingFilter aclBindingFilter = new AclBindingFilter(topicResourceFilter, accessControlEntryFilter);
        CompletableFuture<List<AclDeleteResult>> deleteAclFuture = new CompletableFuture<List<AclDeleteResult>>();
        Mockito.when((Object)aclMutator.deleteAcls((ControllerRequestContext)ArgumentMatchers.any(ControllerRequestContext.class), (List)ArgumentMatchers.eq(Collections.singletonList(aclBindingFilter)))).thenReturn(deleteAclFuture);
        Mockito.when((Object)aclMutator.deleteAcls((ControllerRequestContext)ArgumentMatchers.any(ControllerRequestContext.class), (List)ArgumentMatchers.eq(Collections.singletonList(aclBindingFilter)), (AclState)ArgumentMatchers.any(AclState.class))).thenReturn(deleteAclFuture);
        List deleteAclsRequestFutures = authorizer.deleteAcls((AuthorizableRequestContext)requestContext, Collections.singletonList(aclBindingFilter));
        Assertions.assertEquals((int)1, (int)deleteAclsRequestFutures.size());
        CompletableFuture deleteAclsRequestFuture = ((CompletionStage)deleteAclsRequestFutures.get(0)).toCompletableFuture();
        Assertions.assertFalse((boolean)deleteAclsRequestFuture.isDone());
        if (error == Errors.NONE) {
            AclBinding deletedAclBinding = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL), new AccessControlEntry(AccessRule.WILDCARD_USER_PRINCIPAL.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
            AclDeleteResult expectedResult = new AclDeleteResult(Collections.singletonList(new AclDeleteResult.AclBindingDeleteResult(deletedAclBinding)));
            deleteAclFuture.complete(Collections.singletonList(expectedResult));
            Assertions.assertTrue((boolean)deleteAclsRequestFuture.isDone());
            Assertions.assertFalse((boolean)deleteAclsRequestFuture.isCompletedExceptionally());
            Assertions.assertEquals((Object)expectedResult, deleteAclsRequestFuture.get());
        } else {
            ApiException expectedException = error.exception();
            deleteAclFuture.completeExceptionally((Throwable)error.exception());
            Assertions.assertTrue((boolean)deleteAclsRequestFuture.isDone());
            Assertions.assertFalse((boolean)deleteAclsRequestFuture.isCompletedExceptionally());
            AclDeleteResult result = (AclDeleteResult)deleteAclsRequestFuture.get();
            Assertions.assertEquals(Optional.of(expectedException), (Object)result.exception());
        }
    }

    private ConfluentServerAuthorizer createAndStartBrokerAuthorizer(String clusterId, int brokerId) {
        Endpoint endpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9092);
        Map<String, Object> configs = this.kraftBrokerConfig(brokerId, endpoint, Collections.singletonList(ConfluentBuiltInProviders.AccessRuleProviders.KRAFT_ACL));
        ConfluentServerAuthorizer authorizer = new ConfluentServerAuthorizer();
        authorizer.configure(configs);
        authorizer.start((AuthorizerServerInfo)this.serverInfo(clusterId, brokerId, endpoint));
        authorizer.completeInitialLoad();
        return authorizer;
    }

    private RequestContext sampleRequestContext(ApiKeys apiKey, KafkaPrincipal principal) throws Exception {
        return new RequestContext(new RequestHeader(apiKey, apiKey.latestVersion(), "ClientId", 0), "localhost:92342", InetAddress.getLocalHost(), principal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, true);
    }

    private Map<String, Object> baseBrokerConfig(Endpoint endpoint, List<ConfluentBuiltInProviders.AccessRuleProviders> providers) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("listeners", "PLAINTEXT://" + endpoint.host() + ":" + endpoint.port());
        configs.put("authorizer.class.name", ConfluentServerAuthorizer.class.getName());
        configs.put("confluent.multitenant.listener.names", "EXTERNAL");
        String providerString = providers.stream().map(Enum::name).collect(Collectors.joining(","));
        configs.put("confluent.authorizer.access.rule.providers", providerString);
        return configs;
    }

    private Map<String, Object> kraftBrokerConfig(int brokerId, Endpoint endpoint, List<ConfluentBuiltInProviders.AccessRuleProviders> providers) {
        Map<String, Object> configs = this.baseBrokerConfig(endpoint, providers);
        configs.put("controller.listener.names", "CONTROLLER");
        configs.put("process.roles", "broker");
        configs.put("controller.quorum.voters", "10@localhost:8092");
        configs.put("node.id", "" + brokerId);
        return configs;
    }

    private ConfluentAuthorizerServerInfo serverInfo(final String clusterId, final int brokerId, final Endpoint endpoint) {
        return new ConfluentAuthorizerServerInfo(){
            final /* synthetic */ ConfluentServerAuthorizerKRaftUnitTest this$0;
            {
                this.this$0 = this$0;
            }

            public ClusterResource clusterResource() {
                return new ClusterResource(clusterId);
            }

            public int brokerId() {
                return brokerId;
            }

            public Collection<Endpoint> endpoints() {
                return Collections.singleton(endpoint);
            }

            public Endpoint interBrokerEndpoint() {
                return endpoint;
            }

            public Collection<String> earlyStartListeners() {
                return Collections.emptyList();
            }

            public Metrics metrics() {
                return new Metrics();
            }

            public Map<String, ?> interBrokerClientConfig() {
                return Collections.singletonMap("bootstrap.servers", "localhost:" + endpoint.port());
            }
        };
    }
}

