/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.token;

import io.confluent.kafka.clients.plugins.auth.jwt.JwtVerificationException;
import io.confluent.kafka.server.plugins.auth.token.TokenBearerValidatorCallbackHandler;
import io.confluent.kafka.test.utils.TokenTestUtils;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TokenBearerValidatorCallbackHandlerTest {
    private TokenTestUtils.JwsContainer jwsContainer;
    private String defaultIssuer = "Confluent";
    private String defaultSubject = "Customer";
    private Map<String, Object> configs;
    private final Path tempDir = TestUtils.tempDirectory().toPath();

    @BeforeEach
    public void setUp() throws Exception {
        this.configs = new HashMap<String, Object>();
        this.configs.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testAttachesJws() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, this.defaultIssuer, this.defaultSubject);
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.token());
        Assertions.assertEquals((Object)this.jwsContainer.getJwsToken(), (Object)callback.token().value());
        Assertions.assertNull((Object)callback.errorStatus());
    }

    @Test
    public void testConfigureRaisesExceptionWhenInvalidKeyPath() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, this.defaultIssuer, this.defaultSubject);
        Map<String, String> options = this.baseOptions();
        options.put("publicKeyPath", this.jwsContainer.getPublicKeyFile().getAbsolutePath() + "/invalid!");
        Assertions.assertThrows(ConfigException.class, () -> this.createCallbackHandler(options));
    }

    @Test
    public void testRaisesJwtExceptionWhenInvalidJws() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, this.defaultIssuer, this.defaultSubject);
        TokenTestUtils.writePemFile(this.jwsContainer.getPublicKeyFile(), TokenTestUtils.generateKeyPair().getPublic());
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    @Test
    public void testRaisesJwtExceptionWhenExpiredJws() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(50, this.defaultIssuer, this.defaultSubject);
        Thread.sleep(100L);
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    @Test
    public void testRaisesJwtExceptionIfDifferentIssuer() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, "AWS", this.defaultSubject);
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    @Test
    public void testRaisesJwtExceptionIfMissingSubject() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, this.defaultIssuer, null);
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    @Test
    public void testRaisesJwtExceptionIfNoExpirationTime() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(null, this.defaultIssuer, this.defaultSubject);
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    private TokenBearerValidatorCallbackHandler createCallbackHandler(Map<String, String> options) {
        TestJaasConfig config = new TestJaasConfig();
        config.createOrUpdateEntry("Kafka", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule", options);
        TokenBearerValidatorCallbackHandler callbackHandler = new TokenBearerValidatorCallbackHandler();
        callbackHandler.configure(this.configs, "OAUTHBEARER", Collections.singletonList(config.getAppConfigurationEntry("Kafka")[0]));
        return callbackHandler;
    }

    private Map<String, String> baseOptions() throws Exception {
        if (this.jwsContainer == null) {
            this.jwsContainer = TokenTestUtils.setUpJws(36000, this.defaultIssuer, this.defaultSubject);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("publicKeyPath", this.jwsContainer.getPublicKeyFile().getAbsolutePath());
        options.put("audience", String.join((CharSequence)",", new CharSequence[0]));
        return options;
    }
}

